/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import java.util.regex.Pattern;

class ValueDiscovery {
    private static final Pattern longPattern = Pattern.compile("^(0x[0-9a-fA-F]+)|[+\\-]?0|[+\\-]?[1-9][0-9]{0,18}$");
    private static final Pattern doublePattern = Pattern.compile("^[+\\-]?(([0-9]*\\.[0-9]+([eE][+-]?[0-9]+)?)|([1-9][0-9]{0,18}([eE][+-]?[0-9]+)?)|(0x[0-9a-fA-F]+\\.[0-9a-fA-F]+[pP][+\\-]?[0-9]+))$");

    ValueDiscovery() {
    }

    static Result discover(String value) {
        long len = value.length();
        if (len == 0L || len > 32L) {
            return Result.STRING;
        }
        char firstChar = value.charAt(0);
        if (firstChar < '0' || firstChar > '9') {
            if (firstChar == 'N' && len == 3L && value.equals("NaN")) {
                return Result.DOUBLE;
            }
            if (firstChar == 'I' && len == 8L && value.equals("Infinity")) {
                return Result.DOUBLE;
            }
            if (firstChar == '+' && len == 9L && value.equals("+Infinity")) {
                return Result.DOUBLE;
            }
            if (firstChar == '-' && len == 9L && value.equals("-Infinity")) {
                return Result.DOUBLE;
            }
            if (firstChar != '-' && firstChar != '+') {
                return Result.STRING;
            }
        }
        boolean numbersOnly = true;
        int pos = 0;
        while ((long)pos < Math.min(len, 20L)) {
            char c = value.charAt(pos);
            if (!((numbersOnly &= c >= '0' && c <= '9') || c == '+' || c == '-' || c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == '.' || c == 'x' || c == 'X' || c == 'p' || c == 'P')) {
                return Result.STRING;
            }
            ++pos;
        }
        if (numbersOnly) {
            if (len == 1L) {
                return Result.LONG;
            }
            if (len <= 19L && firstChar != '0') {
                return Result.LONG;
            }
            return Result.STRING;
        }
        if (longPattern.matcher(value).matches()) {
            return Result.LONG;
        }
        if (doublePattern.matcher(value).matches()) {
            return Result.DOUBLE;
        }
        return Result.STRING;
    }

    static enum Result {
        STRING,
        LONG,
        DOUBLE;

    }
}

