/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.OutputAccessor;
import biz.paluch.logging.gelf.intern.PoolHolder;
import biz.paluch.logging.gelf.intern.ReusableGzipOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

class PoolingGelfMessage
extends GelfMessage {
    private final PoolHolder poolHolder;

    public PoolingGelfMessage(PoolHolder poolHolder) {
        this.poolHolder = poolHolder;
    }

    public PoolingGelfMessage(String shortMessage, String fullMessage, long timestamp, String level, PoolHolder poolHolder) {
        super(shortMessage, fullMessage, timestamp, level);
        this.poolHolder = poolHolder;
    }

    @Override
    public void toJson(ByteBuffer byteBuffer, String additionalFieldPrefix) {
        this.toJson(OutputAccessor.from(this.poolHolder.getOutputAccessorPoolHolder(), byteBuffer), additionalFieldPrefix);
    }

    @Override
    public ByteBuffer[] toUDPBuffers(ByteBuffer buffer, ByteBuffer tempBuffer) {
        try {
            this.toJson(buffer, "_");
            OutputAccessor.asStream(this.poolHolder.getOutputAccessorPoolHolder(), tempBuffer);
            ReusableGzipOutputStream gz = this.poolHolder.getReusableGzipOutputStream();
            gz.reset();
            gz.writeHeader();
            buffer.mark();
            this.gzip(buffer, gz);
            gz.finish();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (tempBuffer.position() > this.getMaximumMessageSize()) {
            int diagramsLength = tempBuffer.position() / this.getMaximumMessageSize();
            if (tempBuffer.position() % this.getMaximumMessageSize() != 0) {
                ++diagramsLength;
            }
            buffer.clear();
            return this.sliceDatagrams((ByteBuffer)tempBuffer.flip(), diagramsLength, buffer);
        }
        ByteBuffer[] byteBuffers = this.poolHolder.getSingleBuffer();
        byteBuffers[0] = (ByteBuffer)tempBuffer.flip();
        return byteBuffers;
    }

    private void gzip(ByteBuffer source, ReusableGzipOutputStream gz) throws IOException {
        int size = source.position();
        if (source.isDirect()) {
            int read = 0;
            source.position(0);
            byte[] bytes = this.poolHolder.getByteArray();
            while (size > read) {
                if (size - read > bytes.length) {
                    read += bytes.length;
                    source.get(bytes);
                    gz.write(bytes);
                    continue;
                }
                int remain = size - read;
                read += remain;
                source.get(bytes, 0, remain);
                gz.write(bytes, 0, remain);
            }
        } else {
            gz.write(source.array(), source.arrayOffset(), source.position());
        }
    }
}

