/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class ClientTemplateEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String clientTemplateId;

    public static ClientTemplateEvent create(String clientTemplateId) {
        ClientTemplateEvent event = new ClientTemplateEvent();
        event.clientTemplateId = clientTemplateId;
        return event;
    }

    @Override
    public String getId() {
        return this.clientTemplateId;
    }

    public String toString() {
        return "ClientTemplateEvent [ " + this.clientTemplateId + " ]";
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientTemplateEvent that = (ClientTemplateEvent)o;
        return Objects.equals(this.clientTemplateId, that.clientTemplateId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientTemplateId);
    }

    public static class ExternalizerImpl
    implements Externalizer<ClientTemplateEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ClientTemplateEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.clientTemplateId, (ObjectOutput)output);
        }

        public ClientTemplateEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ClientTemplateEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ClientTemplateEvent res = new ClientTemplateEvent();
            res.clientTemplateId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

