/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.provider.ProviderEvent;

public interface GroupModel
extends RoleMapperModel {
    public static final Comparator<GroupModel> COMPARE_BY_NAME = Comparator.comparing(GroupModel::getName);

    public String getId();

    public String getName();

    public void setName(String var1);

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    public String getFirstAttribute(String var1);

    public Stream<String> getAttributeStream(String var1);

    public Map<String, List<String>> getAttributes();

    public GroupModel getParent();

    public String getParentId();

    public Stream<GroupModel> getSubGroupsStream();

    default public Stream<GroupModel> getSubGroupsStream(String search, Integer firstResult, Integer maxResults) {
        return this.getSubGroupsStream(search, false, firstResult, maxResults);
    }

    default public Stream<GroupModel> getSubGroupsStream(Integer firstResult, Integer maxResults) {
        return this.getSubGroupsStream(null, firstResult, maxResults);
    }

    default public Stream<GroupModel> getSubGroupsStream(String search, Boolean exact, Integer firstResult, Integer maxResults) {
        Stream<GroupModel> allSubgorupsGroups = this.getSubGroupsStream().filter(group -> {
            if (search == null || search.isEmpty()) {
                return true;
            }
            if (Boolean.TRUE.equals(exact)) {
                return group.getName().equals(search);
            }
            return group.getName().toLowerCase().contains(search.toLowerCase());
        });
        if (firstResult != null && firstResult > 0) {
            allSubgorupsGroups = allSubgorupsGroups.skip(firstResult.intValue());
        }
        if (maxResults != null && maxResults >= 0) {
            allSubgorupsGroups = allSubgorupsGroups.limit(maxResults.intValue());
        }
        return allSubgorupsGroups;
    }

    default public Long getSubGroupsCount() {
        return this.getSubGroupsStream().count();
    }

    public void setParent(GroupModel var1);

    public void addChild(GroupModel var1);

    public void removeChild(GroupModel var1);

    public static interface GroupPathChangeEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public String getNewPath();

        public String getPreviousPath();

        public KeycloakSession getKeycloakSession();
    }

    public static interface GroupRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public GroupModel getGroup();

        public KeycloakSession getKeycloakSession();
    }
}

