/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import io.smallrye.config.ConfigValue;
import java.io.PrintWriter;
import java.nio.file.FileSystemException;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.platform.Platform;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.InitializationException;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.ShortErrorMessageHandler;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;
import picocli.CommandLine;

public final class ExecutionExceptionHandler
implements CommandLine.IExecutionExceptionHandler {
    private Logger logger;
    private boolean verbose;

    public int handleExecutionException(Exception cause, CommandLine cmd, CommandLine.ParseResult parseResult) {
        if (cause instanceof PropertyException) {
            PrintWriter writer = cmd.getErr();
            writer.println(cmd.getColorScheme().errorText(cause.getMessage()));
            return ShortErrorMessageHandler.getInvalidInputExitCode(cause, cmd);
        }
        this.error(cmd.getErr(), "Failed to run '" + parseResult.subcommands().stream().map(CommandLine.ParseResult::commandSpec).map(CommandLine.Model.CommandSpec::name).findFirst().orElse(Environment.getCommand()) + "' command.", cause);
        return cmd.getCommandSpec().exitCodeOnExecutionException();
    }

    public void error(PrintWriter errorWriter, String message, Throwable cause) {
        if (message != null) {
            this.logError(errorWriter, "ERROR: " + message);
        }
        if (cause != null) {
            if (cause instanceof InitializationException) {
                InitializationException initializationException = (InitializationException)cause;
                if (initializationException.getSuppressed() == null || initializationException.getSuppressed().length == 0) {
                    this.dumpException(errorWriter, initializationException);
                } else if (initializationException.getSuppressed().length == 1) {
                    this.dumpException(errorWriter, initializationException.getSuppressed()[0]);
                } else {
                    this.logError(errorWriter, "ERROR: Multiple configuration errors during startup");
                    int counter = 0;
                    for (Throwable inner : initializationException.getSuppressed()) {
                        this.logError(errorWriter, "ERROR " + ++counter);
                        this.dumpException(errorWriter, inner);
                    }
                }
            } else {
                this.dumpException(errorWriter, cause);
            }
            if (!this.verbose) {
                this.logError(errorWriter, "For more details run the same command passing the '--verbose' option. Also you can use '--help' to see the details about the usage of the particular command.");
            }
        }
    }

    private void dumpException(PrintWriter errorWriter, Throwable cause) {
        if (this.verbose) {
            this.logError(errorWriter, cause == null ? "Unknown error." : "Error details:", cause);
        } else {
            do {
                if (cause.getMessage() != null) {
                    this.logError(errorWriter, String.format("ERROR: %s", cause.getMessage()));
                }
                this.printErrorHints(errorWriter, cause);
            } while ((cause = cause.getCause()) != null);
        }
        this.printErrorHints(errorWriter, cause);
    }

    private void printErrorHints(PrintWriter errorWriter, Throwable cause) {
        if (cause instanceof FileSystemException) {
            FileSystemException fse = (FileSystemException)cause;
            ConfigValue httpsCertFile = Configuration.getConfig().getConfigValue("kc.https-certificate-file");
            if (fse.getFile().equals(Optional.ofNullable(httpsCertFile.getValue()).orElse(null))) {
                this.logError(errorWriter, Messages.httpsConfigurationNotSet().getMessage());
            }
        }
    }

    private void logError(PrintWriter errorWriter, String errorMessage) {
        this.logError(errorWriter, errorMessage, null);
    }

    private void logError(PrintWriter errorWriter, String errorMessage, Throwable cause) {
        QuarkusPlatform platform = (QuarkusPlatform)Platform.getPlatform();
        if (platform.isStarted()) {
            if (cause == null) {
                this.getLogger().error((Object)errorMessage);
            } else {
                this.getLogger().error((Object)errorMessage, cause);
            }
        } else if (cause == null) {
            errorWriter.println(errorMessage);
        } else {
            errorWriter.println(errorMessage);
            cause.printStackTrace(errorWriter);
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(ExecutionExceptionHandler.class);
        }
        return this.logger;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

