/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.AssignabilityCheck;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.BeanInfoImpl;
import io.quarkus.arc.processor.bcextensions.DotNames;
import io.quarkus.arc.processor.bcextensions.ExtensionInvoker;
import io.quarkus.arc.processor.bcextensions.ExtensionMethod;
import io.quarkus.arc.processor.bcextensions.ExtensionMethodParameter;
import io.quarkus.arc.processor.bcextensions.ExtensionPhase;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseBase;
import io.quarkus.arc.processor.bcextensions.ObserverInfoImpl;
import io.quarkus.arc.processor.bcextensions.SharedErrors;
import io.quarkus.arc.processor.bcextensions.TypesImpl;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class ExtensionPhaseRegistration
extends ExtensionPhaseBase {
    private final AllAnnotationOverlays annotationOverlays;
    private final Collection<BeanInfo> allBeans;
    private final Collection<ObserverInfo> allObservers;
    private final AssignabilityCheck assignability;

    ExtensionPhaseRegistration(ExtensionInvoker invoker, IndexView beanArchiveIndex, SharedErrors errors, AllAnnotationOverlays annotationOverlays, Collection<BeanInfo> allBeans, Collection<ObserverInfo> allObservers) {
        super(ExtensionPhase.REGISTRATION, invoker, beanArchiveIndex, errors);
        this.annotationOverlays = annotationOverlays;
        this.allBeans = allBeans;
        this.allObservers = allObservers;
        this.assignability = new AssignabilityCheck(beanArchiveIndex, null);
    }

    @Override
    void runExtensionMethod(ExtensionMethod method) throws ReflectiveOperationException {
        int numQueryParameters = 0;
        ArrayList<ExtensionMethodParameter> parameters = new ArrayList<ExtensionMethodParameter>(method.parametersCount());
        for (Type parameterType : method.parameterTypes()) {
            ExtensionMethodParameter parameter = ExtensionMethodParameter.of(parameterType);
            parameters.add(parameter);
            if (parameter.isQuery()) {
                ++numQueryParameters;
            }
            parameter.verifyAvailable(ExtensionPhase.REGISTRATION, method);
        }
        if (numQueryParameters == 0) {
            throw new DefinitionException("No parameter of type BeanInfo or ObserverInfo for method " + method);
        }
        if (numQueryParameters > 1) {
            throw new DefinitionException("More than 1 parameter of type BeanInfo or ObserverInfo for method " + method);
        }
        ExtensionMethodParameter query = parameters.stream().filter(ExtensionMethodParameter::isQuery).findAny().get();
        List<Object> allValuesForQueryParameter = Collections.emptyList();
        if (query == ExtensionMethodParameter.BEAN_INFO) {
            allValuesForQueryParameter = this.matchingBeans(method.jandex, false);
        } else if (query == ExtensionMethodParameter.INTERCEPTOR_INFO) {
            allValuesForQueryParameter = this.matchingBeans(method.jandex, true);
        } else if (query == ExtensionMethodParameter.OBSERVER_INFO) {
            allValuesForQueryParameter = this.matchingObservers(method.jandex);
        }
        for (Object queryParameterValue : allValuesForQueryParameter) {
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (ExtensionMethodParameter parameter : parameters) {
                Object argument = parameter.isQuery() ? queryParameterValue : this.argumentForExtensionMethod(parameter, method);
                arguments.add(argument);
            }
            this.util.callExtensionMethod(method, arguments);
        }
    }

    private Set<Type> expectedTypes(MethodInfo jandexMethod) {
        Type[] annotationValue = jandexMethod.annotation(DotNames.REGISTRATION).value("types").asClassArray();
        return Set.of(annotationValue);
    }

    private List<jakarta.enterprise.inject.build.compatible.spi.BeanInfo> matchingBeans(MethodInfo jandexMethod, boolean onlyInterceptors) {
        Set<Type> expectedTypes = this.expectedTypes(jandexMethod);
        return this.allBeans.stream().filter(bean -> {
            if (onlyInterceptors && !bean.isInterceptor()) {
                return false;
            }
            for (Type type : bean.getTypes()) {
                if (!expectedTypes.contains(type)) continue;
                return true;
            }
            return false;
        }).map(it -> BeanInfoImpl.create(this.index, this.annotationOverlays, it)).collect(Collectors.toUnmodifiableList());
    }

    private List<jakarta.enterprise.inject.build.compatible.spi.ObserverInfo> matchingObservers(MethodInfo jandexMethod) {
        Set<Type> expectedTypes = this.expectedTypes(jandexMethod);
        return this.allObservers.stream().filter(observer -> {
            Type observedType = observer.getObservedType();
            for (Type expectedType : expectedTypes) {
                if (!this.assignability.isAssignableFrom(expectedType, observedType)) continue;
                return true;
            }
            return false;
        }).map(it -> new ObserverInfoImpl(this.index, this.annotationOverlays, (ObserverInfo)it)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    Object argumentForExtensionMethod(ExtensionMethodParameter type, ExtensionMethod method) {
        if (type == ExtensionMethodParameter.TYPES) {
            return new TypesImpl(this.index, this.annotationOverlays);
        }
        return super.argumentForExtensionMethod(type, method);
    }
}

