/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.Transformation;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public interface AnnotationsTransformer
extends BuildExtension {
    default public boolean appliesTo(AnnotationTarget.Kind kind) {
        return true;
    }

    public void transform(TransformationContext var1);

    public static Builder builder() {
        return new Builder();
    }

    public static MethodTransformerBuilder appliedToMethod() {
        return new MethodTransformerBuilder();
    }

    public static FieldTransformerBuilder appliedToField() {
        return new FieldTransformerBuilder();
    }

    public static ClassTransformerBuilder appliedToClass() {
        return new ClassTransformerBuilder();
    }

    public static abstract class AbstractBuilder<THIS extends AbstractBuilder<THIS>>
    implements Predicate<AnnotationTarget.Kind> {
        protected int priority = 1000;
        protected Predicate<TransformationContext> predicate;

        private AbstractBuilder() {
        }

        public THIS priority(int priority) {
            this.priority = priority;
            return this.self();
        }

        public THIS whenContainsAll(List<DotName> annotationNames) {
            return this.when(context -> {
                for (DotName annotationName : annotationNames) {
                    if (Annotations.contains(context.getAnnotations(), annotationName)) continue;
                    return false;
                }
                return true;
            });
        }

        public THIS whenContainsAll(DotName ... annotationNames) {
            return this.whenContainsAll(List.of(annotationNames));
        }

        @SafeVarargs
        public final THIS whenContainsAll(Class<? extends Annotation> ... annotationNames) {
            return this.whenContainsAll(Arrays.stream(annotationNames).map(a -> DotName.createSimple((String)a.getName())).collect(Collectors.toList()));
        }

        public THIS whenContainsAny(List<DotName> annotationNames) {
            return this.when(context -> Annotations.containsAny(context.getAnnotations(), annotationNames));
        }

        public THIS whenContainsAny(DotName ... annotationNames) {
            return this.whenContainsAny(List.of(annotationNames));
        }

        @SafeVarargs
        public final THIS whenContainsAny(Class<? extends Annotation> ... annotationNames) {
            return this.whenContainsAny(Arrays.stream(annotationNames).map(a -> DotName.createSimple((String)a.getName())).collect(Collectors.toList()));
        }

        public THIS whenContainsNone(List<DotName> annotationNames) {
            return this.when(context -> !Annotations.containsAny(context.getAnnotations(), annotationNames));
        }

        public THIS whenContainsNone(DotName ... annotationNames) {
            return this.whenContainsNone(List.of(annotationNames));
        }

        @SafeVarargs
        public final THIS whenContainsNone(Class<? extends Annotation> ... annotationNames) {
            return this.whenContainsNone(Arrays.stream(annotationNames).map(a -> DotName.createSimple((String)a.getName())).collect(Collectors.toList()));
        }

        public THIS when(Predicate<TransformationContext> when) {
            this.predicate = this.predicate == null ? when : this.predicate.and(when);
            return this.self();
        }

        public AnnotationsTransformer thenTransform(Consumer<Transformation> consumer) {
            final Consumer<Transformation> transform = Objects.requireNonNull(consumer);
            return this.transform(new Consumer<TransformationContext>(){

                @Override
                public void accept(TransformationContext context) {
                    Transformation transformation = context.transform();
                    transform.accept(transformation);
                    transformation.done();
                }
            });
        }

        public AnnotationsTransformer transform(Consumer<TransformationContext> consumer) {
            final int priority = this.priority;
            final Consumer<TransformationContext> transform = Objects.requireNonNull(consumer);
            final Predicate<TransformationContext> predicate = this.predicate;
            return new AnnotationsTransformer(){

                @Override
                public int getPriority() {
                    return priority;
                }

                @Override
                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return this.test(kind);
                }

                @Override
                public void transform(TransformationContext context) {
                    if (predicate == null || predicate.test(context)) {
                        transform.accept(context);
                    }
                }
            };
        }

        protected THIS self() {
            return (THIS)this;
        }

        protected <TARGET> Predicate<TransformationContext> wrap(final Predicate<TARGET> condition, final Function<TransformationContext, TARGET> extractor) {
            return new Predicate<TransformationContext>(){

                @Override
                public boolean test(TransformationContext ctx) {
                    return condition.test(extractor.apply(ctx));
                }
            };
        }
    }

    public static final class ClassTransformerBuilder
    extends AbstractBuilder<ClassTransformerBuilder> {
        public ClassTransformerBuilder whenClass(Predicate<ClassInfo> condition) {
            return (ClassTransformerBuilder)this.when(this.wrap(condition, ClassTransformerBuilder::extract));
        }

        @Override
        public boolean test(AnnotationTarget.Kind kind) {
            return kind == AnnotationTarget.Kind.CLASS;
        }

        private static ClassInfo extract(TransformationContext ctx) {
            return ctx.getTarget().asClass();
        }
    }

    public static final class FieldTransformerBuilder
    extends AbstractBuilder<FieldTransformerBuilder> {
        public FieldTransformerBuilder whenField(Predicate<FieldInfo> condition) {
            return (FieldTransformerBuilder)this.when(this.wrap(condition, FieldTransformerBuilder::extract));
        }

        @Override
        public boolean test(AnnotationTarget.Kind kind) {
            return kind == AnnotationTarget.Kind.FIELD;
        }

        private static FieldInfo extract(TransformationContext ctx) {
            return ctx.getTarget().asField();
        }
    }

    public static final class MethodTransformerBuilder
    extends AbstractBuilder<MethodTransformerBuilder> {
        public MethodTransformerBuilder whenMethod(Predicate<MethodInfo> condition) {
            return (MethodTransformerBuilder)this.when(this.wrap(condition, MethodTransformerBuilder::extract));
        }

        @Override
        public boolean test(AnnotationTarget.Kind kind) {
            return kind == AnnotationTarget.Kind.METHOD;
        }

        private static MethodInfo extract(TransformationContext ctx) {
            return ctx.getTarget().asMethod();
        }
    }

    public static final class Builder
    extends AbstractBuilder<Builder> {
        protected Predicate<AnnotationTarget.Kind> appliesTo;

        public Builder appliesTo(AnnotationTarget.Kind appliesToKind) {
            return this.appliesTo((AnnotationTarget.Kind kind) -> kind == appliesToKind);
        }

        public Builder appliesTo(Predicate<AnnotationTarget.Kind> appliesTo) {
            this.appliesTo = appliesTo;
            return this;
        }

        @Override
        public boolean test(AnnotationTarget.Kind kind) {
            return this.appliesTo == null || this.appliesTo.test(kind);
        }
    }

    public static interface TransformationContext
    extends BuildExtension.BuildContext {
        public AnnotationTarget getTarget();

        public Collection<AnnotationInstance> getAnnotations();

        public Transformation transform();

        default public boolean isClass() {
            return this.getTarget().kind() == AnnotationTarget.Kind.CLASS;
        }

        default public boolean isField() {
            return this.getTarget().kind() == AnnotationTarget.Kind.FIELD;
        }

        default public boolean isMethod() {
            return this.getTarget().kind() == AnnotationTarget.Kind.METHOD;
        }
    }
}

