/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.serialization;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;

public class TypeDelegatingEntityWriter
implements EntityWriter {
    private final Map<Class<?>, EntityWriter> typeMap;

    public TypeDelegatingEntityWriter(Map<Class<?>, EntityWriter> typeMap) {
        this.typeMap = typeMap;
    }

    @Override
    public void write(ResteasyReactiveRequestContext context, Object entity) throws IOException {
        for (Class<?> c = entity.getClass(); c != null; c = c.getSuperclass()) {
            EntityWriter delegate = this.typeMap.get(c);
            if (delegate == null) continue;
            delegate.write(context, entity);
            return;
        }
        throw new InternalServerErrorException("Could not find MessageBodyWriter for " + entity.getClass(), Response.serverError().build());
    }
}

