/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMTHA;
import com.webauthn4j.data.attestation.statement.TPMUAttest;
import com.webauthn4j.data.attestation.statement.TPMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TPMSCertifyInfo
implements TPMUAttest {
    private final TPMTHA name;
    private final TPMTHA qualifiedName;

    public TPMSCertifyInfo(@NonNull TPMTHA name, @NonNull TPMTHA qualifiedName) {
        this.name = name;
        this.qualifiedName = qualifiedName;
    }

    public @NonNull TPMTHA getName() {
        return this.name;
    }

    public @NonNull TPMTHA getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public @NonNull byte[] getBytes() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            TPMUtil.writeSizedArray(outputStream, this.name.getBytes());
            TPMUtil.writeSizedArray(outputStream, this.qualifiedName.getBytes());
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSCertifyInfo that = (TPMSCertifyInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.qualifiedName, that.qualifiedName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.qualifiedName);
    }
}

