/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AbstractSwitch;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.BytecodeCreatorImpl;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodCreatorImpl;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.Switch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class EnumSwitchImpl<E extends Enum<E>>
extends AbstractSwitch<E>
implements Switch.EnumSwitch<E> {
    private final Map<Integer, BytecodeCreatorImpl> ordinalToCaseBlocks = new LinkedHashMap<Integer, BytecodeCreatorImpl>();

    public EnumSwitchImpl(ResultHandle value, final Class<E> enumClass, BytecodeCreatorImpl enclosing) {
        super(enclosing);
        ResultHandle switchTable;
        MethodDescriptor enumOrdinal = MethodDescriptor.ofMethod(enumClass, "ordinal", Integer.TYPE, new Class[0]);
        ResultHandle ordinal = this.invokeVirtualMethod(enumOrdinal, value, new ResultHandle[0]);
        MethodCreatorImpl methodCreator = this.findMethodCreator(enclosing);
        if (methodCreator != null) {
            char sep = '$';
            ClassCreator classCreator = methodCreator.getClassCreator();
            StringBuilder methodName = new StringBuilder();
            methodName.append(sep).append("GIZMO_SWITCH_TABLE");
            for (String part : enumClass.getName().split("\\.")) {
                methodName.append(sep).append(part);
            }
            MethodDescriptor gizmoSwitchTableDescriptor = MethodDescriptor.ofMethod((Object)classCreator.getClassName(), methodName.toString(), int[].class, new Object[0]);
            if (!classCreator.getExistingMethods().contains(gizmoSwitchTableDescriptor)) {
                MethodCreator gizmoSwitchTable = (MethodCreator)classCreator.getMethodCreator(gizmoSwitchTableDescriptor).setModifiers(10);
                gizmoSwitchTable.returnValue(this.generateSwitchTable(enumClass, gizmoSwitchTable, enumOrdinal));
            }
            switchTable = this.invokeStaticMethod(gizmoSwitchTableDescriptor, new ResultHandle[0]);
        } else {
            switchTable = this.generateSwitchTable(enumClass, methodCreator, enumOrdinal);
        }
        final ResultHandle effectiveOrdinal = this.readArrayValue(switchTable, ordinal);
        final HashSet<ResultHandle> inputHandles = new HashSet<ResultHandle>();
        inputHandles.add(effectiveOrdinal);
        this.operations.add(new BytecodeCreatorImpl.Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                Enum[] constants = (Enum[])enumClass.getEnumConstants();
                HashMap<Integer, Label> ordinalToLabel = new HashMap<Integer, Label>();
                ArrayList<BytecodeCreatorImpl> caseBlocks = new ArrayList<BytecodeCreatorImpl>();
                for (Map.Entry<Integer, BytecodeCreatorImpl> caseEntry : EnumSwitchImpl.this.ordinalToCaseBlocks.entrySet()) {
                    BytecodeCreatorImpl caseBlock = caseEntry.getValue();
                    if (caseBlock != null && !EnumSwitchImpl.this.fallThrough) {
                        caseBlock.breakScope(EnumSwitchImpl.this);
                    } else if (caseBlock == null) {
                        caseBlock = new BytecodeCreatorImpl(EnumSwitchImpl.this);
                        caseEntry.setValue(caseBlock);
                    }
                    caseBlocks.add(caseBlock);
                    ordinalToLabel.put(caseEntry.getKey(), caseBlock.getTop());
                }
                int min = ordinalToLabel.keySet().stream().mapToInt(Integer::intValue).min().orElse(0);
                int max = ordinalToLabel.keySet().stream().mapToInt(Integer::intValue).max().orElse(0);
                for (int i = 0; i < constants.length; ++i) {
                    if (i < min || i > max || ordinalToLabel.get(i) != null) continue;
                    BytecodeCreatorImpl emptyCaseBlock = new BytecodeCreatorImpl(EnumSwitchImpl.this);
                    caseBlocks.add(emptyCaseBlock);
                    ordinalToLabel.put(i, emptyCaseBlock.getTop());
                }
                EnumSwitchImpl.this.loadResultHandle(methodVisitor, effectiveOrdinal, EnumSwitchImpl.this, "I");
                int[] ordinals = ordinalToLabel.keySet().stream().mapToInt(Integer::intValue).sorted().toArray();
                Label[] labels = new Label[ordinals.length];
                for (int i = 0; i < ordinals.length; ++i) {
                    labels[i] = (Label)ordinalToLabel.get(ordinals[i]);
                }
                methodVisitor.visitTableSwitchInsn(min, max, EnumSwitchImpl.this.defaultBlock.getTop(), labels);
                for (BytecodeCreatorImpl caseBlock : caseBlocks) {
                    caseBlock.writeOperations(methodVisitor);
                }
                EnumSwitchImpl.this.defaultBlock.writeOperations(methodVisitor);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return null;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return null;
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return inputHandles;
            }
        });
    }

    @Override
    public void caseOf(E value, Consumer<BytecodeCreator> caseBlockConsumer) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(caseBlockConsumer);
        this.addCaseBlock(value, caseBlockConsumer);
    }

    @Override
    public void caseOf(List<E> values, Consumer<BytecodeCreator> caseBlockConsumer) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(caseBlockConsumer);
        Iterator<E> it = values.iterator();
        while (it.hasNext()) {
            Enum e = (Enum)it.next();
            if (it.hasNext()) {
                this.addCaseBlock(e, null);
                continue;
            }
            this.addCaseBlock(e, caseBlockConsumer);
        }
    }

    @Override
    void findActiveResultHandles(Set<ResultHandle> handlesToAllocate) {
        super.findActiveResultHandles(handlesToAllocate);
        for (BytecodeCreatorImpl caseBlock : this.ordinalToCaseBlocks.values()) {
            if (caseBlock == null) continue;
            caseBlock.findActiveResultHandles(handlesToAllocate);
        }
        this.defaultBlock.findActiveResultHandles(handlesToAllocate);
    }

    private void addCaseBlock(E value, Consumer<BytecodeCreator> caseBlockConsumer) {
        int ordinal = ((Enum)value).ordinal();
        if (this.ordinalToCaseBlocks.containsKey(ordinal)) {
            throw new IllegalArgumentException("A case block for the enum value [" + value + "] already exists");
        }
        BytecodeCreatorImpl caseBlock = null;
        if (caseBlockConsumer != null) {
            caseBlock = new BytecodeCreatorImpl(this);
            caseBlockConsumer.accept(caseBlock);
        }
        this.ordinalToCaseBlocks.put(ordinal, caseBlock);
    }

    private MethodCreatorImpl findMethodCreator(BytecodeCreatorImpl enclosing) {
        if (enclosing instanceof MethodCreatorImpl) {
            return (MethodCreatorImpl)enclosing;
        }
        if (enclosing.getOwner() != null) {
            return this.findMethodCreator(enclosing.getOwner());
        }
        return null;
    }

    private ResultHandle generateSwitchTable(Class<E> enumClass, BytecodeCreator bytecodeCreator, MethodDescriptor enumOrdinal) {
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        ResultHandle switchTable = bytecodeCreator.newArray(Integer.TYPE, constants.length);
        for (int i = 0; i < constants.length; ++i) {
            ResultHandle currentConstant = bytecodeCreator.readStaticField(FieldDescriptor.of(enumClass, constants[i].name(), enumClass));
            ResultHandle currentOrdinal = bytecodeCreator.invokeVirtualMethod(enumOrdinal, currentConstant, new ResultHandle[0]);
            bytecodeCreator.writeArrayValue(switchTable, i, currentOrdinal);
        }
        return switchTable;
    }
}

