/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleReason;
import org.jxmpp.jid.FullJid;

public final class Jingle
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String ACTION_ATTRIBUTE_NAME = "action";
    public static final String INITIATOR_ATTRIBUTE_NAME = "initiator";
    public static final String RESPONDER_ATTRIBUTE_NAME = "responder";
    public static final String SESSION_ID_ATTRIBUTE_NAME = "sid";
    public static final String ELEMENT = "jingle";
    private final String sessionId;
    private final JingleAction action;
    private final FullJid initiator;
    private final FullJid responder;
    private final JingleReason reason;
    private final List<JingleContent> contents;

    private Jingle(Builder builder2, String sessionId, JingleAction action, FullJid initiator, FullJid responder, JingleReason reason2, List<JingleContent> contents) {
        super(builder2, ELEMENT, NAMESPACE);
        this.sessionId = StringUtils.requireNotNullNorEmpty(sessionId, "Jingle session ID must not be null");
        this.action = Objects.requireNonNull(action, "Jingle action must not be null");
        this.initiator = initiator;
        this.responder = responder;
        this.reason = reason2;
        this.contents = contents != null ? Collections.unmodifiableList(contents) : Collections.emptyList();
        this.setType(IQ.Type.set);
    }

    public FullJid getInitiator() {
        return this.initiator;
    }

    public FullJid getResponder() {
        return this.responder;
    }

    public String getSid() {
        return this.sessionId;
    }

    public JingleAction getAction() {
        return this.action;
    }

    public JingleReason getReason() {
        return this.reason;
    }

    public List<JingleContent> getContents() {
        return this.contents;
    }

    public JingleContent getSoleContentOrThrow() {
        if (this.contents.isEmpty()) {
            return null;
        }
        if (this.contents.size() > 1) {
            throw new IllegalStateException();
        }
        return this.contents.get(0);
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.optAttribute(INITIATOR_ATTRIBUTE_NAME, this.getInitiator());
        xml.optAttribute(RESPONDER_ATTRIBUTE_NAME, this.getResponder());
        xml.optAttribute(ACTION_ATTRIBUTE_NAME, this.getAction());
        xml.optAttribute(SESSION_ID_ATTRIBUTE_NAME, this.getSid());
        xml.rightAngleBracket();
        xml.optElement(this.reason);
        xml.append(this.contents);
        return xml;
    }

    @Deprecated
    public static Builder getBuilder() {
        return Jingle.builder(StandardStanzaIdSource.DEFAULT.getNewStanzaId());
    }

    public static Builder builder(XMPPConnection connection) {
        return new Builder(connection);
    }

    public static Builder builder(IqData iqData) {
        return new Builder(iqData);
    }

    public static Builder builder(String stanzaId) {
        return new Builder(stanzaId);
    }

    public static final class Builder
    extends IqBuilder<Builder, Jingle> {
        private String sid;
        private JingleAction action;
        private FullJid initiator;
        private FullJid responder;
        private JingleReason reason;
        private List<JingleContent> contents;

        Builder(IqData iqCommon) {
            super(iqCommon);
        }

        Builder(XMPPConnection connection) {
            super(connection);
        }

        Builder(String stanzaId) {
            super(stanzaId);
        }

        public Builder setSessionId(String sessionId) {
            StringUtils.requireNotNullNorEmpty(sessionId, "Session ID must not be null nor empty");
            this.sid = sessionId;
            return this;
        }

        public Builder setAction(JingleAction action) {
            this.action = action;
            return this;
        }

        public Builder setInitiator(FullJid initator) {
            this.initiator = initator;
            return this;
        }

        public Builder setResponder(FullJid responder) {
            this.responder = responder;
            return this;
        }

        public Builder addJingleContent(JingleContent content) {
            if (this.contents == null) {
                this.contents = new ArrayList<JingleContent>(1);
            }
            this.contents.add(content);
            return this;
        }

        public Builder setReason(JingleReason.Reason reason2) {
            this.reason = new JingleReason(reason2);
            return this;
        }

        public Builder setReason(JingleReason reason2) {
            this.reason = reason2;
            return this;
        }

        @Override
        public Jingle build() {
            return new Jingle(this, this.sid, this.action, this.initiator, this.responder, this.reason, this.contents);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

