/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;

public abstract class AdHocCommand {
    private AdHocCommandData data = new AdHocCommandData();

    public static SpecificErrorCondition getSpecificErrorCondition(StanzaError error) {
        for (SpecificErrorCondition condition : SpecificErrorCondition.values()) {
            if (error.getExtension(condition.toString(), "http://jabber.org/protocol/commands") == null) continue;
            return condition;
        }
        return null;
    }

    public void setName(String name) {
        this.data.setName(name);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setNode(String node2) {
        this.data.setNode(node2);
    }

    public String getNode() {
        return this.data.getNode();
    }

    public abstract Jid getOwnerJID();

    public List<AdHocCommandNote> getNotes() {
        return this.data.getNotes();
    }

    protected void addNote(AdHocCommandNote note) {
        this.data.addNote(note);
    }

    public String getRaw() {
        return this.data.getChildElementXML().toString();
    }

    public DataForm getForm() {
        return this.data.getForm();
    }

    protected void setForm(DataForm form) {
        this.data.setForm(form);
    }

    public abstract void execute() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

    public abstract void next(FillableForm var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

    public abstract void complete(FillableForm var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

    public abstract void prev() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

    public abstract void cancel() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

    protected List<Action> getActions() {
        return this.data.getActions();
    }

    protected void addActionAvailable(Action action) {
        this.data.addAction(action);
    }

    protected Action getExecuteAction() {
        return this.data.getExecuteAction();
    }

    protected void setExecuteAction(Action action) {
        this.data.setExecuteAction(action);
    }

    public Status getStatus() {
        return this.data.getStatus();
    }

    public boolean isCompleted() {
        return this.getStatus() == Status.completed;
    }

    void setData(AdHocCommandData data2) {
        this.data = data2;
    }

    AdHocCommandData getData() {
        return this.data;
    }

    protected boolean isValidAction(Action action) {
        return this.getActions().contains((Object)action) || Action.cancel.equals((Object)action);
    }

    public static enum SpecificErrorCondition {
        badAction("bad-action"),
        malformedAction("malformed-action"),
        badLocale("bad-locale"),
        badPayload("bad-payload"),
        badSessionid("bad-sessionid"),
        sessionExpired("session-expired");

        private final String value;

        private SpecificErrorCondition(String value2) {
            this.value = value2;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Action {
        execute,
        cancel,
        prev,
        next,
        complete,
        unknown;

    }

    public static enum Status {
        executing,
        completed,
        canceled;

    }
}

