/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.shutdown;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.meet.ShutdownService;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.shutdown.ShutdownConfig;
import org.jitsi.videobridge.shutdown.ShutdownState;
import org.jitsi.videobridge.util.TaskPools;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/videobridge/shutdown/ShutdownManager;", "", "shutdownService", "Lorg/jitsi/meet/ShutdownService;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/meet/ShutdownService;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "<set-?>", "Lorg/jitsi/videobridge/shutdown/ShutdownState;", "state", "getState", "()Lorg/jitsi/videobridge/shutdown/ShutdownState;", "changeToShuttingDown", "", "initiateShutdown", "graceful", "", "maybeShutdown", "endpointCount", "", "jitsi-videobridge"})
public final class ShutdownManager {
    @NotNull
    private final ShutdownService shutdownService;
    @NotNull
    private final Logger logger;
    @NotNull
    private ShutdownState state;

    public ShutdownManager(@NotNull ShutdownService shutdownService, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(shutdownService, "shutdownService");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.shutdownService = shutdownService;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.state = ShutdownState.RUNNING;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final ShutdownState getState() {
        return this.state;
    }

    public final void initiateShutdown(boolean graceful) {
        this.logger.info("Received shutdown request, graceful=" + graceful);
        if (graceful) {
            if (this.state == ShutdownState.RUNNING) {
                this.state = ShutdownState.GRACEFUL_SHUTDOWN;
                this.logger.info("Entered graceful shutdown mode, will stay in this mode for up to " + ShutdownConfig.config.getGracefulShutdownMaxDuration());
                TaskPools.SCHEDULED_POOL.schedule(() -> ShutdownManager.initiateShutdown$lambda-0(this), ShutdownConfig.config.getGracefulShutdownMaxDuration().toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.logger.info("Graceful shutdown already initiated mode.");
            }
        } else {
            this.changeToShuttingDown();
        }
    }

    public final void maybeShutdown(long endpointCount) {
        if (this.state == ShutdownState.GRACEFUL_SHUTDOWN && endpointCount <= (long)ShutdownConfig.config.getGracefulShutdownMinParticipants()) {
            this.logger.info("Entering SHUTTING_DOWN with " + endpointCount + " participants.");
            this.changeToShuttingDown();
        }
    }

    private final void changeToShuttingDown() {
        if (this.state == ShutdownState.SHUTTING_DOWN) {
            return;
        }
        this.logger.info("Will shut down in " + ShutdownConfig.config.getShuttingDownDelay());
        this.state = ShutdownState.SHUTTING_DOWN;
        TaskPools.SCHEDULED_POOL.schedule(() -> ShutdownManager.changeToShuttingDown$lambda-1(this), ShutdownConfig.config.getShuttingDownDelay().toMillis(), TimeUnit.MILLISECONDS);
    }

    private static final void initiateShutdown$lambda-0(ShutdownManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (this$0.state == ShutdownState.GRACEFUL_SHUTDOWN) {
            this$0.logger.info("Graceful shutdown period expired, changing to SHUTTING_DOWN.");
            this$0.changeToShuttingDown();
        }
    }

    private static final void changeToShuttingDown$lambda-1(ShutdownManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.info("Videobridge is shutting down NOW");
        this$0.shutdownService.beginShutdown();
    }
}

