/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.MediaRange;
import gov.nist.javax.sip.header.ParametersHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.AcceptHeader;

public final class Accept
extends ParametersHeader
implements AcceptHeader {
    private static final long serialVersionUID = -7866187924308658151L;
    protected MediaRange mediaRange;

    public Accept() {
        super("Accept");
    }

    public boolean allowsAllContentTypes() {
        if (this.mediaRange == null) {
            return false;
        }
        return this.mediaRange.type.compareTo("*") == 0;
    }

    public boolean allowsAllContentSubTypes() {
        if (this.mediaRange == null) {
            return false;
        }
        return this.mediaRange.getSubtype().compareTo("*") == 0;
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.mediaRange != null) {
            this.mediaRange.encode(buffer);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            buffer.append(';');
            this.parameters.encode(buffer);
        }
        return buffer;
    }

    public MediaRange getMediaRange() {
        return this.mediaRange;
    }

    public String getContentType() {
        if (this.mediaRange == null) {
            return null;
        }
        return this.mediaRange.getType();
    }

    public String getContentSubType() {
        if (this.mediaRange == null) {
            return null;
        }
        return this.mediaRange.getSubtype();
    }

    public float getQValue() {
        return this.getParameterAsFloat("q");
    }

    public boolean hasQValue() {
        return super.hasParameter("q");
    }

    public void removeQValue() {
        super.removeParameter("q");
    }

    public void setContentSubType(String subtype) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setSubtype(subtype);
    }

    public void setContentType(String type2) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(type2);
    }

    public void setQValue(float qValue) throws InvalidArgumentException {
        if (qValue == -1.0f) {
            super.removeParameter("q");
        }
        super.setParameter("q", qValue);
    }

    public void setMediaRange(MediaRange m3) {
        this.mediaRange = m3;
    }

    @Override
    public Object clone() {
        Accept retval = (Accept)super.clone();
        if (this.mediaRange != null) {
            retval.mediaRange = (MediaRange)this.mediaRange.clone();
        }
        return retval;
    }
}

