/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.api.plugins.input.data.IFieldRef;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.RootNode;
import java.util.Objects;

public final class FieldInfo {
    private final ClassInfo declClass;
    private final String name;
    private final ArgType type;
    private String alias;

    private FieldInfo(ClassInfo declClass, String name, ArgType type) {
        this.declClass = declClass;
        this.name = name;
        this.type = type;
        this.alias = name;
    }

    public static FieldInfo from(RootNode root, ClassInfo declClass, String name, ArgType type) {
        FieldInfo field = new FieldInfo(declClass, name, type);
        return root.getInfoStorage().getField(field);
    }

    public static FieldInfo fromRef(RootNode root, IFieldRef fieldRef) {
        ClassInfo declClass = ClassInfo.fromName(root, fieldRef.getParentClassType());
        FieldInfo field = new FieldInfo(declClass, fieldRef.getName(), ArgType.parse(fieldRef.getType()));
        return root.getInfoStorage().getField(field);
    }

    public String getName() {
        return this.name;
    }

    public ArgType getType() {
        return this.type;
    }

    public ClassInfo getDeclClass() {
        return this.declClass;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void removeAlias() {
        this.alias = this.name;
    }

    public boolean hasAlias() {
        return !Objects.equals(this.name, this.alias);
    }

    public String getFullId() {
        return this.declClass.getFullName() + '.' + this.name + ':' + TypeGen.signature(this.type);
    }

    public String getShortId() {
        return this.name + ':' + TypeGen.signature(this.type);
    }

    public String getRawFullId() {
        return this.declClass.makeRawFullName() + '.' + this.name + ':' + TypeGen.signature(this.type);
    }

    public boolean isRenamed() {
        return !this.name.equals(this.alias);
    }

    public boolean equalsNameAndType(FieldInfo other) {
        return this.name.equals(other.name) && this.type.equals(other.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)o;
        return this.name.equals(fieldInfo.name) && this.type.equals(fieldInfo.type) && this.declClass.equals(fieldInfo.declClass);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.declClass.hashCode();
        return result;
    }

    public String toString() {
        return this.declClass + "." + this.name + ' ' + this.type;
    }
}

