/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser.formats.expr;

import java.util.Collections;
import java.util.List;
import org.jboss.galleon.util.formatparser.FormatContentHandler;
import org.jboss.galleon.util.formatparser.FormatErrors;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.formats.CollectionParsingFormat;
import org.jboss.galleon.util.formatparser.formats.KeyValueParsingFormat;
import org.jboss.galleon.util.formatparser.formats.MapParsingFormat;
import org.jboss.galleon.util.formatparser.formats.ObjectParsingFormat;
import org.jboss.galleon.util.formatparser.formats.StringParsingFormat;
import org.jboss.galleon.util.formatparser.formats.WildcardParsingFormat;

public class FormatExprContentHandler
extends FormatContentHandler {
    private final StringBuilder buf = new StringBuilder();
    private List<ParsingFormat> params = Collections.emptyList();

    public FormatExprContentHandler(ParsingFormat format, int strIndex) {
        super(format, strIndex);
    }

    @Override
    public void character(char ch) throws FormatParsingException {
        this.buf.append(ch);
    }

    @Override
    public void addChild(FormatContentHandler childHandler) throws FormatParsingException {
        if (!this.params.isEmpty()) {
            throw new FormatParsingException("Format " + this.buf + " type parameters have already been initialized");
        }
        this.params = (List)childHandler.getContent();
    }

    @Override
    public Object getContent() throws FormatParsingException {
        return this.resolveFormat();
    }

    public ParsingFormat resolveFormat() throws FormatParsingException {
        String name;
        String string = name = this.buf == null ? null : this.buf.toString();
        if (name == null || name.length() == 0) {
            if (this.params.size() != 1) {
                throw new FormatParsingException("Format type was not specified");
            }
            return this.params.get(0);
        }
        if ("String".equals(name)) {
            this.assertNoTypeParam(name);
            return StringParsingFormat.getInstance();
        }
        if ("List".equals(name)) {
            ParsingFormat item = this.assertSingleTypeParam(name);
            if (item == null) {
                return CollectionParsingFormat.list();
            }
            return CollectionParsingFormat.list(item);
        }
        if ("Set".equals(name)) {
            ParsingFormat item = this.assertSingleTypeParam(name);
            if (item == null) {
                return CollectionParsingFormat.set();
            }
            return CollectionParsingFormat.set(item);
        }
        if ("?".equals(name)) {
            this.assertNoTypeParam(name);
            return WildcardParsingFormat.getInstance();
        }
        if ("Object".equals(name)) {
            this.assertNoTypeParam(name);
            return ObjectParsingFormat.getInstance();
        }
        if ("Map".equals(name)) {
            if (this.params.isEmpty()) {
                return MapParsingFormat.getInstance();
            }
            if (this.params.size() != 2) {
                throw new FormatParsingException("Map expects two parameter types but got " + this.params);
            }
            return MapParsingFormat.getInstance(KeyValueParsingFormat.newInstance(this.params.get(0), this.params.get(1)));
        }
        throw new FormatParsingException("Unexpected format name " + name);
    }

    private ParsingFormat assertSingleTypeParam(String name) throws FormatParsingException {
        if (this.params.isEmpty()) {
            return null;
        }
        if (this.params.size() == 1) {
            return this.params.get(0);
        }
        throw new FormatParsingException("Format " + name + " accepts only one type parameter");
    }

    private void assertNoTypeParam(String name) throws FormatParsingException {
        if (!this.params.isEmpty()) {
            throw new FormatParsingException(FormatErrors.formatExprDoesNotSupportTypeParam(name));
        }
    }
}

