/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.type;

import org.olap4j.OlapException;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.type.Type;

public class LevelType
implements Type {
    private final Dimension dimension;
    private final Hierarchy hierarchy;
    private final Level level;
    private final String digest;

    public LevelType(Dimension dimension, Hierarchy hierarchy, Level level) {
        this.dimension = dimension;
        this.hierarchy = hierarchy;
        this.level = level;
        if (level != null) {
            assert (hierarchy != null) : "hierarchy != null";
            assert (level.getHierarchy() == hierarchy) : "level.getHierarchy() == hierarchy";
        }
        if (hierarchy != null) {
            assert (dimension != null) : "dimension != null";
            assert (hierarchy.getDimension() == dimension) : "hierarchy.getDimension() == dimension";
        }
        StringBuilder buf = new StringBuilder("LevelType<");
        if (level != null) {
            buf.append("level=").append(level.getUniqueName());
        } else if (hierarchy != null) {
            buf.append("hierarchy=").append(hierarchy.getUniqueName());
        } else if (dimension != null) {
            buf.append("dimension=").append(dimension.getUniqueName());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    private static LevelType forType(Type type) throws OlapException {
        return new LevelType(type.getDimension(), type.getHierarchy(), type.getLevel());
    }

    public boolean usesDimension(Dimension dimension, boolean maybe) {
        if (this.dimension == null) {
            return maybe;
        }
        return this.dimension.equals(dimension);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Level getLevel() {
        return this.level;
    }

    public String toString() {
        return this.digest;
    }
}

