/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TytanProtocolDecoder
extends BaseProtocolDecoder {
    public TytanProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeExtraData(Position position, ByteBuf buf, int end) {
        block17: while (buf.readerIndex() < end) {
            short type = buf.readUnsignedByte();
            int length = buf.readUnsignedByte();
            if (length == 255) {
                length += buf.readUnsignedByte();
            }
            switch (type) {
                case 2: {
                    position.set("tripOdometer", buf.readUnsignedMedium());
                    break;
                }
                case 5: {
                    position.set("input", buf.readUnsignedByte());
                    break;
                }
                case 6: {
                    int n = buf.readUnsignedByte() >> 4;
                    if (n < 2) {
                        position.set("adc" + n, Float.valueOf(buf.readFloat()));
                        break;
                    }
                    position.set("di" + (n - 2), Float.valueOf(buf.readFloat()));
                    break;
                }
                case 7: {
                    short alarm = buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    if (!BitUtil.check(alarm, 5)) continue block17;
                    position.set("alarm", "general");
                    break;
                }
                case 8: {
                    position.set("antihijack", buf.readUnsignedByte());
                    break;
                }
                case 9: {
                    position.set("unauthorized", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)));
                    break;
                }
                case 10: {
                    position.set("authorized", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)));
                    break;
                }
                case 24: {
                    for (int i = 0; i < length / 2; ++i) {
                        position.set("temp" + buf.readUnsignedByte(), buf.readByte());
                    }
                    continue block17;
                }
                case 28: {
                    position.set("axleWeight", buf.readUnsignedShort());
                    buf.readUnsignedByte();
                    break;
                }
                case 90: {
                    position.set("power", Float.valueOf(buf.readFloat()));
                    break;
                }
                case 101: {
                    position.set("obdSpeed", buf.readUnsignedByte());
                    break;
                }
                case 102: {
                    position.set("rpm", buf.readUnsignedByte() * 50);
                    break;
                }
                case 107: {
                    int fuel = buf.readUnsignedShort();
                    int fuelFormat = fuel >> 14;
                    if (fuelFormat == 1) {
                        position.set("fuelValue", (double)(fuel & 0x3FFF) * 0.4 + "%");
                        break;
                    }
                    if (fuelFormat == 2) {
                        position.set("fuelValue", (double)(fuel & 0x3FFF) * 0.5 + " l");
                        break;
                    }
                    if (fuelFormat != 3) continue block17;
                    position.set("fuelValue", (double)(fuel & 0x3FFF) * -0.5 + " l");
                    break;
                }
                case 108: {
                    position.set("obdOdometer", buf.readUnsignedInt() * 5L);
                    break;
                }
                case 150: {
                    position.set("door", buf.readUnsignedByte());
                    break;
                }
                default: {
                    buf.skipBytes(length);
                }
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String id;
        DeviceSession deviceSession;
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        int index = buf.readUnsignedByte() >> 3;
        if (channel != null) {
            ByteBuf response = Unpooled.copiedBuffer((CharSequence)("^" + index), (Charset)StandardCharsets.US_ASCII);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, id = String.valueOf(buf.readUnsignedInt()))) == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.readableBytes() > 2) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            int end = buf.readerIndex() + buf.readUnsignedByte();
            position.setTime(new Date(buf.readUnsignedInt() * 1000L));
            short flags = buf.readUnsignedByte();
            position.set("sat", BitUtil.from(flags, 2));
            position.setValid(BitUtil.to(flags, 2) > 0);
            double lat = buf.readUnsignedMedium();
            lat = lat * -180.0 / 1.6777216E7 + 90.0;
            position.setLatitude(lat);
            double lon = buf.readUnsignedMedium();
            lon = lon * 360.0 / 1.6777216E7 - 180.0;
            position.setLongitude(lon);
            flags = buf.readUnsignedByte();
            position.set("ignition", BitUtil.check(flags, 0));
            position.set("rssi", BitUtil.between(flags, 2, 5));
            position.setCourse((BitUtil.from(flags, 5) * 45 + 180) % 360);
            short speed = buf.readUnsignedByte();
            if (speed < 250) {
                position.setSpeed(UnitsConverter.knotsFromKph(speed));
            }
            this.decodeExtraData(position, buf, end);
            positions.add(position);
        }
        return positions;
    }
}

