/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.traccar.BaseDataHandler;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.DistanceCalculator;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class DistanceHandler
extends BaseDataHandler {
    private final CacheManager cacheManager;
    private final boolean filter;
    private final int minError;
    private final int maxError;

    @Inject
    public DistanceHandler(Config config, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.filter = config.getBoolean(Keys.COORDINATES_FILTER);
        this.minError = config.getInteger(Keys.COORDINATES_MIN_ERROR);
        this.maxError = config.getInteger(Keys.COORDINATES_MAX_ERROR);
    }

    @Override
    protected Position handlePosition(Position position) {
        double totalDistance;
        Position last;
        double distance = 0.0;
        if (position.hasAttribute("distance")) {
            distance = position.getDouble("distance");
        }
        if ((last = this.cacheManager.getPosition(position.getDeviceId())) != null) {
            totalDistance = last.getDouble("totalDistance");
            if (!position.hasAttribute("distance")) {
                distance = DistanceCalculator.distance(position.getLatitude(), position.getLongitude(), last.getLatitude(), last.getLongitude());
            }
            if (this.filter && last.getLatitude() != 0.0 && last.getLongitude() != 0.0) {
                boolean satisfiesMax;
                boolean satisfiesMin = this.minError == 0 || distance > (double)this.minError;
                boolean bl = satisfiesMax = this.maxError == 0 || distance < (double)this.maxError || position.getValid();
                if (!satisfiesMin || !satisfiesMax) {
                    position.setValid(last.getValid());
                    position.setLatitude(last.getLatitude());
                    position.setLongitude(last.getLongitude());
                    distance = 0.0;
                }
            }
        } else {
            totalDistance = 0.0;
        }
        position.set("distance", distance);
        position.set("totalDistance", totalDistance + distance);
        return position;
    }
}

