/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import waffle.util.WaffleInfo;

public class WaffleInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(WaffleInfoServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.getWaffleInfoResponse(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.getWaffleInfoResponse(request, response);
    }

    public void getWaffleInfoResponse(HttpServletRequest request, HttpServletResponse response) {
        WaffleInfo info = new WaffleInfo();
        try {
            Document doc = info.getWaffleInfo();
            Element root = doc.getDocumentElement();
            Element http = this.getRequestInfo(doc, request);
            root.insertBefore(http, root.getFirstChild());
            String[] lookup = request.getParameterValues("lookup");
            if (lookup != null) {
                for (String name : lookup) {
                    root.appendChild(info.getLookupInfo(doc, name));
                }
            }
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(response.getWriter());
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            response.setContentType("application/xml");
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            logger.error("", (Throwable)e);
            throw new RuntimeException("See logs for underlying error condition");
        }
    }

    private Element getRequestInfo(Document doc, HttpServletRequest request) {
        ArrayList<String> headers;
        Element node = doc.createElement("request");
        Element value = doc.createElement("AuthType");
        value.setTextContent(request.getAuthType());
        node.appendChild(value);
        Principal p = request.getUserPrincipal();
        if (p != null) {
            Element child = doc.createElement("principal");
            child.setAttribute("class", p.getClass().getName());
            value = doc.createElement("name");
            value.setTextContent(p.getName());
            child.appendChild(value);
            value = doc.createElement("string");
            value.setTextContent(p.toString());
            child.appendChild(value);
            node.appendChild(child);
        }
        if (!(headers = Collections.list(request.getHeaderNames())).isEmpty()) {
            Element child = doc.createElement("headers");
            for (String header : headers) {
                value = doc.createElement(header);
                value.setTextContent(request.getHeader(header));
                child.appendChild(value);
            }
            node.appendChild(child);
        }
        return node;
    }
}

