/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atan(vec2(0.0, 0.0), vec2(1e-10, -1e-10)) => vec2(0.0, 3.1415927)
 * atan(vec2(0.0, 0.0), vec2(0.1, -0.1)) => vec2(0.0, 3.1415927)
 * atan(vec2(0.0, 0.0), vec2(1.0, -1.0)) => vec2(0.0, 3.1415927)
 * atan(vec2(0.0, 0.0), vec2(10.0, -10.0)) => vec2(0.0, 3.1415927)
 * atan(vec2(0.0, 0.0), vec2(10000000000.0, -10000000000.0)) => vec2(0.0, 3.1415927)
 * atan(vec2(1e-10, 1e-10), vec2(0.0, 1e-10)) => vec2(1.5707964, 0.7853982)
 * atan(vec2(1e-10, 1e-10), vec2(-1e-10, 0.1)) => vec2(2.3561945, 1e-09)
 * atan(vec2(1e-10, 1e-10), vec2(-0.1, 1.0)) => vec2(3.1415927, 1e-10)
 * atan(vec2(1e-10, 1e-10), vec2(-1.0, 10.0)) => vec2(3.1415927, 1e-11)
 * atan(vec2(1e-10, 1e-10), vec2(-10.0, 10000000000.0)) => vec2(3.1415927, 1.00000005e-20)
 * atan(vec2(1e-10, -1e-10), vec2(-10000000000.0, 0.0)) => vec2(3.1415927, -1.5707964)
 * atan(vec2(-1e-10, -1e-10), vec2(1e-10, -1e-10)) => vec2(-0.7853982, -2.3561945)
 * atan(vec2(-1e-10, -1e-10), vec2(0.1, -0.1)) => vec2(-1e-09, -3.1415927)
 * atan(vec2(-1e-10, -1e-10), vec2(1.0, -1.0)) => vec2(-1e-10, -3.1415927)
 * atan(vec2(-1e-10, -1e-10), vec2(10.0, -10.0)) => vec2(-1e-11, -3.1415927)
 * atan(vec2(-1e-10, -1e-10), vec2(10000000000.0, -10000000000.0)) => vec2(-1.00000005e-20, -3.1415927)
 * atan(vec2(0.1, 0.1), vec2(0.0, 1e-10)) => vec2(1.5707964, 1.5707964)
 * atan(vec2(0.1, 0.1), vec2(-1e-10, 0.1)) => vec2(1.5707964, 0.7853982)
 * atan(vec2(0.1, 0.1), vec2(-0.1, 1.0)) => vec2(2.3561945, 0.09966865)
 * atan(vec2(0.1, 0.1), vec2(-1.0, 10.0)) => vec2(3.041924, 0.009999667)
 * atan(vec2(0.1, 0.1), vec2(-10.0, 10000000000.0)) => vec2(3.131593, 1e-11)
 * atan(vec2(0.1, -0.1), vec2(-10000000000.0, 0.0)) => vec2(3.1415927, -1.5707964)
 * atan(vec2(-0.1, -0.1), vec2(1e-10, -1e-10)) => vec2(-1.5707964, -1.5707964)
 * atan(vec2(-0.1, -0.1), vec2(0.1, -0.1)) => vec2(-0.7853982, -2.3561945)
 * atan(vec2(-0.1, -0.1), vec2(1.0, -1.0)) => vec2(-0.09966865, -3.041924)
 * atan(vec2(-0.1, -0.1), vec2(10.0, -10.0)) => vec2(-0.009999667, -3.131593)
 * atan(vec2(-0.1, -0.1), vec2(10000000000.0, -10000000000.0)) => vec2(-1e-11, -3.1415927)
 * atan(vec2(1.0, 1.0), vec2(0.0, 1e-10)) => vec2(1.5707964, 1.5707964)
 * atan(vec2(1.0, 1.0), vec2(-1e-10, 0.1)) => vec2(1.5707964, 1.4711276)
 * atan(vec2(1.0, 1.0), vec2(-0.1, 1.0)) => vec2(1.670465, 0.7853982)
 * atan(vec2(1.0, 1.0), vec2(-1.0, 10.0)) => vec2(2.3561945, 0.09966865)
 * atan(vec2(1.0, 1.0), vec2(-10.0, 10000000000.0)) => vec2(3.041924, 1e-10)
 * atan(vec2(1.0, -1.0), vec2(-10000000000.0, 0.0)) => vec2(3.1415927, -1.5707964)
 * atan(vec2(-1.0, -1.0), vec2(1e-10, -1e-10)) => vec2(-1.5707964, -1.5707964)
 * atan(vec2(-1.0, -1.0), vec2(0.1, -0.1)) => vec2(-1.4711276, -1.670465)
 * atan(vec2(-1.0, -1.0), vec2(1.0, -1.0)) => vec2(-0.7853982, -2.3561945)
 * atan(vec2(-1.0, -1.0), vec2(10.0, -10.0)) => vec2(-0.09966865, -3.041924)
 * atan(vec2(-1.0, -1.0), vec2(10000000000.0, -10000000000.0)) => vec2(-1e-10, -3.1415927)
 * atan(vec2(10.0, 10.0), vec2(0.0, 1e-10)) => vec2(1.5707964, 1.5707964)
 * atan(vec2(10.0, 10.0), vec2(-1e-10, 0.1)) => vec2(1.5707964, 1.5607966)
 * atan(vec2(10.0, 10.0), vec2(-0.1, 1.0)) => vec2(1.580796, 1.4711276)
 * atan(vec2(10.0, 10.0), vec2(-1.0, 10.0)) => vec2(1.670465, 0.7853982)
 * atan(vec2(10.0, 10.0), vec2(-10.0, 10000000000.0)) => vec2(2.3561945, 1e-09)
 * atan(vec2(10.0, -10.0), vec2(-10000000000.0, 0.0)) => vec2(3.1415927, -1.5707964)
 * atan(vec2(-10.0, -10.0), vec2(1e-10, -1e-10)) => vec2(-1.5707964, -1.5707964)
 * atan(vec2(-10.0, -10.0), vec2(0.1, -0.1)) => vec2(-1.5607966, -1.580796)
 * atan(vec2(-10.0, -10.0), vec2(1.0, -1.0)) => vec2(-1.4711276, -1.670465)
 * atan(vec2(-10.0, -10.0), vec2(10.0, -10.0)) => vec2(-0.7853982, -2.3561945)
 * atan(vec2(-10.0, -10.0), vec2(10000000000.0, -10000000000.0)) => vec2(-1e-09, -3.1415927)
 * atan(vec2(10000000000.0, 10000000000.0), vec2(0.0, 1e-10)) => vec2(1.5707964, 1.5707964)
 * atan(vec2(10000000000.0, 10000000000.0), vec2(-1e-10, 0.1)) => vec2(1.5707964, 1.5707964)
 * atan(vec2(10000000000.0, 10000000000.0), vec2(-0.1, 1.0)) => vec2(1.5707964, 1.5707964)
 * atan(vec2(10000000000.0, 10000000000.0), vec2(-1.0, 10.0)) => vec2(1.5707964, 1.5707964)
 * atan(vec2(10000000000.0, 10000000000.0), vec2(-10.0, 10000000000.0)) => vec2(1.5707964, 0.7853982)
 * atan(vec2(10000000000.0, -10000000000.0), vec2(-10000000000.0, 0.0)) => vec2(2.3561945, -1.5707964)
 * atan(vec2(-10000000000.0, -10000000000.0), vec2(1e-10, -1e-10)) => vec2(-1.5707964, -1.5707964)
 * atan(vec2(-10000000000.0, -10000000000.0), vec2(0.1, -0.1)) => vec2(-1.5707964, -1.5707964)
 * atan(vec2(-10000000000.0, -10000000000.0), vec2(1.0, -1.0)) => vec2(-1.5707964, -1.5707964)
 * atan(vec2(-10000000000.0, -10000000000.0), vec2(10.0, -10.0)) => vec2(-1.5707964, -1.5707964)
 * atan(vec2(-10000000000.0, -10000000000.0), vec2(10000000000.0, -10000000000.0)) => vec2(-0.7853982, -2.3561945)
 */
#version 150

void main()
{
  float[distance(atan(vec2(0.0, 0.0), vec2(1e-10, -1e-10)), vec2(0.0, 3.1415927)) <= 0.003143184 ? 1 : -1] array0;
  float[distance(atan(vec2(0.0, 0.0), vec2(0.1, -0.1)), vec2(0.0, 3.1415927)) <= 0.003143184 ? 1 : -1] array1;
  float[distance(atan(vec2(0.0, 0.0), vec2(1.0, -1.0)), vec2(0.0, 3.1415927)) <= 0.003143184 ? 1 : -1] array2;
  float[distance(atan(vec2(0.0, 0.0), vec2(10.0, -10.0)), vec2(0.0, 3.1415927)) <= 0.003143184 ? 1 : -1] array3;
  float[distance(atan(vec2(0.0, 0.0), vec2(10000000000.0, -10000000000.0)), vec2(0.0, 3.1415927)) <= 0.003143184 ? 1 : -1] array4;
  float[distance(atan(vec2(1e-10, 1e-10), vec2(0.0, 1e-10)), vec2(1.5707964, 0.7853982)) <= 0.0017562037 ? 1 : -1] array5;
  float[distance(atan(vec2(1e-10, 1e-10), vec2(-1e-10, 0.1)), vec2(2.3561945, 1e-09)) <= 0.0023583155 ? 1 : -1] array6;
  float[distance(atan(vec2(1e-10, 1e-10), vec2(-0.1, 1.0)), vec2(3.1415927, 1e-10)) <= 0.003143184 ? 1 : -1] array7;
  float[distance(atan(vec2(1e-10, 1e-10), vec2(-1.0, 10.0)), vec2(3.1415927, 1e-11)) <= 0.003143184 ? 1 : -1] array8;
  float[distance(atan(vec2(1e-10, 1e-10), vec2(-10.0, 10000000000.0)), vec2(3.1415927, 1.00000005e-20)) <= 0.003143184 ? 1 : -1] array9;
  float[distance(atan(vec2(1e-10, -1e-10), vec2(-10000000000.0, 0.0)), vec2(3.1415927, -1.5707964)) <= 0.0035124074 ? 1 : -1] array10;
  float[distance(atan(vec2(-1e-10, -1e-10), vec2(1e-10, -1e-10)), vec2(-0.7853982, -2.3561945)) <= 0.002483647 ? 1 : -1] array11;
  float[distance(atan(vec2(-1e-10, -1e-10), vec2(0.1, -0.1)), vec2(-1e-09, -3.1415927)) <= 0.003143184 ? 1 : -1] array12;
  float[distance(atan(vec2(-1e-10, -1e-10), vec2(1.0, -1.0)), vec2(-1e-10, -3.1415927)) <= 0.003143184 ? 1 : -1] array13;
  float[distance(atan(vec2(-1e-10, -1e-10), vec2(10.0, -10.0)), vec2(-1e-11, -3.1415927)) <= 0.003143184 ? 1 : -1] array14;
  float[distance(atan(vec2(-1e-10, -1e-10), vec2(10000000000.0, -10000000000.0)), vec2(-1.00000005e-20, -3.1415927)) <= 0.003143184 ? 1 : -1] array15;
  float[distance(atan(vec2(0.1, 0.1), vec2(0.0, 1e-10)), vec2(1.5707964, 1.5707964)) <= 0.0022214416 ? 1 : -1] array16;
  float[distance(atan(vec2(0.1, 0.1), vec2(-1e-10, 0.1)), vec2(1.5707964, 0.7853982)) <= 0.0017562037 ? 1 : -1] array17;
  float[distance(atan(vec2(0.1, 0.1), vec2(-0.1, 1.0)), vec2(2.3561945, 0.09966865)) <= 0.0023583155 ? 1 : -1] array18;
  float[distance(atan(vec2(0.1, 0.1), vec2(-1.0, 10.0)), vec2(3.041924, 0.009999667)) <= 0.0030435673 ? 1 : -1] array19;
  float[distance(atan(vec2(0.1, 0.1), vec2(-10.0, 10000000000.0)), vec2(3.131593, 1e-11)) <= 0.0031331892 ? 1 : -1] array20;
  float[distance(atan(vec2(0.1, -0.1), vec2(-10000000000.0, 0.0)), vec2(3.1415927, -1.5707964)) <= 0.0035124074 ? 1 : -1] array21;
  float[distance(atan(vec2(-0.1, -0.1), vec2(1e-10, -1e-10)), vec2(-1.5707964, -1.5707964)) <= 0.0022214416 ? 1 : -1] array22;
  float[distance(atan(vec2(-0.1, -0.1), vec2(0.1, -0.1)), vec2(-0.7853982, -2.3561945)) <= 0.002483647 ? 1 : -1] array23;
  float[distance(atan(vec2(-0.1, -0.1), vec2(1.0, -1.0)), vec2(-0.09966865, -3.041924)) <= 0.0030435673 ? 1 : -1] array24;
  float[distance(atan(vec2(-0.1, -0.1), vec2(10.0, -10.0)), vec2(-0.009999667, -3.131593)) <= 0.0031331892 ? 1 : -1] array25;
  float[distance(atan(vec2(-0.1, -0.1), vec2(10000000000.0, -10000000000.0)), vec2(-1e-11, -3.1415927)) <= 0.003143184 ? 1 : -1] array26;
  float[distance(atan(vec2(1.0, 1.0), vec2(0.0, 1e-10)), vec2(1.5707964, 1.5707964)) <= 0.0022214416 ? 1 : -1] array27;
  float[distance(atan(vec2(1.0, 1.0), vec2(-1e-10, 0.1)), vec2(1.5707964, 1.4711276)) <= 0.0021521193 ? 1 : -1] array28;
  float[distance(atan(vec2(1.0, 1.0), vec2(-0.1, 1.0)), vec2(1.670465, 0.7853982)) <= 0.0018458882 ? 1 : -1] array29;
  float[distance(atan(vec2(1.0, 1.0), vec2(-1.0, 10.0)), vec2(2.3561945, 0.09966865)) <= 0.0023583155 ? 1 : -1] array30;
  float[distance(atan(vec2(1.0, 1.0), vec2(-10.0, 10000000000.0)), vec2(3.041924, 1e-10)) <= 0.0030435673 ? 1 : -1] array31;
  float[distance(atan(vec2(1.0, -1.0), vec2(-10000000000.0, 0.0)), vec2(3.1415927, -1.5707964)) <= 0.0035124074 ? 1 : -1] array32;
  float[distance(atan(vec2(-1.0, -1.0), vec2(1e-10, -1e-10)), vec2(-1.5707964, -1.5707964)) <= 0.0022214416 ? 1 : -1] array33;
  float[distance(atan(vec2(-1.0, -1.0), vec2(0.1, -0.1)), vec2(-1.4711276, -1.670465)) <= 0.0022259087 ? 1 : -1] array34;
  float[distance(atan(vec2(-1.0, -1.0), vec2(1.0, -1.0)), vec2(-0.7853982, -2.3561945)) <= 0.002483647 ? 1 : -1] array35;
  float[distance(atan(vec2(-1.0, -1.0), vec2(10.0, -10.0)), vec2(-0.09966865, -3.041924)) <= 0.0030435673 ? 1 : -1] array36;
  float[distance(atan(vec2(-1.0, -1.0), vec2(10000000000.0, -10000000000.0)), vec2(-1e-10, -3.1415927)) <= 0.003143184 ? 1 : -1] array37;
  float[distance(atan(vec2(10.0, 10.0), vec2(0.0, 1e-10)), vec2(1.5707964, 1.5707964)) <= 0.0022214416 ? 1 : -1] array38;
  float[distance(atan(vec2(10.0, 10.0), vec2(-1e-10, 0.1)), vec2(1.5707964, 1.5607966)) <= 0.002214382 ? 1 : -1] array39;
  float[distance(atan(vec2(10.0, 10.0), vec2(-0.1, 1.0)), vec2(1.580796, 1.4711276)) <= 0.0021594285 ? 1 : -1] array40;
  float[distance(atan(vec2(10.0, 10.0), vec2(-1.0, 10.0)), vec2(1.670465, 0.7853982)) <= 0.0018458882 ? 1 : -1] array41;
  float[distance(atan(vec2(10.0, 10.0), vec2(-10.0, 10000000000.0)), vec2(2.3561945, 1e-09)) <= 0.0023583155 ? 1 : -1] array42;
  float[distance(atan(vec2(10.0, -10.0), vec2(-10000000000.0, 0.0)), vec2(3.1415927, -1.5707964)) <= 0.0035124074 ? 1 : -1] array43;
  float[distance(atan(vec2(-10.0, -10.0), vec2(1e-10, -1e-10)), vec2(-1.5707964, -1.5707964)) <= 0.0022214416 ? 1 : -1] array44;
  float[distance(atan(vec2(-10.0, -10.0), vec2(0.1, -0.1)), vec2(-1.5607966, -1.580796)) <= 0.0022214865 ? 1 : -1] array45;
  float[distance(atan(vec2(-10.0, -10.0), vec2(1.0, -1.0)), vec2(-1.4711276, -1.670465)) <= 0.0022259087 ? 1 : -1] array46;
  float[distance(atan(vec2(-10.0, -10.0), vec2(10.0, -10.0)), vec2(-0.7853982, -2.3561945)) <= 0.002483647 ? 1 : -1] array47;
  float[distance(atan(vec2(-10.0, -10.0), vec2(10000000000.0, -10000000000.0)), vec2(-1e-09, -3.1415927)) <= 0.003143184 ? 1 : -1] array48;
  float[distance(atan(vec2(10000000000.0, 10000000000.0), vec2(0.0, 1e-10)), vec2(1.5707964, 1.5707964)) <= 0.0022214416 ? 1 : -1] array49;
  float[distance(atan(vec2(10000000000.0, 10000000000.0), vec2(-1e-10, 0.1)), vec2(1.5707964, 1.5707964)) <= 0.0022214416 ? 1 : -1] array50;
  float[distance(atan(vec2(10000000000.0, 10000000000.0), vec2(-0.1, 1.0)), vec2(1.5707964, 1.5707964)) <= 0.0022214416 ? 1 : -1] array51;
  float[distance(atan(vec2(10000000000.0, 10000000000.0), vec2(-1.0, 10.0)), vec2(1.5707964, 1.5707964)) <= 0.0022214416 ? 1 : -1] array52;
  float[distance(atan(vec2(10000000000.0, 10000000000.0), vec2(-10.0, 10000000000.0)), vec2(1.5707964, 0.7853982)) <= 0.0017562037 ? 1 : -1] array53;
  float[distance(atan(vec2(10000000000.0, -10000000000.0), vec2(-10000000000.0, 0.0)), vec2(2.3561945, -1.5707964)) <= 0.0028317932 ? 1 : -1] array54;
  float[distance(atan(vec2(-10000000000.0, -10000000000.0), vec2(1e-10, -1e-10)), vec2(-1.5707964, -1.5707964)) <= 0.0022214416 ? 1 : -1] array55;
  float[distance(atan(vec2(-10000000000.0, -10000000000.0), vec2(0.1, -0.1)), vec2(-1.5707964, -1.5707964)) <= 0.0022214416 ? 1 : -1] array56;
  float[distance(atan(vec2(-10000000000.0, -10000000000.0), vec2(1.0, -1.0)), vec2(-1.5707964, -1.5707964)) <= 0.0022214416 ? 1 : -1] array57;
  float[distance(atan(vec2(-10000000000.0, -10000000000.0), vec2(10.0, -10.0)), vec2(-1.5707964, -1.5707964)) <= 0.0022214416 ? 1 : -1] array58;
  float[distance(atan(vec2(-10000000000.0, -10000000000.0), vec2(10000000000.0, -10000000000.0)), vec2(-0.7853982, -2.3561945)) <= 0.002483647 ? 1 : -1] array59;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length() + array54.length() + array55.length() + array56.length() + array57.length() + array58.length() + array59.length());
}
