/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) + 12) => ivec2(50, 47)
 * (ivec2(38, 35) + -6) => ivec2(32, 29)
 * (ivec2(38, 35) + 76) => ivec2(114, 111)
 * (ivec2(38, 35) + -32) => ivec2(6, 3)
 * (ivec2(38, 35) + 0) => ivec2(38, 35)
 * (ivec2(64, -9) + 12) => ivec2(76, 3)
 * (ivec2(64, -9) + -6) => ivec2(58, -15)
 * (ivec2(64, -9) + 76) => ivec2(140, 67)
 * (ivec2(64, -9) + -32) => ivec2(32, -41)
 * (ivec2(64, -9) + 0) => ivec2(64, -9)
 * (ivec2(64, 9) + 12) => ivec2(76, 21)
 * (ivec2(64, 9) + -6) => ivec2(58, 3)
 * (ivec2(64, 9) + 76) => ivec2(140, 85)
 * (ivec2(64, 9) + -32) => ivec2(32, -23)
 * (ivec2(64, 9) + 0) => ivec2(64, 9)
 */
#version 120

void main()
{
  float[all(equal((ivec2(38, 35) + 12), ivec2(50, 47))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) + -6), ivec2(32, 29))) ? 1 : -1] array1;
  float[all(equal((ivec2(38, 35) + 76), ivec2(114, 111))) ? 1 : -1] array2;
  float[all(equal((ivec2(38, 35) + -32), ivec2(6, 3))) ? 1 : -1] array3;
  float[all(equal((ivec2(38, 35) + 0), ivec2(38, 35))) ? 1 : -1] array4;
  float[all(equal((ivec2(64, -9) + 12), ivec2(76, 3))) ? 1 : -1] array5;
  float[all(equal((ivec2(64, -9) + -6), ivec2(58, -15))) ? 1 : -1] array6;
  float[all(equal((ivec2(64, -9) + 76), ivec2(140, 67))) ? 1 : -1] array7;
  float[all(equal((ivec2(64, -9) + -32), ivec2(32, -41))) ? 1 : -1] array8;
  float[all(equal((ivec2(64, -9) + 0), ivec2(64, -9))) ? 1 : -1] array9;
  float[all(equal((ivec2(64, 9) + 12), ivec2(76, 21))) ? 1 : -1] array10;
  float[all(equal((ivec2(64, 9) + -6), ivec2(58, 3))) ? 1 : -1] array11;
  float[all(equal((ivec2(64, 9) + 76), ivec2(140, 85))) ? 1 : -1] array12;
  float[all(equal((ivec2(64, 9) + -32), ivec2(32, -23))) ? 1 : -1] array13;
  float[all(equal((ivec2(64, 9) + 0), ivec2(64, 9))) ? 1 : -1] array14;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
