"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorService = void 0;

var _constants = require("./utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
class ConnectorService {
  static async search({
    from,
    size,
    client
  }) {
    let result;

    try {
      result = await client.asCurrentUser.transport.request({
        method: 'POST',
        path: _constants.CONNECTOR_SEARCH_API,
        body: {
          query: {
            match_all: {}
          },
          from,
          size
        }
      });
    } catch (e) {
      if (e instanceof Error && e.message.includes('index_not_found_exception')) {
        return {
          data: [],
          total_connectors: 0
        };
      }

      throw e;
    }

    return {
      data: result.body.hits.hits.map(({
        _id,
        _source
      }) => ({
        id: _id,
        ..._source
      })),
      total_connectors: result.body.hits.total.value
    };
  }

  static async getUniqueInternalConnectorNames({
    client,
    size
  }) {
    let result;

    try {
      result = await client.asCurrentUser.transport.request({
        method: 'POST',
        path: _constants.MODEL_SEARCH_API,
        body: {
          size: 0,
          aggs: {
            unique_connector_names: {
              terms: {
                field: 'connector.name.keyword',
                size
              }
            }
          }
        }
      });
    } catch (e) {
      if (e instanceof Error && e.message.includes('index_not_found_exception')) {
        return [];
      }

      throw e;
    }

    return result.body.aggregations.unique_connector_names.buckets.map(({
      key
    }) => key);
  }

}

exports.ConnectorService = ConnectorService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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