/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.securityanalytics.action.SearchDetectorAction;
import org.opensearch.securityanalytics.action.SearchDetectorRequest;
import org.opensearch.securityanalytics.model.Detector;

public class RestSearchDetectorAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestSearchDetectorAction.class);

    public String getName() {
        return "search_detector_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/detectors/_search"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), "/_plugins/_security_analytics/detectors/_search"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(FetchSourceContext.parseFromRestRequest((RestRequest)request));
        searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true));
        searchSourceBuilder.version(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(searchSourceBuilder);
        searchRequest.indices(new String[]{".opensearch-sap-detectors-config"});
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        SearchDetectorRequest searchDetectorRequest = new SearchDetectorRequest(searchRequest);
        return channel -> client.execute((ActionType)SearchDetectorAction.INSTANCE, (ActionRequest)searchDetectorRequest, (ActionListener)new RestSearchDetectorResponseListener((RestChannel)channel, request));
    }

    static class RestSearchDetectorResponseListener
    extends RestResponseListener<SearchResponse> {
        private final RestRequest request;

        RestSearchDetectorResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        public RestResponse buildResponse(SearchResponse response) throws Exception {
            for (SearchHit hit : response.getHits()) {
                XContentParser xcp = XContentType.JSON.xContent().createParser(this.channel.request().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                Detector detector = Detector.docParse(xcp, hit.getId(), hit.getVersion());
                XContentBuilder xcb = detector.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
                hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
            }
            return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
        }
    }
}

