/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.alerting.model.destination.Destination;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.alerting.model.AggregationResultBucket;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.alerting.model.action.ActionExecutionPolicy;
import org.opensearch.commons.alerting.model.action.ActionExecutionScope;
import org.opensearch.commons.alerting.util.IndexUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u001a6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00012\u000e\u0010\u000f\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u0011\u001a\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f\u001a\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\f\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020\f*\u00020 \u001a\u0014\u0010!\u001a\u00020\"*\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\"\u001a\u0018\u0010$\u001a\u00020\b*\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'\u001a\n\u0010(\u001a\u00020\b*\u00020\u001e\u001a\n\u0010)\u001a\u00020\b*\u00020\u001e\u001a\n\u0010*\u001a\u00020\b*\u00020%\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"MAX_SEARCH_SIZE", "", "getMAX_SEARCH_SIZE", "()I", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "defaultToPerExecutionAction", "", "maxActionableAlertCount", "", "monitorId", "", "triggerId", "totalActionableAlertCount", "monitorOrTriggerError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getRoleFilterEnabled", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "settingPath", "isValidEmail", "email", "getActionExecutionPolicy", "Lorg/opensearch/commons/alerting/model/action/ActionExecutionPolicy;", "Lorg/opensearch/commons/alerting/model/action/Action;", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "getBucketKeysHash", "Lorg/opensearch/commons/alerting/model/AggregationResultBucket;", "getCombinedTriggerRunResult", "Lorg/opensearch/alerting/model/BucketLevelTriggerRunResult;", "prevTriggerRunResult", "isAllowed", "Lorg/opensearch/alerting/model/destination/Destination;", "allowList", "", "isDocLevelMonitor", "isQueryLevelMonitor", "isTestAction", "opensearch-alerting"})
public final class AlertingUtilsKt {
    private static final Logger logger = LogManager.getLogger((String)"AlertingUtils");
    private static final int MAX_SEARCH_SIZE = 10000;

    public static final int getMAX_SEARCH_SIZE() {
        return MAX_SEARCH_SIZE;
    }

    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    public static final boolean getRoleFilterEnabled(@NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull String settingPath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)settingPath, (String)"settingPath");
        boolean adBackendRoleFilterEnabled = false;
        org.opensearch.cluster.metadata.Metadata metaData = clusterService.state().metadata();
        if (clusterService.getClusterSettings().get(settingPath) == null) {
            return false;
        }
        Object object = clusterService.getClusterSettings().get(settingPath).getDefault(settings);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        adBackendRoleFilterEnabled = (Boolean)object;
        if (metaData.transientSettings().get(settingPath) != null) {
            Boolean bl2 = metaData.transientSettings().getAsBoolean(settingPath, Boolean.valueOf(adBackendRoleFilterEnabled));
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"{\n        metaData.trans\u2026dRoleFilterEnabled)\n    }");
            bl = bl2;
        } else if (metaData.persistentSettings().get(settingPath) != null) {
            Boolean bl3 = metaData.persistentSettings().getAsBoolean(settingPath, Boolean.valueOf(adBackendRoleFilterEnabled));
            Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"{\n        metaData.persi\u2026dRoleFilterEnabled)\n    }");
            bl = bl3;
        } else {
            bl = adBackendRoleFilterEnabled;
        }
        return bl;
    }

    public static final boolean isAllowed(@NotNull Destination $this$isAllowed, @NotNull List<String> allowList) {
        Intrinsics.checkNotNullParameter((Object)$this$isAllowed, (String)"<this>");
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        return allowList.contains($this$isAllowed.getType().getValue());
    }

    public static final boolean isTestAction(@NotNull Destination $this$isTestAction) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestAction, (String)"<this>");
        return $this$isTestAction.getType() == DestinationType.TEST_ACTION;
    }

    public static final boolean isDocLevelMonitor(@NotNull Monitor $this$isDocLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isDocLevelMonitor, (String)"<this>");
        return $this$isDocLevelMonitor.getMonitorType() == Monitor.MonitorType.DOC_LEVEL_MONITOR;
    }

    public static final boolean isQueryLevelMonitor(@NotNull Monitor $this$isQueryLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isQueryLevelMonitor, (String)"<this>");
        return $this$isQueryLevelMonitor.getMonitorType() == Monitor.MonitorType.QUERY_LEVEL_MONITOR;
    }

    @NotNull
    public static final String getBucketKeysHash(@NotNull AggregationResultBucket $this$getBucketKeysHash) {
        Intrinsics.checkNotNullParameter((Object)$this$getBucketKeysHash, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$getBucketKeysHash.getBucketKeys(), (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    public static final ActionExecutionPolicy getActionExecutionPolicy(@NotNull Action $this$getActionExecutionPolicy, @NotNull Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)$this$getActionExecutionPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Object object = $this$getActionExecutionPolicy.getActionExecutionPolicy();
        if (object == null) {
            object = IndexUtilsKt.isBucketLevelMonitor((Monitor)monitor) ? ActionExecutionPolicy.Companion.getDefaultConfigurationForBucketLevelMonitor() : (AlertingUtilsKt.isDocLevelMonitor(monitor) ? ActionExecutionPolicy.Companion.getDefaultConfigurationForDocumentLevelMonitor() : null);
        }
        return object;
    }

    @NotNull
    public static final BucketLevelTriggerRunResult getCombinedTriggerRunResult(@NotNull BucketLevelTriggerRunResult $this$getCombinedTriggerRunResult, @Nullable BucketLevelTriggerRunResult prevTriggerRunResult) {
        Intrinsics.checkNotNullParameter((Object)$this$getCombinedTriggerRunResult, (String)"<this>");
        if (prevTriggerRunResult == null) {
            return $this$getCombinedTriggerRunResult;
        }
        Map mergedAggregationResultBuckets = MapsKt.plus(prevTriggerRunResult.getAggregationResultBuckets(), $this$getCombinedTriggerRunResult.getAggregationResultBuckets());
        Map mergedActionResultsMap = MapsKt.toMutableMap((Map)MapsKt.plus(prevTriggerRunResult.getActionResultsMap(), $this$getCombinedTriggerRunResult.getActionResultsMap()));
        Exception exception = $this$getCombinedTriggerRunResult.getError();
        if (exception == null) {
            exception = prevTriggerRunResult.getError();
        }
        Exception error = exception;
        return BucketLevelTriggerRunResult.copy$default($this$getCombinedTriggerRunResult, null, error, mergedAggregationResultBuckets, mergedActionResultsMap, 1, null);
    }

    public static final boolean defaultToPerExecutionAction(long maxActionableAlertCount, @NotNull String monitorId, @NotNull String triggerId, int totalActionableAlertCount, @Nullable Exception monitorOrTriggerError) {
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter((Object)triggerId, (String)"triggerId");
        if (monitorOrTriggerError != null) {
            logger.debug("Trigger [" + triggerId + "] in monitor [" + monitorId + "] encountered an error. Defaulting to [" + ActionExecutionScope.Type.PER_EXECUTION + "] for action execution to communicate error.");
            return true;
        }
        if (maxActionableAlertCount < 0L) {
            return false;
        }
        if ((long)totalActionableAlertCount > maxActionableAlertCount) {
            logger.debug("The total actionable alerts for trigger [" + triggerId + "] in monitor [" + monitorId + "] is [" + totalActionableAlertCount + "] which exceeds the maximum of [" + maxActionableAlertCount + "]. Defaulting to [" + ActionExecutionScope.Type.PER_EXECUTION + "] for action execution.");
            return true;
        }
        return false;
    }
}

