/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.models;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.common.transport.model.MLModelGetResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetModelTransportAction
extends HandledTransportAction<ActionRequest, MLModelGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetModelTransportAction.class);
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ClusterService clusterService;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public GetModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/models/get", transportService, actionFilters, MLModelGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLModelGetResponse> actionListener) {
        MLModelGetRequest mlModelGetRequest = MLModelGetRequest.fromActionRequest((ActionRequest)request);
        String modelId = mlModelGetRequest.getModelId();
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlModelGetRequest.isReturnContent());
        GetRequest getRequest = new GetRequest(".plugins-ml-model").id(modelId).fetchSourceContext(fetchSourceContext);
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> context.restore());
            this.client.get(getRequest, ActionListener.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        GetResponse getResponse = r;
                        String algorithmName = getResponse.getSource().get("algorithm").toString();
                        MLModel mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
                        this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                            if (!access.booleanValue()) {
                                wrappedListener.onFailure((Exception)new MLValidationException("User Doesn't have privilege to perform this operation on this model"));
                            } else {
                                log.debug("Completed Get Model Request, id:{}", (Object)modelId);
                                Connector connector = mlModel.getConnector();
                                if (connector != null) {
                                    connector.removeCredential();
                                }
                                wrappedListener.onResponse((Object)MLModelGetResponse.builder().mlModel(mlModel).build());
                            }
                        }, e -> {
                            log.error("Failed to validate Access for Model Id " + modelId, (Throwable)e);
                            wrappedListener.onFailure(e);
                        }));
                    }
                    catch (Exception e2) {
                        log.error("Failed to parse ml model " + r.getId(), (Throwable)e2);
                        wrappedListener.onFailure(e2);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model with the provided model id: " + modelId, RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model"));
                } else {
                    log.error("Failed to get ML model " + modelId, (Throwable)e);
                    wrappedListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            log.error("Failed to get ML model " + modelId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

