/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.kernel;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import org.tribuo.math.kernel.Kernel;
import org.tribuo.math.la.SparseVector;

public class Sigmoid
implements Kernel {
    private static final long serialVersionUID = 1L;
    @Config(mandatory=true, description="Coefficient to multiply the dot product by.")
    private double gamma;
    @Config(mandatory=true, description="Scalar intercept to add to the dot product.")
    private double intercept;

    private Sigmoid() {
    }

    public Sigmoid(double gamma, double intercept) {
        this.gamma = gamma;
        this.intercept = intercept;
    }

    @Override
    public double similarity(SparseVector a, SparseVector b) {
        return Math.tanh(this.gamma * a.dot(b) + this.intercept);
    }

    public String toString() {
        return "Sigmoid(gamma=" + this.gamma + ",intercept=" + this.intercept + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Kernel");
    }
}

