/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.opensearch.index.codec.customcodecs.Lucene95CustomCodec;
import org.opensearch.index.codec.customcodecs.ZstdCompressionMode;
import org.opensearch.index.codec.customcodecs.ZstdNoDictCompressionMode;

public class Lucene95CustomStoredFieldsFormat
extends StoredFieldsFormat {
    public static final String MODE_KEY = Lucene95CustomStoredFieldsFormat.class.getSimpleName() + ".mode";
    private static final int ZSTD_BLOCK_LENGTH = 491520;
    private static final int ZSTD_MAX_DOCS_PER_BLOCK = 4096;
    private static final int ZSTD_BLOCK_SHIFT = 10;
    private final CompressionMode zstdCompressionMode;
    private final CompressionMode zstdNoDictCompressionMode;
    private final Lucene95CustomCodec.Mode mode;
    private final int compressionLevel;

    public Lucene95CustomStoredFieldsFormat() {
        this(Lucene95CustomCodec.Mode.ZSTD, 3);
    }

    public Lucene95CustomStoredFieldsFormat(Lucene95CustomCodec.Mode mode) {
        this(mode, 3);
    }

    public Lucene95CustomStoredFieldsFormat(Lucene95CustomCodec.Mode mode, int compressionLevel) {
        this.mode = Objects.requireNonNull(mode);
        this.compressionLevel = compressionLevel;
        this.zstdCompressionMode = new ZstdCompressionMode(compressionLevel);
        this.zstdNoDictCompressionMode = new ZstdNoDictCompressionMode(compressionLevel);
    }

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        String value = si.getAttribute(MODE_KEY);
        if (value == null) {
            throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + si.name);
        }
        Lucene95CustomCodec.Mode mode = Lucene95CustomCodec.Mode.valueOf(value);
        return this.impl(mode).fieldsReader(directory, si, fn, context);
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        String previous = si.putAttribute(MODE_KEY, this.mode.name());
        if (previous != null && !previous.equals(this.mode.name())) {
            throw new IllegalStateException("found existing value for " + MODE_KEY + " for segment: " + si.name + " old = " + previous + ", new = " + this.mode.name());
        }
        return this.impl(this.mode).fieldsWriter(directory, si, context);
    }

    StoredFieldsFormat impl(Lucene95CustomCodec.Mode mode) {
        switch (mode) {
            case ZSTD: 
            case ZSTD_DEPRECATED: {
                return new Lucene90CompressingStoredFieldsFormat("CustomStoredFieldsZstd", this.zstdCompressionMode, 491520, 4096, 10);
            }
            case ZSTD_NO_DICT: {
                return new Lucene90CompressingStoredFieldsFormat("CustomStoredFieldsZstdNoDict", this.zstdNoDictCompressionMode, 491520, 4096, 10);
            }
        }
        throw new AssertionError();
    }

    Lucene95CustomCodec.Mode getMode() {
        return this.mode;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }
}

