/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.management;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Randomness;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContext;
import org.opensearch.search.asynchronous.response.AcknowledgedResponse;
import org.opensearch.search.asynchronous.service.AsynchronousSearchPersistenceService;
import org.opensearch.search.asynchronous.service.AsynchronousSearchService;
import org.opensearch.search.asynchronous.settings.LegacyOpendistroAsynchronousSearchSettings;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class AsynchronousSearchManagementService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(AsynchronousSearchManagementService.class);
    private final ClusterService clusterService;
    private final AsynchronousSearchPersistenceService asynchronousSearchPersistenceService;
    private final ThreadPool threadPool;
    private volatile Scheduler.Cancellable activeContextReaperScheduledFuture;
    private static final String RESPONSE_CLEANUP_SCHEDULING_EXECUTOR = "management";
    private AtomicReference<PersistedResponseCleanUpAndRescheduleRunnable> persistedResponseCleanUpRunnable = new AtomicReference();
    private AsynchronousSearchService asynchronousSearchService;
    private TransportService transportService;
    private TimeValue activeContextReaperInterval;
    private TimeValue persistedResponseCleanUpInterval;
    public static final String PERSISTED_RESPONSE_CLEANUP_ACTION_NAME = "indices:data/read/opendistro/asynchronous_search/response_cleanup";
    public static final Setting<TimeValue> ACTIVE_CONTEXT_REAPER_INTERVAL_SETTING = Setting.timeSetting((String)"plugins.asynchronous_search.active.context.reaper_interval", LegacyOpendistroAsynchronousSearchSettings.ACTIVE_CONTEXT_REAPER_INTERVAL_SETTING, (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> PERSISTED_RESPONSE_CLEAN_UP_INTERVAL_SETTING = Setting.timeSetting((String)"plugins.asynchronous_search.expired.persisted_response.cleanup_interval", LegacyOpendistroAsynchronousSearchSettings.PERSISTED_RESPONSE_CLEAN_UP_INTERVAL_SETTING, (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    @Inject
    public AsynchronousSearchManagementService(Settings settings, ClusterService clusterService, ThreadPool threadPool, AsynchronousSearchService asynchronousSearchService, TransportService transportService, AsynchronousSearchPersistenceService asynchronousSearchPersistenceService) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.clusterService.addListener((ClusterStateListener)this);
        this.asynchronousSearchService = asynchronousSearchService;
        this.transportService = transportService;
        this.asynchronousSearchPersistenceService = asynchronousSearchPersistenceService;
        this.activeContextReaperInterval = (TimeValue)ACTIVE_CONTEXT_REAPER_INTERVAL_SETTING.get(settings);
        this.persistedResponseCleanUpInterval = (TimeValue)PERSISTED_RESPONSE_CLEAN_UP_INTERVAL_SETTING.get(settings);
        transportService.registerRequestHandler(PERSISTED_RESPONSE_CLEANUP_ACTION_NAME, "same", false, false, AsynchronousSearchCleanUpRequest::new, (TransportRequestHandler)new PersistedResponseCleanUpTransportHandler());
    }

    private void asyncCleanUpOperation(AsynchronousSearchCleanUpRequest request, Task task, ActionListener<AcknowledgedResponse> listener) {
        this.transportService.getThreadPool().executor("opensearch_asynchronous_search_generic").execute(() -> this.performPersistedResponseCleanUpAction(request, listener));
    }

    private void performPersistedResponseCleanUpAction(AsynchronousSearchCleanUpRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.asynchronousSearchPersistenceService.deleteExpiredResponses(listener, request.absoluteTimeInMillis);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeClusterManager() && this.persistedResponseCleanUpRunnable.get() == null) {
            logger.trace("elected as cluster_manager, triggering response cleanup tasks");
            this.triggerCleanUp(event.state(), "became cluster_manager");
            PersistedResponseCleanUpAndRescheduleRunnable newRunnable = new PersistedResponseCleanUpAndRescheduleRunnable();
            this.persistedResponseCleanUpRunnable.set(newRunnable);
            this.threadPool.scheduleUnlessShuttingDown(this.persistedResponseCleanUpInterval, RESPONSE_CLEANUP_SCHEDULING_EXECUTOR, (Runnable)((Object)newRunnable));
        } else if (!event.localNodeClusterManager()) {
            this.persistedResponseCleanUpRunnable.set(null);
            return;
        }
    }

    private void triggerCleanUp(ClusterState clusterState, String reason) {
        if (clusterState.nodes().getDataNodes().size() > 0) {
            logger.debug("triggering response cleanup in background [{}]", (Object)reason);
            this.threadPool.executor(RESPONSE_CLEANUP_SCHEDULING_EXECUTOR).execute((Runnable)((Object)new ResponseCleanUpRunnable(reason)));
        }
    }

    protected void doStart() {
        this.activeContextReaperScheduledFuture = this.threadPool.scheduleWithFixedDelay((Runnable)new ActiveContextReaper(), this.activeContextReaperInterval, "opensearch_asynchronous_search_generic");
    }

    protected void doStop() {
        this.persistedResponseCleanUpRunnable.set(null);
        this.activeContextReaperScheduledFuture.cancel();
    }

    protected void doClose() {
        this.persistedResponseCleanUpRunnable.set(null);
        this.activeContextReaperScheduledFuture.cancel();
    }

    public final void performCleanUp() {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            Map dataNodes = this.clusterService.state().nodes().getDataNodes();
            List nodes = Stream.of(dataNodes.values().toArray(new DiscoveryNode[0])).collect(Collectors.toList());
            if (nodes == null || nodes.isEmpty()) {
                logger.debug("Found empty data nodes with asynchronous search enabled attribute [{}] for response clean up", (Object)dataNodes);
                return;
            }
            int pos = Randomness.get().nextInt(nodes.size());
            final DiscoveryNode randomNode = (DiscoveryNode)nodes.get(pos);
            this.transportService.sendRequest(randomNode, PERSISTED_RESPONSE_CLEANUP_ACTION_NAME, (TransportRequest)new AsynchronousSearchCleanUpRequest(this.threadPool.absoluteTimeInMillis()), (TransportResponseHandler)new TransportResponseHandler<AcknowledgedResponse>(){

                public AcknowledgedResponse read(StreamInput in) throws IOException {
                    return new AcknowledgedResponse(in);
                }

                public void handleResponse(AcknowledgedResponse response) {
                    logger.debug("Successfully executed clean up action on node [{}] with response [{}]", (Object)randomNode, (Object)response.isAcknowledged());
                }

                public void handleException(TransportException e) {
                    logger.error(() -> new ParameterizedMessage("Exception executing action [{}]", (Object)AsynchronousSearchManagementService.PERSISTED_RESPONSE_CLEANUP_ACTION_NAME), (Throwable)e);
                }

                public String executor() {
                    return "opensearch_asynchronous_search_generic";
                }
            });
        }
        catch (Exception ex) {
            logger.error("Failed to schedule asynchronous search cleanup", (Throwable)ex);
        }
    }

    class PersistedResponseCleanUpTransportHandler
    implements TransportRequestHandler<AsynchronousSearchCleanUpRequest> {
        PersistedResponseCleanUpTransportHandler() {
        }

        public void messageReceived(AsynchronousSearchCleanUpRequest request, TransportChannel channel, Task task) {
            AsynchronousSearchManagementService.this.asyncCleanUpOperation(request, task, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(arg_0 -> ((TransportChannel)channel).sendResponse(arg_0), e -> {
                try {
                    channel.sendResponse(e);
                }
                catch (IOException ex) {
                    logger.warn(() -> new ParameterizedMessage("Failed to send cleanup error response for request [{}]", (Object)request), (Throwable)ex);
                }
            }));
        }
    }

    static class AsynchronousSearchCleanUpRequest
    extends ActionRequest {
        private final long absoluteTimeInMillis;

        AsynchronousSearchCleanUpRequest(long absoluteTimeInMillis) {
            this.absoluteTimeInMillis = absoluteTimeInMillis;
        }

        AsynchronousSearchCleanUpRequest(StreamInput in) throws IOException {
            super(in);
            this.absoluteTimeInMillis = in.readLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.absoluteTimeInMillis);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public long getAbsoluteTimeInMillis() {
            return this.absoluteTimeInMillis;
        }

        public int hashCode() {
            return Objects.hash(this.absoluteTimeInMillis);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            AsynchronousSearchCleanUpRequest asynchronousSearchCleanUpRequest = (AsynchronousSearchCleanUpRequest)((Object)o);
            return this.absoluteTimeInMillis == asynchronousSearchCleanUpRequest.absoluteTimeInMillis;
        }

        public String toString() {
            return "[expirationTimeMillis] : " + this.absoluteTimeInMillis;
        }
    }

    private class PersistedResponseCleanUpAndRescheduleRunnable
    extends ResponseCleanUpRunnable {
        PersistedResponseCleanUpAndRescheduleRunnable() {
            super("scheduled");
        }

        @Override
        protected void doRun() {
            if (this == AsynchronousSearchManagementService.this.persistedResponseCleanUpRunnable.get()) {
                super.doRun();
            } else {
                logger.trace("cluster_manager changed, scheduled cleanup job is stale");
            }
        }

        public void onAfter() {
            if (this == AsynchronousSearchManagementService.this.persistedResponseCleanUpRunnable.get()) {
                logger.trace("scheduling next clean up job in [{}]", (Object)AsynchronousSearchManagementService.this.persistedResponseCleanUpInterval);
                AsynchronousSearchManagementService.this.threadPool.scheduleUnlessShuttingDown(AsynchronousSearchManagementService.this.persistedResponseCleanUpInterval, AsynchronousSearchManagementService.RESPONSE_CLEANUP_SCHEDULING_EXECUTOR, (Runnable)((Object)this));
            }
        }
    }

    private class ResponseCleanUpRunnable
    extends AbstractRunnable {
        private final String reason;

        ResponseCleanUpRunnable(String reason) {
            this.reason = reason;
        }

        protected void doRun() {
            AsynchronousSearchManagementService.this.performCleanUp();
        }

        public void onFailure(Exception e) {
            logger.warn((Message)new ParameterizedMessage("sync search clean up job failed [{}]", (Object)this.reason), (Throwable)e);
        }

        public void onRejection(Exception e) {
            boolean shutDown = e instanceof OpenSearchRejectedExecutionException && ((OpenSearchRejectedExecutionException)e).isExecutorShutdown();
            logger.log(shutDown ? Level.DEBUG : Level.WARN, "asynchronous search clean up job rejected [{}]", (Object)this.reason, (Object)e);
        }
    }

    class ActiveContextReaper
    implements Runnable {
        ActiveContextReaper() {
        }

        @Override
        public void run() {
            try {
                Set<AsynchronousSearchContext> toFree = AsynchronousSearchManagementService.this.asynchronousSearchService.getContextsToReap();
                toFree.forEach(context -> AsynchronousSearchManagementService.this.asynchronousSearchService.freeContext(context.getAsynchronousSearchId(), context.getContextId(), null, (ActionListener<Boolean>)ActionListener.wrap(response -> logger.debug("Successfully freed up context [{}] running duration [{}]", (Object)context.getAsynchronousSearchId(), (Object)(context.getExpirationTimeMillis() - context.getStartTimeMillis())), exception -> logger.debug(() -> new ParameterizedMessage("Failed to cleanup asynchronous search context [{}] running duration [{}] due to ", (Object)context.getAsynchronousSearchId(), (Object)(context.getExpirationTimeMillis() - context.getStartTimeMillis())), (Throwable)exception))));
            }
            catch (Exception ex) {
                logger.error("Failed to free up overrunning asynchronous searches due to ", (Throwable)ex);
            }
        }
    }
}

