/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.index;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchWrapperException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.Client;
import org.opensearch.client.Requests;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.memory.index.ConversationMetaIndex;
import org.opensearch.search.SearchHit;
import org.opensearch.search.sort.SortOrder;

public class InteractionsIndex {
    @Generated
    private static final Logger log = LogManager.getLogger(InteractionsIndex.class);
    private Client client;
    private ClusterService clusterService;
    private ConversationMetaIndex conversationMetaIndex;
    private final String indexName = ".plugins-ml-conversation-interactions";
    private final int resultsAtATime = 300;

    public void initInteractionsIndexIfAbsent(ActionListener<Boolean> listener) {
        block11: {
            if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-conversation-interactions")) {
                log.debug("No interactions index found. Adding it");
                CreateIndexRequest request = Requests.createIndexRequest((String)".plugins-ml-conversation-interactions").mapping(ConversationalIndexConstants.INTERACTIONS_MAPPINGS);
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
                    ActionListener al = ActionListener.wrap(r -> {
                        if (r.equals((Object)new CreateIndexResponse(true, true, ".plugins-ml-conversation-interactions"))) {
                            log.info("created index [.plugins-ml-conversation-interactions]");
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        if (e instanceof ResourceAlreadyExistsException || e instanceof OpenSearchWrapperException && e.getCause() instanceof ResourceAlreadyExistsException) {
                            internalListener.onResponse((Object)true);
                        } else {
                            log.error("Failed to create index [.plugins-ml-conversation-interactions]", (Throwable)e);
                            internalListener.onFailure(e);
                        }
                    });
                    this.client.admin().indices().create(request, al);
                }
                catch (Exception e2) {
                    if (e2 instanceof ResourceAlreadyExistsException || e2 instanceof OpenSearchWrapperException && e2.getCause() instanceof ResourceAlreadyExistsException) {
                        listener.onResponse((Object)true);
                        break block11;
                    }
                    log.error("Failed to create index [.plugins-ml-conversation-interactions]", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onResponse((Object)true);
            }
        }
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, String additionalInfo, Instant timestamp, ActionListener<String> listener) {
        this.initInteractionsIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexExists -> {
            String user;
            String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
            String string = user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
            if (indexExists.booleanValue()) {
                this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                    if (access.booleanValue()) {
                        IndexRequest request = Requests.indexRequest((String)".plugins-ml-conversation-interactions").source(new Object[]{"origin", origin, "conversation_id", conversationId, "input", input, "prompt_template", promptTemplate, "response", response, "additional_info", additionalInfo, "create_time", timestamp});
                        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                            ActionListener internalListener = ActionListener.runBefore((ActionListener)listener, () -> threadContext.restore());
                            ActionListener al = ActionListener.wrap(resp -> {
                                if (resp.status() == RestStatus.CREATED) {
                                    internalListener.onResponse((Object)resp.getId());
                                } else {
                                    internalListener.onFailure((Exception)new IOException("Failed to create interaction"));
                                }
                            }, e -> internalListener.onFailure(e));
                            this.client.index(request, al);
                        }
                        catch (Exception e2) {
                            listener.onFailure(e2);
                        }
                    } else {
                        throw new OpenSearchSecurityException("User [" + user + "] does not have access to conversation " + conversationId, new Object[0]);
                    }
                }, e -> listener.onFailure(e)));
            } else {
                listener.onFailure((Exception)new IOException("no index to add conversation to"));
            }
        }, e -> listener.onFailure(e)));
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, String additionalInfo, ActionListener<String> listener) {
        this.createInteraction(conversationId, input, promptTemplate, response, origin, additionalInfo, Instant.now(), listener);
    }

    public void getInteractions(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-conversation-interactions")) {
            listener.onResponse(List.of());
            return;
        }
        ActionListener accessListener = ActionListener.wrap(access -> {
            if (!access.booleanValue()) {
                String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
                throw new OpenSearchSecurityException("User [" + user + "] does not have access to conversation " + conversationId, new Object[0]);
            }
            this.innerGetInteractions(conversationId, from, maxResults, listener);
        }, e -> listener.onFailure(e));
        this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
    }

    @VisibleForTesting
    void innerGetInteractions(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        SearchRequest request = Requests.searchRequest((String[])new String[]{".plugins-ml-conversation-interactions"});
        TermQueryBuilder builder = new TermQueryBuilder("conversation_id", conversationId);
        request.source().query((QueryBuilder)builder);
        request.source().from(from).size(maxResults);
        request.source().sort("create_time", SortOrder.DESC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListener.wrap(response -> {
                LinkedList<Interaction> result = new LinkedList<Interaction>();
                for (SearchHit hit : response.getHits()) {
                    result.add(Interaction.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-conversation-interactions"}), ActionListener.wrap(r -> this.client.search(request, al), e -> internalListener.onFailure(e)));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    @VisibleForTesting
    void getAllInteractions(String conversationId, int maxResults, ActionListener<List<Interaction>> listener) {
        ActionListener<List<Interaction>> al = this.nextGetListener(conversationId, 0, maxResults, listener, new LinkedList<Interaction>());
        this.innerGetInteractions(conversationId, 0, maxResults, al);
    }

    @VisibleForTesting
    ActionListener<List<Interaction>> nextGetListener(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> mainListener, List<Interaction> result) {
        if (maxResults < 1) {
            mainListener.onFailure((Exception)new IllegalArgumentException("maxResults must be positive"));
            return null;
        }
        return ActionListener.wrap(interactions -> {
            result.addAll((Collection<Interaction>)interactions);
            if (interactions.size() < maxResults) {
                mainListener.onResponse((Object)result);
            } else {
                ActionListener<List<Interaction>> al = this.nextGetListener(conversationId, from + maxResults, maxResults, mainListener, result);
                this.innerGetInteractions(conversationId, from + maxResults, maxResults, al);
            }
        }, e -> mainListener.onFailure(e));
    }

    public void deleteConversation(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-conversation-interactions")) {
            listener.onResponse((Object)true);
            return;
        }
        String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            ActionListener searchListener = ActionListener.wrap(interactions -> {
                BulkRequest request = Requests.bulkRequest();
                for (Interaction interaction : interactions) {
                    DeleteRequest delRequest = Requests.deleteRequest((String)".plugins-ml-conversation-interactions").id(interaction.getId());
                    request.add(delRequest);
                }
                this.client.bulk(request, ActionListener.wrap(bulkResponse -> internalListener.onResponse((Object)(!bulkResponse.hasFailures() ? 1 : 0)), e -> internalListener.onFailure(e)));
            }, e -> internalListener.onFailure(e));
            ActionListener accessListener = ActionListener.wrap(access -> {
                if (!access.booleanValue()) {
                    throw new OpenSearchSecurityException("User [" + user + "] does not have access to conversation " + conversationId, new Object[0]);
                }
                this.getAllInteractions(conversationId, 300, (ActionListener<List<Interaction>>)searchListener);
            }, e -> listener.onFailure(e));
            this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
        }
        catch (Exception e2) {
            log.error("Failure while deleting interactions associated with conversation id=" + conversationId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    @Generated
    public InteractionsIndex(Client client, ClusterService clusterService, ConversationMetaIndex conversationMetaIndex) {
        this.client = client;
        this.clusterService = clusterService;
        this.conversationMetaIndex = conversationMetaIndex;
    }
}

