/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputEndsWithNodeGen;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputReadNode;

public abstract class InputEndsWithNode
extends Node {
    public static InputEndsWithNode create() {
        return InputEndsWithNodeGen.create();
    }

    public abstract boolean execute(Object var1, Object var2, Object var3);

    @Specialization(guards={"mask == null"})
    public boolean doBytes(byte[] input, byte[] suffix, Object mask) {
        return ArrayUtils.regionEqualsWithOrMask((byte[])input, (int)(input.length - suffix.length), (byte[])suffix, (int)0, (int)suffix.length, null);
    }

    @Specialization(guards={"mask != null"})
    public boolean doBytesMask(byte[] input, byte[] suffix, byte[] mask) {
        return ArrayUtils.regionEqualsWithOrMask((byte[])input, (int)(input.length - suffix.length), (byte[])suffix, (int)0, (int)mask.length, (byte[])mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean doString(String input, String suffix, Object mask) {
        return input.endsWith(suffix);
    }

    @Specialization(guards={"mask != null"})
    public boolean doStringMask(String input, String suffix, String mask) {
        return ArrayUtils.regionEqualsWithOrMask((String)input, (int)(input.length() - suffix.length()), (String)suffix, (int)0, (int)mask.length(), (String)mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean doTruffleObjBytes(TruffleObject input, byte[] suffix, Object mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEndsWithNode.endsWithTruffleObj(input, suffix, null, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask != null"})
    public boolean doTruffleObjBytesMask(TruffleObject input, byte[] suffix, byte[] mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        assert (mask.length == suffix.length);
        return InputEndsWithNode.endsWithTruffleObj(input, suffix, mask, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask == null"})
    public boolean doTruffleObjString(TruffleObject input, String suffix, Object mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEndsWithNode.endsWithTruffleObj(input, suffix, null, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask != null"})
    public boolean doTruffleObjStringMask(TruffleObject input, String suffix, String mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        assert (mask.length() == suffix.length());
        return InputEndsWithNode.endsWithTruffleObj(input, suffix, mask, lengthNode, charAtNode);
    }

    private static boolean endsWithTruffleObj(TruffleObject input, byte[] suffix, byte[] mask, InputLengthNode lengthNode, InputReadNode charAtNode) {
        int inputLength = lengthNode.execute(input);
        if (inputLength < suffix.length) {
            return false;
        }
        int offset = inputLength - suffix.length;
        for (int i = 0; i < suffix.length; ++i) {
            if (InputReadNode.readWithMask(input, offset + i, mask, i, charAtNode) == Byte.toUnsignedInt(suffix[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean endsWithTruffleObj(TruffleObject input, String suffix, String mask, InputLengthNode lengthNode, InputReadNode charAtNode) {
        int inputLength = lengthNode.execute(input);
        if (inputLength < suffix.length()) {
            return false;
        }
        int offset = inputLength - suffix.length();
        for (int i = 0; i < suffix.length(); ++i) {
            if (InputReadNode.readWithMask(input, offset + i, mask, i, charAtNode) == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

