/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.completion;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.java.completion.BaseTask;

public final class JavaTooltipTask
extends BaseTask {
    private static final String INIT = "<init>";
    private static final String THIS_KEYWORD = "this";
    private static final String SUPER_KEYWORD = "super";
    private int anchorOffset;
    private List<List<String>> toolTipData;
    private List<String> toolTipSignatures;
    private int toolTipIndex;
    private int activeSignatureIndex;
    private int toolTipOffset;

    public static JavaTooltipTask create(int caretOffset, @NullAllowed Callable<Boolean> cancel) {
        return new JavaTooltipTask(caretOffset, cancel);
    }

    private JavaTooltipTask(int caretOffset, Callable<Boolean> cancel) {
        super(caretOffset, cancel);
    }

    public List<List<String>> getTooltipData() {
        return this.toolTipData;
    }

    public List<String> getTooltipSignatures() {
        return this.toolTipSignatures;
    }

    public int getTooltipIndex() {
        return this.toolTipIndex;
    }

    public int getActiveSignatureIndex() {
        return this.activeSignatureIndex;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public int getTooltipOffset() {
        return this.toolTipOffset;
    }

    @Override
    protected void resolve(CompilationController controller) throws IOException {
        BaseTask.Env env = this.getCompletionEnvironment(controller, false);
        if (env == null) {
            return;
        }
        Tree lastTree = null;
        int offset = env.getOffset();
        for (TreePath path = env.getPath(); path != null; path = path.getParentPath()) {
            int startPos;
            SourcePositions sourcePositions;
            CompilationUnitTree root;
            Tree tree = path.getLeaf();
            if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
                MethodInvocationTree mi = (MethodInvocationTree)tree;
                root = env.getRoot();
                sourcePositions = env.getSourcePositions();
                startPos = lastTree != null ? (int)sourcePositions.getStartPosition(root, lastTree) : offset;
                List<Tree> argTypes = this.getArgumentsUpToPos(env, mi.getArguments(), (int)sourcePositions.getEndPosition(root, mi.getMethodSelect()), startPos, false);
                if (argTypes != null) {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    final Trees trees = controller.getTrees();
                    TypeMirror[] types = new TypeMirror[argTypes.size()];
                    int j = 0;
                    for (Tree t : argTypes) {
                        types[j++] = trees.getTypeMirror(new TreePath(path, t));
                    }
                    ExpressionTree expressionTree = mi.getMethodSelect();
                    Element activeElement = trees.getElement(path);
                    path = new TreePath(path, expressionTree);
                    switch (expressionTree.getKind()) {
                        case MEMBER_SELECT: {
                            ExpressionTree exp = ((MemberSelectTree)expressionTree).getExpression();
                            path = new TreePath(path, exp);
                            TypeMirror type = trees.getTypeMirror(path);
                            Element element = trees.getElement(path);
                            final boolean isStatic = element != null && (element.getKind().isClass() || element.getKind().isInterface() || element.getKind() == ElementKind.TYPE_PARAMETER);
                            final boolean isSuperCall = element != null && element.getKind().isField() && element.getSimpleName().contentEquals(SUPER_KEYWORD);
                            final Scope scope = env.getScope();
                            TypeElement enclClass = scope.getEnclosingClass();
                            final TypeMirror enclType = enclClass != null ? enclClass.asType() : null;
                            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                                public boolean accept(Element e, TypeMirror t) {
                                    return !(isStatic && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getKind() != ElementKind.CONSTRUCTOR || t.getKind() == TypeKind.DECLARED && !trees.isAccessible(scope, e, (DeclaredType)(isSuperCall && enclType != null ? enclType : t)));
                                }
                            };
                            this.handleMatchingParams((CompilationInfo)controller, type, activeElement, controller.getElementUtilities().getMembers(type, acceptor), ((MemberSelectTree)expressionTree).getIdentifier().toString(), types);
                            break;
                        }
                        case IDENTIFIER: {
                            final Scope scope = env.getScope();
                            TreeUtilities tu = controller.getTreeUtilities();
                            TypeElement enclClass = scope.getEnclosingClass();
                            final boolean isStatic = enclClass != null ? tu.isStaticContext(scope) || env.getPath().getLeaf().getKind() == Tree.Kind.BLOCK && ((BlockTree)env.getPath().getLeaf()).isStatic() : false;
                            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                                public boolean accept(Element e, TypeMirror t) {
                                    switch (e.getKind()) {
                                        case CONSTRUCTOR: {
                                            return !e.getModifiers().contains((Object)Modifier.PRIVATE);
                                        }
                                        case METHOD: {
                                            return (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && trees.isAccessible(scope, e, (DeclaredType)t);
                                        }
                                    }
                                    return false;
                                }
                            };
                            String name = ((IdentifierTree)expressionTree).getName().toString();
                            if (SUPER_KEYWORD.equals(name) && enclClass != null) {
                                TypeMirror superclass = enclClass.getSuperclass();
                                this.handleMatchingParams((CompilationInfo)controller, superclass, activeElement, controller.getElementUtilities().getMembers(superclass, acceptor), INIT, types);
                                break;
                            }
                            if (THIS_KEYWORD.equals(name) && enclClass != null) {
                                TypeMirror thisclass = enclClass.asType();
                                this.handleMatchingParams((CompilationInfo)controller, thisclass, activeElement, controller.getElementUtilities().getMembers(thisclass, acceptor), INIT, types);
                                break;
                            }
                            this.handleMatchingParams((CompilationInfo)controller, enclClass != null ? enclClass.asType() : null, activeElement, controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor), name, types);
                            break;
                        }
                    }
                    this.toolTipIndex = types.length;
                    startPos = (int)sourcePositions.getEndPosition(env.getRoot(), mi.getMethodSelect());
                    String text = controller.getText().substring(startPos, offset);
                    int idx = text.indexOf(40);
                    this.anchorOffset = idx < 0 ? startPos : startPos + controller.getSnapshot().getOriginalOffset(idx);
                    idx = text.lastIndexOf(44);
                    int n = this.toolTipOffset = idx < 0 ? startPos : startPos + controller.getSnapshot().getOriginalOffset(idx);
                    if (this.toolTipOffset < this.anchorOffset) {
                        this.toolTipOffset = this.anchorOffset;
                    }
                    return;
                }
            } else if (tree.getKind() == Tree.Kind.NEW_CLASS) {
                NewClassTree nc = (NewClassTree)tree;
                root = env.getRoot();
                sourcePositions = env.getSourcePositions();
                startPos = lastTree != null ? (int)sourcePositions.getStartPosition(root, lastTree) : offset;
                int pos = (int)sourcePositions.getEndPosition(root, nc.getIdentifier());
                List<Tree> argTypes = this.getArgumentsUpToPos(env, nc.getArguments(), pos, startPos, false);
                if (argTypes != null) {
                    String text;
                    int idx;
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    final Trees trees = controller.getTrees();
                    TypeMirror[] types = new TypeMirror[argTypes.size()];
                    boolean bl = false;
                    for (Tree t : argTypes) {
                        types[++var15_24] = trees.getTypeMirror(new TreePath(path, t));
                    }
                    Element activeElement = trees.getElement(path);
                    TypeMirror type = trees.getTypeMirror(path = new TreePath(path, nc.getIdentifier()));
                    if (type != null && type.getKind() == TypeKind.ERROR && path.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                        path = new TreePath(path, ((ParameterizedTypeTree)path.getLeaf()).getType());
                        type = trees.getTypeMirror(path);
                    }
                    Element el = trees.getElement(path);
                    final Scope scope = env.getScope();
                    final boolean isAnonymous = nc.getClassBody() != null || el != null && (el.getKind().isInterface() || el.getModifiers().contains((Object)Modifier.ABSTRACT));
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror t) {
                            return e.getKind() == ElementKind.CONSTRUCTOR && (trees.isAccessible(scope, e, (DeclaredType)t) || isAnonymous && e.getModifiers().contains((Object)Modifier.PROTECTED));
                        }
                    };
                    this.handleMatchingParams((CompilationInfo)controller, type, activeElement, controller.getElementUtilities().getMembers(type, acceptor), INIT, types);
                    this.toolTipIndex = types.length;
                    if (pos < 0) {
                        path = path.getParentPath();
                        pos = (int)sourcePositions.getStartPosition(root, path.getLeaf());
                    }
                    this.anchorOffset = (idx = (text = controller.getText().substring(pos, offset)).indexOf(40)) < 0 ? pos : pos + controller.getSnapshot().getOriginalOffset(idx);
                    idx = text.lastIndexOf(44);
                    int n = this.toolTipOffset = idx < 0 ? pos : pos + controller.getSnapshot().getOriginalOffset(idx);
                    if (this.toolTipOffset < this.anchorOffset) {
                        this.toolTipOffset = this.anchorOffset;
                    }
                    return;
                }
            } else if (tree.getKind() == Tree.Kind.ANNOTATION) {
                AnnotationTree at = (AnnotationTree)tree;
                controller.toPhase(JavaSource.Phase.RESOLVED);
                Trees trees = controller.getTrees();
                Element element = trees.getElement(path);
                if (element != null && element.getKind() == ElementKind.ANNOTATION_TYPE) {
                    Element activeElement = lastTree != null && lastTree.getKind() == Tree.Kind.ASSIGNMENT ? trees.getElement(new TreePath(path, ((AssignmentTree)lastTree).getVariable())) : null;
                    TypeUtilities tu = controller.getTypeUtilities();
                    ArrayList<List<String>> data = new ArrayList<List<String>>();
                    ArrayList<String> signatures = new ArrayList<String>();
                    for (Element element2 : element.getEnclosedElements()) {
                        if (element2.getKind() != ElementKind.METHOD || element2.asType().getKind() != TypeKind.EXECUTABLE) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append(tu.getTypeName(((ExecutableType)element2.asType()).getReturnType(), new TypeUtilities.TypeNameOptions[0])).append(' ');
                        sb.append(element2.getSimpleName()).append("()");
                        AnnotationValue defaultValue = ((ExecutableElement)element2).getDefaultValue();
                        if (defaultValue != null) {
                            sb.append(" default ").append(defaultValue.toString());
                        }
                        if (element2 == activeElement) {
                            this.activeSignatureIndex = signatures.size();
                        }
                        data.add(Collections.singletonList(sb.toString()));
                        signatures.add(sb.toString());
                    }
                    this.toolTipData = data.isEmpty() ? null : data;
                    this.toolTipSignatures = signatures.isEmpty() ? null : signatures;
                    this.toolTipIndex = -1;
                    CompilationUnitTree root2 = env.getRoot();
                    SourcePositions sourcePositions2 = env.getSourcePositions();
                    int pos = (int)sourcePositions2.getEndPosition(root2, at.getAnnotationType());
                    String text = controller.getText().substring(pos, offset);
                    int idx = text.indexOf(40);
                    this.anchorOffset = idx < 0 ? pos : pos + controller.getSnapshot().getOriginalOffset(idx);
                    idx = text.lastIndexOf(44);
                    int n = this.toolTipOffset = idx < 0 ? pos : pos + controller.getSnapshot().getOriginalOffset(idx);
                    if (this.toolTipOffset < this.anchorOffset) {
                        this.toolTipOffset = this.anchorOffset;
                    }
                    return;
                }
            }
            lastTree = tree;
        }
    }

    private void handleMatchingParams(CompilationInfo info, TypeMirror type, Element activeElement, Iterable<? extends Element> elements, String name, TypeMirror[] argTypes) {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        ArrayList<String> signatures = new ArrayList<String>();
        Types types = info.getTypes();
        TypeUtilities tu = info.getTypeUtilities();
        this.activeSignatureIndex = 0;
        block0: for (Element element : elements) {
            if (element.getKind() != ElementKind.CONSTRUCTOR && element.getKind() != ElementKind.METHOD || !name.contentEquals(element.getSimpleName())) continue;
            List<? extends VariableElement> params = ((ExecutableElement)element).getParameters();
            int parSize = params.size();
            boolean varArgs = ((ExecutableElement)element).isVarArgs();
            if (!varArgs && parSize < argTypes.length) continue;
            if (element == activeElement) {
                this.activeSignatureIndex = signatures.size();
            }
            ExecutableType eType = (ExecutableType)this.asMemberOf(element, type, types);
            StringBuilder sig = new StringBuilder(INIT.equals(name) && type != null && type.getKind() == TypeKind.DECLARED ? ((DeclaredType)type).asElement().getSimpleName() : name).append('(');
            if (parSize == 0) {
                data.add(new ArrayList());
                sig.append(')');
                if (element.getKind() == ElementKind.METHOD) {
                    sig.append(" : ").append(tu.getTypeName(eType.getReturnType(), new TypeUtilities.TypeNameOptions[0]));
                }
                signatures.add(sig.toString());
                continue;
            }
            Iterator<? extends TypeMirror> parIt = eType.getParameterTypes().iterator();
            TypeMirror param = null;
            for (int i = 0; i <= argTypes.length; ++i) {
                if (parIt.hasNext()) {
                    param = parIt.next();
                    if (!parIt.hasNext() && param.getKind() == TypeKind.ARRAY) {
                        param = ((ArrayType)param).getComponentType();
                    }
                } else if (!varArgs) continue block0;
                if (i == argTypes.length) {
                    ArrayList<String> paramStrings = new ArrayList<String>(parSize);
                    Iterator<? extends TypeMirror> tIt = eType.getParameterTypes().iterator();
                    Iterator<? extends VariableElement> it = params.iterator();
                    while (it.hasNext()) {
                        Name veName;
                        VariableElement ve = it.next();
                        StringBuilder sb = new StringBuilder();
                        CharSequence typeName = tu.getTypeName(tIt.next(), new TypeUtilities.TypeNameOptions[0]);
                        sb.append(typeName);
                        sig.append(typeName);
                        if (varArgs && !tIt.hasNext()) {
                            sb.delete(sb.length() - 2, sb.length()).append("...");
                            sig.delete(sig.length() - 2, sig.length()).append("...");
                        }
                        if ((veName = ve.getSimpleName()) != null && veName.length() > 0) {
                            sb.append(" ").append(veName);
                            sig.append(" ").append(veName);
                        }
                        if (it.hasNext()) {
                            sig.append(", ");
                        }
                        paramStrings.add(sb.toString());
                    }
                    data.add(paramStrings);
                    sig.append(')');
                    if (element.getKind() == ElementKind.METHOD) {
                        sig.append(" : ").append(tu.getTypeName(eType.getReturnType(), new TypeUtilities.TypeNameOptions[0]));
                    }
                    signatures.add(sig.toString());
                    continue block0;
                }
                if (argTypes[i] == null || argTypes[i].getKind() != TypeKind.ERROR && !JavaTooltipTask.isAssignable(types, argTypes[i], param)) continue block0;
            }
        }
        this.toolTipData = data.isEmpty() ? null : data;
        this.toolTipSignatures = signatures.isEmpty() ? null : signatures;
    }

    private static boolean isAssignable(Types types, TypeMirror arg, TypeMirror parameter) {
        if (types.isAssignable(arg, parameter)) {
            return true;
        }
        if (parameter instanceof TypeVariable) {
            TypeMirror requiredTypes = ((TypeVariable)parameter).getUpperBound();
            return types.isAssignable(arg, requiredTypes);
        }
        return false;
    }
}

