/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.repository;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.api.queries.VersioningQuery;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.IssueQuickSearch;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.ui.repository.RepositoryComboModel;
import org.netbeans.modules.bugtracking.ui.repository.RepositoryComboRenderer;
import org.netbeans.modules.bugtracking.ui.repository.RepositoryComparator;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public final class RepositoryComboSupport
implements ItemListener,
Runnable {
    static final String LOADING_REPOSITORIES = "loading";
    static final String NO_REPOSITORIES = "no repositories";
    static final String SELECT_REPOSITORY = "select";
    private IssueQuickSearch.RepositoryFilter filter;
    private static final Logger LOG = Logger.getLogger(RepositoryComboSupport.class.getName());
    private final JComboBox comboBox;
    private final FileObject refFile;
    private final boolean preselectSingleRepo;
    private RepositoryComboModel comboBoxModel;
    private DisplayabilityListener displayabilityListener;
    private boolean shutdown;
    private boolean repositoriesDisplayed = false;
    private boolean defaultRepoSelected = false;
    private volatile FileObject[] selectedFiles;
    private volatile Repository[] repositories;
    private volatile boolean defaultRepoComputationPending;
    private volatile Repository defaultRepo;
    private boolean hideLocalRepository;
    private final RequestProcessor rp;
    private final ThreadLocal<Progress> progress = new ThreadLocal();
    private volatile ChangeListener progressListener;

    public static RepositoryComboSupport setup(JComponent component, JComboBox comboBox, boolean selectRepoIfSingle) {
        return RepositoryComboSupport.setup(component, comboBox, IssueQuickSearch.RepositoryFilter.ALL, selectRepoIfSingle);
    }

    public static RepositoryComboSupport setup(JComponent component, JComboBox comboBox, Repository defaultRepo) {
        return RepositoryComboSupport.setup(component, comboBox, IssueQuickSearch.RepositoryFilter.ALL, defaultRepo);
    }

    public static RepositoryComboSupport setup(JComponent component, JComboBox comboBox, FileObject referenceFile) {
        return RepositoryComboSupport.setup(component, comboBox, IssueQuickSearch.RepositoryFilter.ALL, referenceFile);
    }

    public static RepositoryComboSupport setup(JComponent component, JComboBox comboBox, IssueQuickSearch.RepositoryFilter mode, boolean selectRepoIfSingle) {
        RepositoryComboSupport repositoryComboSupport = new RepositoryComboSupport(comboBox, null, null, selectRepoIfSingle);
        if (component != null) {
            repositoryComboSupport.setupDisplayabilityTrigger(component);
        }
        repositoryComboSupport.filter = mode;
        return repositoryComboSupport;
    }

    public static RepositoryComboSupport setup(JComponent component, JComboBox comboBox, IssueQuickSearch.RepositoryFilter mode, Repository defaultRepo) {
        if (defaultRepo == null) {
            throw new IllegalArgumentException("default repository must be specified");
        }
        RepositoryComboSupport repositoryComboSupport = new RepositoryComboSupport(comboBox, defaultRepo, null, false);
        if (component != null) {
            repositoryComboSupport.setupDisplayabilityTrigger(component);
        }
        repositoryComboSupport.filter = mode;
        return repositoryComboSupport;
    }

    public static RepositoryComboSupport setup(JComponent component, JComboBox comboBox, IssueQuickSearch.RepositoryFilter filter, FileObject referenceFile) {
        if (referenceFile == null) {
            throw new IllegalArgumentException("reference file must be specified");
        }
        RepositoryComboSupport repositoryComboSupport = new RepositoryComboSupport(comboBox, null, referenceFile, false);
        if (component != null) {
            repositoryComboSupport.setupDisplayabilityTrigger(component);
        }
        repositoryComboSupport.filter = filter;
        return repositoryComboSupport;
    }

    private RepositoryComboSupport(JComboBox comboBox, Repository defaultRepo, FileObject refFile, boolean preselectSingleRepo) {
        if (comboBox == null) {
            throw new IllegalArgumentException("combo-box must be specified");
        }
        this.checkAtMostOneSpecified(defaultRepo, refFile);
        this.comboBox = comboBox;
        this.defaultRepo = defaultRepo;
        this.refFile = refFile;
        this.preselectSingleRepo = preselectSingleRepo;
        this.comboBoxModel = new RepositoryComboModel();
        this.comboBox.setModel(this.comboBoxModel);
        this.comboBox.setRenderer(new RepositoryComboRenderer());
        this.defaultRepoComputationPending = defaultRepo == null;
        this.progress.set(Progress.INITIALIZED);
        this.rp = BugtrackingManager.getInstance().getRequestProcessor();
    }

    private void checkOldComboBoxModel(JComboBox comboBox) {
        ComboBoxModel oldModel = comboBox.getModel();
        if (oldModel != null && oldModel.getSize() != 0) {
            throw new IllegalStateException("The combo-box must be empty.");
        }
    }

    private void setComboBoxData(Object[] data) {
        this.comboBox.setPopupVisible(false);
        this.comboBoxModel.setData(data);
    }

    private void checkAtMostOneSpecified(Object ... items) {
        boolean oneSpecifed = false;
        for (Object item : items) {
            if (item == null) continue;
            if (oneSpecifed) {
                throw new IllegalArgumentException("At most one item may be specified.");
            }
            oneSpecifed = true;
        }
    }

    void start() {
        assert (EventQueue.isDispatchThread());
        LOG.finer("start()");
        if (this.defaultRepo == null && this.refFile == null) {
            FileObject[] currFiles = BugtrackingUtil.getCurrentSelection();
            if (currFiles == null) {
                currFiles = new FileObject[]{};
            }
            this.selectedFiles = currFiles;
        }
        this.checkOldComboBoxModel(this.comboBox);
        this.comboBoxModel = new RepositoryComboModel();
        this.comboBox.setModel(this.comboBoxModel);
        this.setComboBoxData(new Object[]{LOADING_REPOSITORIES});
        this.updateProgress(Progress.STARTED);
        this.rp.post((Runnable)this);
    }

    private void shutdown() {
        assert (EventQueue.isDispatchThread());
        LOG.finer("shutdown()");
        this.shutdownDisplayabilityTrigger();
        this.comboBox.removeItemListener(this);
        this.shutdown = true;
    }

    private void setupDisplayabilityTrigger(Component triggerComponent) {
        assert (EventQueue.isDispatchThread());
        LOG.finer("setupDisplayabilityTrigger(Component)");
        if (triggerComponent.isDisplayable()) {
            throw new IllegalStateException("The trigger component must not be initially displayable.");
        }
        this.displayabilityListener = new DisplayabilityListener(triggerComponent);
        triggerComponent.addHierarchyListener(this.displayabilityListener);
    }

    private void shutdownDisplayabilityTrigger() {
        assert (EventQueue.isDispatchThread());
        LOG.finer("shutdownDisplayabilityTrigger()");
        if (this.displayabilityListener != null) {
            this.displayabilityListener.dispose();
            this.displayabilityListener = null;
        }
    }

    public void setLocalRepositoryHidden(boolean hidden) {
        this.hideLocalRepository = hidden;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2 && e.getItem() == SELECT_REPOSITORY && this.comboBox.getItemAt(0) == SELECT_REPOSITORY) {
            if (this.comboBox.isPopupVisible()) {
                this.comboBox.removeItemListener(this);
                this.comboBox.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                        RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                        RepositoryComboSupport.this.comboBox.addItemListener(RepositoryComboSupport.this);
                    }

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                        RepositoryComboSupport.this.comboBox.addItemListener(RepositoryComboSupport.this);
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                        if (RepositoryComboSupport.this.comboBox.getSelectedItem() != RepositoryComboSupport.SELECT_REPOSITORY) {
                            RepositoryComboSupport.this.comboBoxModel.removeElementAt(0);
                        } else {
                            RepositoryComboSupport.this.comboBox.addItemListener(RepositoryComboSupport.this);
                        }
                    }
                });
            } else {
                this.comboBoxModel.removeElementAt(0);
                this.comboBox.removeItemListener(this);
            }
        }
    }

    @Override
    public void run() {
        if (this.rp.isRequestProcessorThread()) {
            this.loadRepositories();
            if (this.defaultRepoComputationPending) {
                if (this.repositories.length == 0) {
                    this.defaultRepoComputationPending = false;
                } else if (this.repositories.length == 1 && this.preselectSingleRepo) {
                    this.defaultRepo = this.repositories[0];
                    this.defaultRepoComputationPending = false;
                }
            }
            this.updateProgress(Progress.WILL_SCHEDULE_DISPLAY_OF_REPOS);
            EventQueue.invokeLater(this);
            this.updateProgress(Progress.SCHEDULED_DISPLAY_OF_REPOS);
            if (this.defaultRepoComputationPending) {
                try {
                    this.findDefaultRepository();
                }
                finally {
                    this.defaultRepoComputationPending = false;
                }
                if (this.defaultRepo != null) {
                    this.updateProgress(Progress.WILL_SCHEDULE_SELECTION_OF_DEFAULT_REPO);
                    EventQueue.invokeLater(this);
                    this.updateProgress(Progress.SCHEDULED_SELECTION_OF_DEFAULT_REPO);
                }
            }
            this.notifyProgressDone();
        } else {
            this.doGuiJob();
        }
    }

    private void doGuiJob() {
        assert (EventQueue.isDispatchThread());
        if (this.repositoriesDisplayed && this.defaultRepoSelected) {
            LOG.finest("run() called from AWT - nothing to do - all work already done");
            return;
        }
        if (this.shutdown) {
            LOG.finest(" - too late - the component has been already closed");
            return;
        }
        this.shutdownDisplayabilityTrigger();
        if (!this.repositoriesDisplayed) {
            this.displayRepositories();
        } else {
            this.selectDefaultRepository();
        }
    }

    private void displayRepositories() {
        this.updateProgress(Progress.WILL_DISPLAY_REPOS);
        boolean computationPending = this.defaultRepoComputationPending;
        Repository knownDefaultRepo = computationPending ? null : this.defaultRepo;
        LOG.finest("going to display the list of repositories");
        if (knownDefaultRepo != null && LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "  - default repository: {0}", knownDefaultRepo.getDisplayName());
        }
        try {
            this.setRepositories(this.repositories, knownDefaultRepo);
            this.repositoriesDisplayed = true;
            this.defaultRepoSelected = !computationPending;
        }
        catch (Throwable throwable) {
            this.repositoriesDisplayed = true;
            this.defaultRepoSelected = !computationPending;
            this.updateProgress(Progress.DISPLAYED_REPOS);
            throw throwable;
        }
        this.updateProgress(Progress.DISPLAYED_REPOS);
    }

    private void selectDefaultRepository() {
        assert (!this.defaultRepoComputationPending && this.defaultRepo != null);
        LOG.finest("going to select the default repository");
        this.updateProgress(Progress.WILL_SELECT_DEFAULT_REPO);
        try {
            if (this.comboBox.getSelectedItem() instanceof Repository && !this.comboBox.isPopupVisible()) {
            } else {
                this.preselectRepository(this.defaultRepo);
            }
        }
        finally {
            this.defaultRepoSelected = true;
            this.updateProgress(Progress.SELECTED_DEFAULT_REPO);
        }
    }

    private void preselectRepository(final Repository repoToPreselect) {
        assert (EventQueue.isDispatchThread());
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "preselectRepository({0})", repoToPreselect.getDisplayName());
        }
        if (this.comboBox.isPopupVisible()) {
            LOG.finest(" - the popup is visible - deferred");
            this.comboBox.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    LOG.finer("popupMenuWillBecomeInvisible()");
                    RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    LOG.finer("popupMenuCanceled()");
                    RepositoryComboSupport.this.comboBox.removePopupMenuListener(this);
                    LOG.finest(" - processing deferred selection");
                    RepositoryComboSupport.this.preselectItemUnconditionally(repoToPreselect);
                }
            });
        } else {
            this.preselectItemUnconditionally(repoToPreselect);
        }
    }

    private void preselectItemUnconditionally(Object item) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "preselectItemUnconditionally({0})", RepositoryComboSupport.getItemName(item));
        }
        this.comboBox.setSelectedItem(item);
    }

    private static String getItemName(Object item) {
        if (item instanceof Repository) {
            return ((Repository)item).getDisplayName();
        }
        return item.toString();
    }

    private void setRepositories(Repository[] repos, Repository knownDefaultRepository) {
        Object[] comboData;
        int reposCount;
        assert (EventQueue.isDispatchThread());
        int n = reposCount = repos != null ? repos.length : 0;
        if (repos != null) {
            Arrays.sort(repos, new RepositoryComparator());
        }
        int startIndex = 0;
        if (reposCount == 0) {
            comboData = new Object[]{NO_REPOSITORIES};
        } else if (knownDefaultRepository == null) {
            comboData = new Object[reposCount + 1];
            comboData[startIndex++] = SELECT_REPOSITORY;
        } else {
            comboData = new Object[reposCount];
        }
        if (reposCount != 0) {
            System.arraycopy(repos, 0, comboData, startIndex, reposCount);
        }
        this.setComboBoxData(comboData);
        if (knownDefaultRepository != null) {
            this.comboBox.setSelectedItem(knownDefaultRepository);
        } else if (reposCount != 0) {
            assert (this.comboBox.getSelectedItem() == SELECT_REPOSITORY);
            this.comboBox.addItemListener(this);
        }
    }

    private void refreshComboBoxData(Repository[] repos) {
        Object[] objectArray;
        if (repos.length == 0) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = NO_REPOSITORIES;
        } else {
            objectArray = repos;
        }
        this.setComboBoxData(objectArray);
    }

    public void refreshRepositoryModel() {
        LOG.finer("refreshRepositoryModel()");
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                if (RepositoryComboSupport.this.rp.isRequestProcessorThread()) {
                    RepositoryComboSupport.this.loadRepositories();
                    EventQueue.invokeLater(this);
                } else {
                    assert (EventQueue.isDispatchThread());
                    RepositoryComboSupport.this.refreshComboBoxData(RepositoryComboSupport.this.repositories);
                }
            }
        });
    }

    private void loadRepositories() {
        assert (this.rp.isRequestProcessorThread());
        LOG.finer("loadRepositories()");
        this.updateProgress(Progress.WILL_LOAD_REPOS);
        long startTimeMillis = System.currentTimeMillis();
        if (this.refFile != null) {
            this.pingNBRepository(this.refFile);
        }
        Collection<RepositoryImpl> repoImpls = RepositoryRegistry.getInstance().getKnownRepositories(true);
        ArrayList<Repository> repos = new ArrayList<Repository>(repoImpls.size());
        for (RepositoryImpl impl : repoImpls) {
            boolean hidden = this.hideLocalRepository && BugtrackingManager.isLocalConnectorID(impl.getConnectorId());
            if (hidden || this.filter != IssueQuickSearch.RepositoryFilter.ALL && (this.filter != IssueQuickSearch.RepositoryFilter.ATTACH_FILE || !impl.canAttachFiles())) continue;
            repos.add(impl.getRepository());
        }
        this.repositories = repos.toArray(new Repository[repos.size()]);
        long endTimeMillis = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "BugtrackingUtil.getKnownRepositories() took {0} ms.", endTimeMillis - startTimeMillis);
        }
        this.updateProgress(Progress.LOADED_REPOS);
    }

    private void findDefaultRepository() {
        RepositoryImpl result;
        assert (this.rp.isRequestProcessorThread());
        LOG.finer("findDefaultRepository()");
        this.updateProgress(Progress.WILL_DETERMINE_DEFAULT_REPO);
        long startTimeMillis = System.currentTimeMillis();
        assert (this.refFile == null ^ this.selectedFiles == null);
        if (this.refFile != null) {
            result = BugtrackingOwnerSupport.getInstance().getRepository(this.refFile, false);
        } else {
            assert (this.selectedFiles != null);
            result = BugtrackingOwnerSupport.getInstance().getRepository(this.selectedFiles);
        }
        long endTimeMillis = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "BugtrackingOwnerSupport.getRepository(...) took {0} ms.", endTimeMillis - startTimeMillis);
        }
        if (result != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, " - default repository: {0}", result.getDisplayName());
            }
            this.defaultRepo = result.getRepository();
        } else {
            LOG.finest(" - default repository: <null>");
        }
        this.updateProgress(Progress.DETERMINED_DEFAULT_REPO);
    }

    private void pingNBRepository(FileObject referenceFile) {
        String url = VersioningQuery.getRemoteLocation((URI)referenceFile.toURI());
        if (url != null && NBBugzillaUtils.isNbRepository((String)url)) {
            BugtrackingUtil.findNBRepository();
        }
    }

    private void notifyProgressDone() {
        if (this.progressListener != null) {
            assert (!EventQueue.isDispatchThread());
            Runnable doneNotifier = new Runnable(){

                @Override
                public void run() {
                    RepositoryComboSupport.this.updateProgress(Progress.THREAD_PROGRESS_DONE);
                }
            };
            doneNotifier.run();
            EventQueue.invokeLater(doneNotifier);
        }
    }

    private void updateProgress(Progress progress) {
        this.progress.set(progress);
        this.fireProgressChange();
    }

    private void fireProgressChange() {
        if (this.progressListener != null) {
            this.progressListener.stateChanged(new ChangeEvent(this));
        }
    }

    void setProgressListener(ChangeListener l) {
        this.progressListener = l;
    }

    Progress getProgress() {
        return this.progress.get();
    }

    static enum Progress {
        INITIALIZED,
        STARTED,
        WILL_LOAD_REPOS,
        LOADED_REPOS,
        WILL_SCHEDULE_DISPLAY_OF_REPOS,
        SCHEDULED_DISPLAY_OF_REPOS,
        WILL_DISPLAY_REPOS,
        DISPLAYED_REPOS,
        WILL_DETERMINE_DEFAULT_REPO,
        DETERMINED_DEFAULT_REPO,
        WILL_SCHEDULE_SELECTION_OF_DEFAULT_REPO,
        SCHEDULED_SELECTION_OF_DEFAULT_REPO,
        WILL_SELECT_DEFAULT_REPO,
        SELECTED_DEFAULT_REPO,
        WILL_DISPLAY_REPOS_AND_SELECT_DEFAULT,
        DISPLAYED_REPOS_AND_SELECTED_DEFAULT,
        THREAD_PROGRESS_DONE;

    }

    private final class DisplayabilityListener
    implements HierarchyListener {
        private final Component triggerComponent;

        private DisplayabilityListener(Component triggerComponent) {
            this.triggerComponent = triggerComponent;
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 2L) == 0L) {
                return;
            }
            assert (e.getChanged() == this.triggerComponent);
            if (this.triggerComponent.isDisplayable()) {
                LOG.finer("trigger component became displayable");
                RepositoryComboSupport.this.start();
            } else {
                LOG.finer("trigger component became non-displayable");
                RepositoryComboSupport.this.shutdown();
            }
        }

        private void dispose() {
            this.triggerComponent.removeHierarchyListener(this);
        }
    }
}

