/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;

public class CustomToolbar
extends Box {
    private static final Dimension space = new Dimension(4, 0);
    private JToolBar toolbar;

    public CustomToolbar() {
        super(0);
        this.initPanel();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(1, 2, 1, 2));
        this.toolbar = new NoBorderToolBar(0);
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setBorderPainted(false);
        this.toolbar.setBorder(BorderFactory.createEmptyBorder());
        this.toolbar.setOpaque(false);
        this.toolbar.setFocusable(false);
        this.add(this.toolbar);
    }

    public void addButtons(Collection<AbstractButton> buttons) {
        for (AbstractButton button : buttons) {
            this.addButton(button);
        }
    }

    public void addButton(AbstractButton button) {
        Icon icon = button.getIcon();
        Dimension size = new Dimension(icon.getIconWidth() + 6, icon.getIconHeight() + 10);
        button.setMinimumSize(size);
        button.setPreferredSize(size);
        button.setMaximumSize(size);
        button.setMargin(new Insets(5, 4, 5, 4));
        this.toolbar.add(button);
    }

    public void addSpaceSeparator() {
        this.toolbar.addSeparator(space);
    }

    public void addLineSeparator() {
        this.toolbar.addSeparator(space);
        this.toolbar.add(new JSeparator(1));
        this.toolbar.addSeparator(space);
    }

    public static class NoBorderToolBar
    extends JToolBar {
        public NoBorderToolBar() {
        }

        public NoBorderToolBar(int layout) {
            super(layout);
        }

        @Override
        protected void paintComponent(Graphics g) {
        }
    }
}

