/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nashorn.execution;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.api.common.ui.PlatformFilter;
import org.netbeans.modules.nashorn.execution.options.Settings;
import org.openide.modules.SpecificationVersion;
import org.openide.util.WeakListeners;

public class NashornPlatform {
    private static final String NASHORN_PLATFORM_VERSION = "1.8";
    private static final SpecificationVersion SMALLEST_VERSION = new SpecificationVersion("1.8");
    private static NashornPlatform INSTANCE;
    private volatile JavaPlatform nashornPlatform;
    private final PlatformManagerListener platformListener;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();

    private NashornPlatform() {
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        this.platformListener = new PlatformManagerListener();
        jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.platformListener, (Object)jpm));
        Settings.getPreferences().addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.platformListener, (Object)Settings.getPreferences()));
        this.nashornPlatform = NashornPlatform.getNashornPlatform(jpm);
    }

    public static synchronized NashornPlatform getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new NashornPlatform();
        }
        return INSTANCE;
    }

    public JavaPlatform getPlatform() {
        return this.nashornPlatform;
    }

    private static SpecificationVersion getPlatformVersion(JavaPlatform p) {
        if (p == null) {
            return new SpecificationVersion(NASHORN_PLATFORM_VERSION);
        }
        return p.getSpecification().getVersion();
    }

    public static boolean isNashornSupported(JavaPlatform p) {
        SpecificationVersion version = NashornPlatform.getPlatformVersion(p);
        if (version.equals((Object)SMALLEST_VERSION)) {
            return true;
        }
        return version.compareTo(new SpecificationVersion("15")) < 0;
    }

    public static boolean isGraalJsSupported(JavaPlatform p) {
        SpecificationVersion version = NashornPlatform.getPlatformVersion(p);
        return version.compareTo(SMALLEST_VERSION) >= 0;
    }

    public static boolean isGraalJSPreferred(JavaPlatform p) {
        return p != null && p.findTool("node") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener chl) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(chl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener chl) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(chl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        ArrayList<ChangeListener> listeners_;
        ChangeEvent che = new ChangeEvent(this);
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            listeners_ = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener chl : listeners_) {
            chl.stateChanged(che);
        }
    }

    private static JavaPlatform getNashornPlatform(JavaPlatformManager platformManager) {
        String nashornPlatformDisplayName = Settings.getPreferences().get("nashornPlatformDisplayName", null);
        SpecificationVersion smallestVersion = new SpecificationVersion(NASHORN_PLATFORM_VERSION);
        JavaPlatform defaultPlatform = platformManager.getDefaultPlatform();
        SpecificationVersion version = defaultPlatform.getSpecification().getVersion();
        if (version.compareTo(smallestVersion) >= 0 && (nashornPlatformDisplayName == null || nashornPlatformDisplayName.equals(defaultPlatform.getDisplayName()))) {
            return defaultPlatform;
        }
        for (JavaPlatform jp : platformManager.getInstalledPlatforms()) {
            if (jp.getSpecification().getVersion().compareTo(smallestVersion) < 0 || nashornPlatformDisplayName != null && !nashornPlatformDisplayName.equals(jp.getDisplayName()) || jp.getInstallFolders().isEmpty()) continue;
            return jp;
        }
        if (nashornPlatformDisplayName != null) {
            if (version.compareTo(smallestVersion) >= 0) {
                return defaultPlatform;
            }
            for (JavaPlatform jp : platformManager.getInstalledPlatforms()) {
                if (jp.getSpecification().getVersion().compareTo(smallestVersion) < 0 || jp.getInstallFolders().isEmpty()) continue;
                return jp;
            }
        }
        return null;
    }

    public void setPlatform(JavaPlatform selectedPlatform) {
        if (selectedPlatform == null) {
            Settings.getPreferences().remove("nashornPlatformDisplayName");
        } else {
            if (!NashornPlatform.isJsJvmPlatform(selectedPlatform)) {
                throw new IllegalArgumentException(selectedPlatform.getDisplayName());
            }
            Settings.getPreferences().put("nashornPlatformDisplayName", selectedPlatform.getDisplayName());
        }
        this.nashornPlatform = selectedPlatform;
    }

    public static boolean isJsJvmPlatform(JavaPlatform platform) {
        return platform.getSpecification().getVersion().compareTo(SMALLEST_VERSION) >= 0;
    }

    public static PlatformFilter getFilter() {
        return new PlatformFilter(){

            public boolean accept(JavaPlatform platform) {
                return NashornPlatform.isJsJvmPlatform(platform);
            }
        };
    }

    private class PlatformManagerListener
    implements PropertyChangeListener,
    PreferenceChangeListener {
        private PlatformManagerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NashornPlatform.this.nashornPlatform = NashornPlatform.getNashornPlatform(JavaPlatformManager.getDefault());
            NashornPlatform.this.fireChangeEvent();
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if ("nashornPlatformDisplayName".equals(evt.getKey())) {
                NashornPlatform.this.nashornPlatform = NashornPlatform.getNashornPlatform(JavaPlatformManager.getDefault());
                NashornPlatform.this.fireChangeEvent();
            }
        }
    }
}

