/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassFishState;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.KillTask;
import org.netbeans.modules.glassfish.common.NoopTask;
import org.netbeans.modules.glassfish.common.RestartTask;
import org.netbeans.modules.glassfish.common.StartTask;
import org.netbeans.modules.glassfish.common.StopProfilingTask;
import org.netbeans.modules.glassfish.common.StopTask;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.common.utils.Util;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule3;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.glassfish.spi.VMIntrospector;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.TaskEvent;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.TaskStateListener;
import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.CommandDeploy;
import org.netbeans.modules.glassfish.tooling.admin.CommandDisable;
import org.netbeans.modules.glassfish.tooling.admin.CommandEnable;
import org.netbeans.modules.glassfish.tooling.admin.CommandGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.CommandListComponents;
import org.netbeans.modules.glassfish.tooling.admin.CommandRedeploy;
import org.netbeans.modules.glassfish.tooling.admin.CommandRestartDAS;
import org.netbeans.modules.glassfish.tooling.admin.CommandSetProperty;
import org.netbeans.modules.glassfish.tooling.admin.CommandUndeploy;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.admin.ResultString;
import org.netbeans.modules.glassfish.tooling.admin.ServerAdmin;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServerStatus;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class CommonServerSupport
implements GlassfishModule3,
RefreshModulesCookie {
    private static final Logger LOGGER = GlassFishLogger.get(CommonServerSupport.class);
    private static final String LOCALHOST = "localhost";
    private static final String FAILED_HTTP_HOST = "localhostFAIL";
    private final GlassfishInstance instance;
    private volatile GlassfishModule.ServerState serverState = GlassfishModule.ServerState.UNKNOWN;
    private final Object stateMonitor = new Object();
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject instanceFO;
    private volatile boolean startedByIde = false;
    private transient boolean isRemote = false;
    private boolean stopDisabled = false;
    private Process localStartProcess;
    private volatile FutureTask<TaskState> startTask;
    private static final RequestProcessor RP = new RequestProcessor("CommonServerSupport - start/stop/refresh", 5);
    private static final int WAIT_TASK_TO_DIE_SLEEP = 300;
    private static final int WAIT_TASK_TO_DIE_MAX = 3000;
    private final AtomicBoolean refreshRunning = new AtomicBoolean(false);
    private long latestWarningDisplayTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void displayPopUpMessage(CommonServerSupport css, String message) {
        CommonServerSupport commonServerSupport = css;
        synchronized (commonServerSupport) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            css.setLatestWarningDisplayTime(System.currentTimeMillis());
            LOGGER.log(Level.INFO, message);
        }
    }

    CommonServerSupport(GlassfishInstance instance) {
        this.instance = instance;
        this.isRemote = instance.isRemote();
        this.instanceFO = this.getInstanceFileObject();
        this.startTask = null;
    }

    @Override
    public GlassfishInstance getInstance() {
        return this.instance;
    }

    private FileObject getInstanceFileObject() {
        String instanceFN;
        FileObject dir = FileUtil.getConfigFile((String)this.instance.getInstanceProvider().getInstancesDirFirstName());
        if (dir != null && (instanceFN = this.instance.getProperty("InstanceFOPath")) != null) {
            return dir.getFileObject(instanceFN);
        }
        return null;
    }

    @Override
    public String getPassword() {
        return this.instance.getPassword();
    }

    @Deprecated
    public String getInstallRoot() {
        return this.instance.getInstallRoot();
    }

    @Deprecated
    public String getGlassfishRoot() {
        return this.instance.getGlassfishRoot();
    }

    @Deprecated
    public String getDisplayName() {
        return this.instance.getDisplayName();
    }

    @Deprecated
    public String getDeployerUri() {
        return this.instance.getDeployerUri();
    }

    @Deprecated
    public String getUserName() {
        return this.instance.getUserName();
    }

    @Deprecated
    public String getAdminPort() {
        return this.instance.getHttpAdminPort();
    }

    @Deprecated
    public String getHttpPort() {
        return this.instance.getHttpPort();
    }

    @Deprecated
    public int getHttpPortNumber() {
        return this.instance.getPort();
    }

    @Deprecated
    public int getAdminPortNumber() {
        return this.instance.getAdminPort();
    }

    @Deprecated
    public String getHostName() {
        return this.instance.getProperty("host");
    }

    @Deprecated
    public String getDomainsRoot() {
        return this.instance.getDomainsRoot();
    }

    @Deprecated
    public String getDomainName() {
        return this.instance.getDomainName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerState(GlassfishModule.ServerState newState) {
        boolean fireChange = false;
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.serverState != newState) {
                this.serverState = newState;
                fireChange = true;
            }
        }
        if (fireChange) {
            this.changeSupport.fireChange();
        }
    }

    boolean isStartedByIde() {
        return this.startedByIde;
    }

    @Override
    public Map<String, String> getInstanceProperties() {
        this.getDomainsRoot();
        return Collections.unmodifiableMap(this.instance.getProperties());
    }

    @Override
    public GlassfishInstanceProvider getInstanceProvider() {
        return this.instance.getInstanceProvider();
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    public Future<TaskState> startServer(TaskStateListener stateListener, GlassfishModule.ServerState endState) {
        String[] stringArray;
        LOGGER.log(Level.FINEST, "CSS.startServer called on thread \"{0}\"", Thread.currentThread().getName());
        StartOperationStateListener startServerListener = new StartOperationStateListener(endState);
        VMIntrospector vmi = (VMIntrospector)Lookups.forPath((String)"Servers/GlassFish").lookup(VMIntrospector.class);
        List<Recognizer> list = this.getRecognizers();
        if (endState == GlassfishModule.ServerState.STOPPED_JVM_PROFILER) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = null;
        }
        FutureTask<TaskState> task = new FutureTask<TaskState>(new StartTask(this, list, vmi, stringArray, startServerListener, stateListener));
        this.startTask = task;
        RP.post(task);
        return task;
    }

    private List<Recognizer> getRecognizers() {
        List<Recognizer> recognizers;
        Collection cookies = this.instance.localLookup().lookupAll(RecognizerCookie.class);
        if (!cookies.isEmpty()) {
            recognizers = new LinkedList();
            for (RecognizerCookie cookie : cookies) {
                recognizers.addAll(cookie.getRecognizers());
            }
            recognizers = Collections.unmodifiableList(recognizers);
        } else {
            recognizers = Collections.emptyList();
        }
        return recognizers;
    }

    @Override
    public Future<TaskState> stopServer(TaskStateListener stateListener) {
        LOGGER.log(Level.FINEST, "CSS.stopServer called on thread \"{0}\"", Thread.currentThread().getName());
        StopOperationStateListener stopServerListener = new StopOperationStateListener();
        FutureTask<TaskState> task = !this.isRemote() || !Util.isDefaultOrServerTarget(this.instance.getProperties()) ? (this.getServerState() == GlassfishModule.ServerState.STOPPED_JVM_PROFILER ? new FutureTask<TaskState>(new StopProfilingTask(this, stateListener)) : new FutureTask<TaskState>(new StopTask(this, stopServerListener, stateListener))) : new FutureTask<TaskState>(new NoopTask(this, (TaskStateListener)stopServerListener, stateListener));
        if (this.stopDisabled) {
            stopServerListener.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, new String[]{""});
            if (null != stateListener) {
                stateListener.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, new String[]{""});
            }
            return task;
        }
        RP.post(task);
        return task;
    }

    @Override
    public Future<TaskState> killServer(TaskStateListener stateListener) {
        FutureTask<TaskState> task;
        boolean isStateListener;
        KillOperationStateListener killServerListener = new KillOperationStateListener();
        boolean bl = isStateListener = stateListener != null;
        if (!this.isRemote() && this.instance.getProcess() != null) {
            FutureTask<TaskState> stTask = this.startTask;
            if (stTask != null && !stTask.isDone()) {
                stTask.cancel(true);
                long startTime = System.currentTimeMillis();
                while (!stTask.isDone() && System.currentTimeMillis() - startTime < 3000L) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.INFO, "Caught InterruptedException while waiting for {0} start task to die.", this.instance.getName());
                    }
                }
                if (!stTask.isDone()) {
                    LOGGER.log(Level.INFO, "Start task for {0} did not finish within {1} ms.", new String[]{this.instance.getName(), Integer.toString(3000)});
                }
            }
            TaskStateListener[] listeners = new TaskStateListener[isStateListener ? 2 : 1];
            listeners[0] = killServerListener;
            if (isStateListener) {
                listeners[1] = stateListener;
            }
            task = new FutureTask<TaskState>(new KillTask(this.instance, listeners));
        } else {
            task = new FutureTask<TaskState>(new NoopTask(this, null, stateListener));
        }
        RP.post(task);
        return task;
    }

    @Override
    public Future<TaskState> restartServer(TaskStateListener stateListener) {
        LOGGER.log(Level.FINEST, "CSS.restartServer called on thread \"{0}\"", Thread.currentThread().getName());
        FutureTask<TaskState> task = new FutureTask<TaskState>(new RestartTask(this, stateListener));
        RP.post(task);
        return task;
    }

    public Future<ResultString> restartServer(int debugPort, boolean debug, TaskStateListener[] listeners) {
        if (-1 == debugPort) {
            CommandRestartDAS command = new CommandRestartDAS(false);
            return ServerAdmin.exec((GlassFishServer)this.instance, (Command)command, null, (TaskStateListener[])listeners);
        }
        Object state = null;
        try {
            Map values;
            ResultMap result = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)"configs.config.server-config.java-config.debug-options");
            if (result.getState() == TaskState.COMPLETED && (values = result.getValue()) != null && !values.isEmpty()) {
                String oldValue = (String)values.get("configs.config.server-config.java-config.debug-options");
                CommandSetProperty setCmd = this.getCommandFactory().getSetPropertyCommand("configs.config.server-config.java-config.debug-options", oldValue.replace("transport=dt_shmem", "transport=dt_socket").replace("address=[^,]+", "address=" + debugPort));
                try {
                    CommandSetProperty.setProperty((GlassFishServer)this.instance, (CommandSetProperty)setCmd);
                    debug = true;
                }
                catch (GlassFishIdeException gfie) {
                    debug = false;
                    LOGGER.log(Level.INFO, "" + debugPort, gfie);
                }
            }
        }
        catch (GlassFishIdeException gfie) {
            LOGGER.log(Level.INFO, "Could not retrieve property from server.", gfie);
        }
        CommandRestartDAS command = new CommandRestartDAS(debug);
        return ServerAdmin.exec((GlassFishServer)this.instance, (Command)command, null, (TaskStateListener[])listeners);
    }

    @Override
    public Future<ResultString> deploy(TaskStateListener stateListener, File application, String name) {
        return this.deploy(stateListener, application, name, null);
    }

    @Override
    public Future<ResultString> deploy(TaskStateListener stateListener, File application, String name, String contextRoot) {
        return this.deploy(stateListener, application, name, contextRoot, null);
    }

    @Override
    public Future<ResultString> deploy(TaskStateListener stateListener, File application, String name, String contextRoot, Map<String, String> properties) {
        return this.deploy(stateListener, application, name, contextRoot, null, new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<ResultString> deploy(TaskStateListener stateListener, File application, String name, String contextRoot, Map<String, String> properties, File[] libraries) {
        try {
            Future future = ServerAdmin.exec((GlassFishServer)this.instance, (Command)new CommandDeploy(name, Util.computeTarget(this.instance.getProperties()), application, contextRoot, properties, libraries), null, (TaskStateListener[])new TaskStateListener[]{stateListener});
            return future;
        }
        finally {
            this.refreshChildren();
        }
    }

    @Override
    public Future<ResultString> redeploy(TaskStateListener stateListener, String name, boolean resourcesChanged) {
        return this.redeploy(stateListener, name, null, resourcesChanged);
    }

    @Override
    public Future<ResultString> redeploy(TaskStateListener stateListener, String name, String contextRoot, boolean resourcesChanged) {
        return this.redeploy(stateListener, name, contextRoot, new File[0], resourcesChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<ResultString> redeploy(TaskStateListener stateListener, String name, String contextRoot, File[] libraries, boolean resourcesChanged) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String url = this.instance.getProperty("url");
        String sessionPreservationFlag = this.instance.getProperty("preserveSessionsOn");
        if (sessionPreservationFlag == null) {
            sessionPreservationFlag = System.getProperty("glassfish.session.preservation.enabled", "false");
        }
        if (Boolean.parseBoolean(sessionPreservationFlag)) {
            properties.put("keepSessions", "true");
        }
        if (resourcesChanged) {
            properties.put("preserveAppScopedResources", "true");
        }
        try {
            Future future = ServerAdmin.exec((GlassFishServer)this.instance, (Command)new CommandRedeploy(name, Util.computeTarget(this.instance.getProperties()), contextRoot, properties, libraries, url != null && url.contains("ee6wc")), (TaskStateListener[])new TaskStateListener[]{stateListener});
            return future;
        }
        finally {
            this.refreshChildren();
        }
    }

    @Override
    public Future<ResultString> undeploy(TaskStateListener stateListener, String name) {
        return ServerAdmin.exec((GlassFishServer)this.instance, (Command)new CommandUndeploy(name, Util.computeTarget(this.instance.getProperties())), null, (TaskStateListener[])new TaskStateListener[]{stateListener});
    }

    @Override
    public Future<ResultString> enable(TaskStateListener stateListener, String name) {
        return ServerAdmin.exec((GlassFishServer)this.instance, (Command)new CommandEnable(name, Util.computeTarget(this.instance.getProperties())), null, (TaskStateListener[])new TaskStateListener[]{stateListener});
    }

    @Override
    public Future<ResultString> disable(TaskStateListener stateListener, String name) {
        return ServerAdmin.exec((GlassFishServer)this.instance, (Command)new CommandDisable(name, Util.computeTarget(this.instance.getProperties())), null, (TaskStateListener[])new TaskStateListener[]{stateListener});
    }

    @Override
    public AppDesc[] getModuleList(String container) {
        int total = 0;
        Map<String, List<AppDesc>> appMap = this.getApplications(container);
        Collection<List<AppDesc>> appLists = appMap.values();
        for (List<AppDesc> appList : appLists) {
            total += appList.size();
        }
        AppDesc[] result = new AppDesc[total];
        int index = 0;
        for (List<AppDesc> appList : appLists) {
            for (AppDesc app : appList) {
                result[index++] = app;
            }
        }
        return result;
    }

    @Override
    public Map<String, ResourceDesc> getResourcesMap(String type) {
        HashMap<String, ResourceDesc> resourcesMap = new HashMap<String, ResourceDesc>();
        List<ResourceDesc> resourcesList = ResourceDesc.getResources(this.instance, type);
        for (ResourceDesc resource : resourcesList) {
            resourcesMap.put(resource.getName(), resource);
        }
        return resourcesMap;
    }

    @Override
    public GlassfishModule.ServerState getServerState() {
        RequestProcessor.Task task;
        if (this.serverState == GlassfishModule.ServerState.UNKNOWN && (task = this.refresh()) != null) {
            task.waitFinished();
        }
        return this.serverState;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setEnvironmentProperty(String name, String value, boolean overwrite) {
        String result;
        Map<String, String> map = this.instance.getProperties();
        synchronized (map) {
            result = this.instance.getProperty(name);
            if (result == null || overwrite) {
                this.instance.putProperty(name, value);
                this.setInstanceAttr(name, value);
                result = value;
            }
        }
        return result;
    }

    void setProperty(String key, String value) {
        this.instance.putProperty(key, value);
    }

    void getProperty(String key) {
        this.instance.getProperty(key);
    }

    boolean setInstanceAttr(String name, String value) {
        boolean retVal = false;
        if (this.instanceFO == null || !this.instanceFO.isValid()) {
            this.instanceFO = this.getInstanceFileObject();
        }
        if (this.instanceFO != null && this.instanceFO.canWrite()) {
            try {
                Object currentValue = this.instanceFO.getAttribute(name);
                if (null == currentValue || !currentValue.equals(value)) {
                    this.instanceFO.setAttribute(name, (Object)value);
                }
                retVal = true;
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Unable to save attribute " + name + " in " + this.instanceFO.getPath() + " for " + this.getDeployerUri(), ex);
            }
        } else if (null == this.instanceFO) {
            LOGGER.log(Level.WARNING, "Unable to save attribute {0} for {1} in {3}. Instance file is writable? {2}", new Object[]{name, this.getDeployerUri(), false, "null"});
        } else {
            LOGGER.log(Level.WARNING, "Unable to save attribute {0} for {1} in {3}. Instance file is writable? {2}", new Object[]{name, this.getDeployerUri(), this.instanceFO.canWrite(), this.instanceFO.getPath()});
        }
        return retVal;
    }

    void setFileObject(FileObject fo) {
        this.instanceFO = fo;
    }

    public static boolean isRunning(String host, int port, String name, int timeout) {
        if (null == host) {
            return false;
        }
        try {
            InetSocketAddress isa = new InetSocketAddress(host, port);
            Socket socket = new Socket();
            Logger.getLogger("glassfish-socket-connect-diagnostic").log(Level.FINE, "Using socket.connect", new Exception());
            socket.connect(isa, timeout);
            socket.setSoTimeout(timeout);
            try {
                socket.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "Socket closing failed: {0}", ioe.getMessage());
            }
            return true;
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (SocketTimeoutException ste) {
            return false;
        }
        catch (IOException ioe) {
            String message = NbBundle.getMessage(CommonServerSupport.class, (String)(name == null || "".equals(name.trim()) ? "MSG_FLAKEY_NETWORK" : "MSG_FLAKEY_NETWORK2"), (Object)host, (Object)Integer.toString(port), (Object)ioe.getLocalizedMessage());
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            LOGGER.log(Level.INFO, "Evidence of network flakiness: {0}", ioe.getMessage());
            return false;
        }
    }

    public static boolean isRunning(String host, int port, String name) {
        return CommonServerSupport.isRunning(host, port, name, 2000);
    }

    @Override
    public final RequestProcessor.Task refresh() {
        return this.refresh(null, null);
    }

    @Override
    public RequestProcessor.Task refresh(String expected, String unexpected) {
        if (this.refreshRunning.compareAndSet(false, true)) {
            return RP.post(new Runnable(){

                @Override
                public void run() {
                    GlassFishServerStatus status = GlassFishStatus.get((GlassFishServer)CommonServerSupport.this.instance);
                    if (status == null) {
                        GlassFishState.monitor(CommonServerSupport.this.instance);
                        status = GlassFishStatus.get((GlassFishServer)CommonServerSupport.this.instance);
                    }
                    GlassfishModule.ServerState currentState = CommonServerSupport.this.serverState;
                    switch (currentState) {
                        case UNKNOWN: {
                            switch (status.getStatus()) {
                                case ONLINE: {
                                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                                    break;
                                }
                                case STARTUP: {
                                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
                                    break;
                                }
                                case SHUTDOWN: {
                                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
                                    break;
                                }
                                case OFFLINE: {
                                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                                }
                            }
                            break;
                        }
                        case STOPPED: {
                            if (status.getStatus() != GlassFishStatus.ONLINE) break;
                            CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                            break;
                        }
                        case RUNNING: {
                            switch (status.getStatus()) {
                                case STARTUP: {
                                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
                                    break;
                                }
                                case SHUTDOWN: {
                                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
                                    break;
                                }
                                case OFFLINE: {
                                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                                }
                            }
                            break;
                        }
                        case STOPPED_JVM_PROFILER: {
                            if (status.getStatus() != GlassFishStatus.ONLINE) break;
                            CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                        }
                    }
                    CommonServerSupport.this.refreshRunning.set(false);
                }
            });
        }
        return null;
    }

    void disableStop() {
        this.stopDisabled = true;
    }

    void setLocalStartProcess(Process process) {
        this.localStartProcess = process;
    }

    Process getLocalStartProcess() {
        return this.localStartProcess;
    }

    void stopLocalStartProcess() {
        this.localStartProcess.destroy();
        this.localStartProcess = null;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.instance.getInstanceProvider().getCommandFactory();
    }

    @Override
    public String getResourcesXmlName() {
        return Utils.useGlassfishPrefix(this.getDeployerUri()) ? "glassfish-resources" : "sun-resources";
    }

    @Override
    public boolean supportsRestartInDebug() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc");
    }

    @Override
    public boolean isRestfulLogAccessSupported() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc");
    }

    @Override
    public boolean isWritable() {
        return null == this.instanceFO ? false : this.instanceFO.canWrite();
    }

    private long getLatestWarningDisplayTime() {
        return this.latestWarningDisplayTime;
    }

    private void setLatestWarningDisplayTime(long currentTime) {
        this.latestWarningDisplayTime = currentTime;
    }

    void updateHttpPort() {
        Object gpc;
        String target = Util.computeTarget(this.instance.getProperties());
        if (Util.isDefaultOrServerTarget(this.instance.getProperties())) {
            gpc = "*.server-config.*.http-listener-1.port";
            this.setEnvironmentProperty("httphostname", this.instance.getProperty("host"), true);
        } else {
            String server = this.getServerFromTarget(target);
            String adminHost = this.instance.getProperty("host");
            this.setEnvironmentProperty("httphostname", this.getHttpHostFromServer(server, adminHost), true);
            gpc = "servers.server." + server + ".system-property.HTTP_LISTENER_PORT.value";
        }
        try {
            ResultMap result = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)gpc, (long)10000L);
            boolean didSet = false;
            if (result.getState() == TaskState.COMPLETED) {
                Map values = result.getValue();
                for (Map.Entry entry : values.entrySet()) {
                    String val = (String)entry.getValue();
                    try {
                        if (null == val || val.trim().length() <= 0) continue;
                        Integer.parseInt(val);
                        this.setEnvironmentProperty("httpportnumber", val, true);
                        didSet = true;
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.FINEST, "Property value {0} was not a number", val);
                    }
                }
            }
            if (!didSet && !Util.isDefaultOrServerTarget(this.instance.getProperties())) {
                this.setEnvironmentProperty("httpportnumber", "28080", true);
            }
        }
        catch (GlassFishIdeException gfie) {
            LOGGER.log(Level.INFO, "Could not get http port value.", gfie);
        }
    }

    public Map<String, List<AppDesc>> getApplications(String container) {
        Map<String, List<AppDesc>> result = Collections.emptyMap();
        Map apps = Collections.emptyMap();
        try {
            ResultMap resultMap = CommandListComponents.listComponents((GlassFishServer)this.instance, (String)Util.computeTarget(this.instance.getProperties()));
            if (resultMap.getState() == TaskState.COMPLETED) {
                apps = resultMap.getValue();
            }
        }
        catch (GlassFishIdeException gfie) {
            LOGGER.log(Level.INFO, "Could not retrieve components server.", gfie);
        }
        if (null == apps || apps.isEmpty()) {
            return result;
        }
        try {
            ResultMap appRefResult;
            ResultMap appPropsResult = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)"applications.application.*");
            if (appPropsResult.getState() == TaskState.COMPLETED && (appRefResult = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)"servers.server.*.application-ref.*")).getState() == TaskState.COMPLETED) {
                result = this.processApplications(apps, appPropsResult.getValue(), appRefResult.getValue());
            }
        }
        catch (GlassFishIdeException gfie) {
            LOGGER.log(Level.INFO, "Could not retrieve property from server.", gfie);
        }
        return result;
    }

    private Map<String, List<AppDesc>> processApplications(Map<String, List<String>> appsList, Map<String, String> properties, Map<String, String> refProperties) {
        HashMap<String, List<AppDesc>> result = new HashMap<String, List<AppDesc>>();
        for (String engine : appsList.keySet()) {
            List<String> apps = appsList.get(engine);
            for (int i = 0; i < apps.size(); ++i) {
                String path;
                String name = apps.get(i).trim();
                String appname = "applications.application." + name;
                String contextKey = appname + ".context-root";
                String pathKey = appname + ".location";
                String contextRoot = properties.get(contextKey);
                if (contextRoot == null) {
                    contextRoot = name;
                }
                if (contextRoot.startsWith("/")) {
                    contextRoot = contextRoot.substring(1);
                }
                if ((path = properties.get(pathKey)) == null) {
                    path = "unknown";
                }
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                    path = new File(path).getAbsolutePath();
                }
                Object enabledKey = "servers.server.server.application-ref." + name + ".enabled";
                for (String possibleKey : refProperties.keySet()) {
                    if (!possibleKey.endsWith(".application-ref." + name + ".enabled")) continue;
                    enabledKey = possibleKey;
                }
                String enabledValue = refProperties.get(enabledKey);
                if (null == enabledValue) continue;
                boolean enabled = Boolean.parseBoolean(enabledValue);
                ArrayList<AppDesc> appList = (ArrayList<AppDesc>)result.get(engine);
                if (appList == null) {
                    appList = new ArrayList<AppDesc>();
                    result.put(engine, appList);
                }
                appList.add(new AppDesc(name, path, contextRoot, enabled));
            }
        }
        return result;
    }

    private String getServerFromTarget(String target) {
        String retVal;
        block3: {
            retVal = target;
            String gpc = "clusters.cluster." + target + ".server-ref.*.ref";
            try {
                ResultMap result = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)gpc, (long)10000L);
                if (result.getState() != TaskState.COMPLETED) break block3;
                Map values = result.getValue();
                for (Map.Entry entry : values.entrySet()) {
                    String val = (String)entry.getValue();
                    if (null == val || val.trim().length() <= 0) continue;
                    retVal = val;
                    break;
                }
            }
            catch (GlassFishIdeException gfie) {
                LOGGER.log(Level.INFO, "Could not get server value from target.", gfie);
            }
        }
        return retVal;
    }

    private String getHttpHostFromServer(String server, String nameOfLocalhost) {
        String retVal;
        block4: {
            retVal = FAILED_HTTP_HOST;
            String refVal = null;
            String gpc = "servers.server." + server + ".node-ref";
            try {
                String val;
                ResultMap result = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)gpc, (long)10000L);
                if (result.getState() != TaskState.COMPLETED) break block4;
                for (Map.Entry entry : result.getValue().entrySet()) {
                    val = (String)entry.getValue();
                    if (null == val || val.trim().length() <= 0) continue;
                    refVal = val;
                    break;
                }
                if (refVal == null || (result = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)(gpc = "nodes.node." + refVal + ".node-host"), (long)10000L)).getState() != TaskState.COMPLETED) break block4;
                for (Map.Entry entry : result.getValue().entrySet()) {
                    val = (String)entry.getValue();
                    if (null == val || val.trim().length() <= 0) continue;
                    retVal = val;
                    break;
                }
            }
            catch (GlassFishIdeException gfie) {
                LOGGER.log(Level.INFO, "Could not get http host value.", gfie);
            }
        }
        return LOCALHOST.equals(retVal) ? nameOfLocalhost : retVal;
    }

    private void refreshChildren() {
        GlassfishInstance instance = this.getInstance();
        RefreshModulesCookie cookie = (RefreshModulesCookie)instance.getFullNode().getLookup().lookup(RefreshModulesCookie.class);
        if (cookie != null) {
            cookie.refresh(null, null);
        }
    }

    class KillOperationStateListener
    implements TaskStateListener {
        KillOperationStateListener() {
        }

        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            if (newState == TaskState.RUNNING) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
            } else if (newState == TaskState.COMPLETED) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
            } else if (newState == TaskState.FAILED && event == TaskEvent.PROCESS_NOT_RUNNING) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
            }
        }
    }

    class StopOperationStateListener
    implements TaskStateListener {
        StopOperationStateListener() {
        }

        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            if (newState == TaskState.RUNNING) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
            } else if (newState == TaskState.COMPLETED) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
            } else if (newState == TaskState.FAILED) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
            }
        }
    }

    class StartOperationStateListener
    implements TaskStateListener {
        private GlassfishModule.ServerState endState;

        StartOperationStateListener(GlassfishModule.ServerState endState) {
            this.endState = endState;
        }

        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            if (newState == TaskState.RUNNING) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
            } else if (newState == TaskState.COMPLETED) {
                CommonServerSupport.this.startedByIde = CommonServerSupport.this.isRemote ? false : GlassFishState.isOnline(CommonServerSupport.this.instance);
                CommonServerSupport.this.setServerState(this.endState);
            } else if (newState == TaskState.FAILED) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)org.netbeans.modules.glassfish.tooling.utils.Utils.concatenate((String[])args));
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
        }
    }

    private static class LocationsTaskStateListener
    implements TaskStateListener {
        final CommonServerSupport css;

        LocationsTaskStateListener(CommonServerSupport css) {
            this.css = css;
        }

        private String adminCommandFailedMsg(String resName, String[] args) {
            String serverName = args[0];
            String command = args[1];
            String exMessage = args.length > 2 ? args[2] : null;
            return args.length > 2 ? NbBundle.getMessage(CommonServerSupport.class, (String)resName, (Object)args[0], (Object)args[1], (Object)args[2]) : NbBundle.getMessage(CommonServerSupport.class, (String)resName, (Object)args[0], (Object)args[1]);
        }

        public void operationStateChanged(TaskState newState, TaskEvent event, String[] args) {
            if (args.length > 1) {
                boolean display;
                String exMessage = args.length > 2 ? args[2] : null;
                boolean bl = display = args.length > 3 ? Boolean.parseBoolean(args[3]) : false;
                if (display) {
                    long lastDisplayed = this.css.getLatestWarningDisplayTime();
                    long currentTime = System.currentTimeMillis();
                    if (TaskState.FAILED == newState && currentTime - lastDisplayed > 5000L) {
                        String message;
                        switch (event) {
                            case EXCEPTION: {
                                if (exMessage != null && exMessage.length() > 0) {
                                    message = this.adminCommandFailedMsg("MSG_ADMIN_EXCEPTION", args);
                                    break;
                                }
                                message = this.adminCommandFailedMsg("MSG_ADMIN_FAILED", args);
                                break;
                            }
                            case AUTH_FAILED: 
                            case AUTH_FAILED_HTTP: {
                                message = this.adminCommandFailedMsg("MSG_ADMIN_AUTH_FAILED", args);
                                break;
                            }
                            default: {
                                message = this.adminCommandFailedMsg("MSG_ADMIN_FAILED", args);
                            }
                        }
                        CommonServerSupport.displayPopUpMessage(this.css, message);
                    }
                }
            }
        }
    }
}

