/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.Collection;
import java.util.Iterator;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;

abstract class InstanceCompleter
implements Completer,
Completer.Factory {
    protected final FxInstance instance;
    protected final boolean attribute;
    protected final CompletionContext ctx;
    protected final TypeElement instanceType;
    private FxBean beanInfo;

    protected InstanceCompleter() {
        this.instance = null;
        this.attribute = false;
        this.ctx = null;
        this.instanceType = null;
    }

    protected InstanceCompleter(FxInstance instance, boolean attribute, CompletionContext context) {
        this.instance = instance;
        this.attribute = attribute;
        this.ctx = context;
        this.instanceType = instance.getJavaType() != null ? (TypeElement)instance.getJavaType().resolve(this.ctx.getCompilationInfo()) : null;
    }

    protected abstract InstanceCompleter createCompleter(FxInstance var1, boolean var2, CompletionContext var3);

    protected FxBean getBeanInfo() {
        if (this.beanInfo == null) {
            this.beanInfo = this.ctx.getBeanInfo(this.instance);
        }
        return this.beanInfo;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        FxNode parent = ctx.getElementParent();
        FxInstance enclosingInstance = null;
        if (parent != null && parent.getKind() == FxNode.Kind.Instance) {
            enclosingInstance = (FxInstance)parent;
        }
        if (enclosingInstance == null) {
            return null;
        }
        switch (ctx.getType()) {
            case CHILD_ELEMENT: 
            case PROPERTY_ELEMENT: 
            case ROOT: 
            case BEAN: {
                return this.createCompleter(enclosingInstance, false, ctx);
            }
            case PROPERTY: {
                return this.createCompleter(enclosingInstance, true, ctx);
            }
        }
        return null;
    }

    protected final Collection<String> filterNames(Collection<String> names) {
        String pref = this.ctx.getPrefix();
        if (pref.startsWith("<") && !this.attribute) {
            pref = pref.substring(1);
        }
        if (!pref.isEmpty()) {
            boolean camel = CompletionUtils.isCamelCasePrefix(pref);
            String lowPref = pref.toLowerCase();
            Iterator<String> it = names.iterator();
            while (it.hasNext()) {
                String n = it.next();
                if (camel) {
                    if (CompletionUtils.startsWithCamelCase(n, pref)) continue;
                    it.remove();
                    continue;
                }
                if (n.toLowerCase().startsWith(lowPref)) continue;
                it.remove();
            }
            return names;
        }
        return names;
    }
}

