/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.TagFileType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.PageIteratorValidation;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class PageIterator
implements TemplateWizard.Iterator {
    private static final Logger LOG = Logger.getLogger(PageIterator.class.getName());
    private static final long serialVersionUID = -7586964579556513549L;
    private transient FileType fileType;
    private WizardDescriptor.Panel folderPanel;
    private transient SourceGroup[] sourceGroups;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;

    public static PageIterator createJspIterator() {
        return new PageIterator(FileType.JSP);
    }

    public static PageIterator createJsfIterator() {
        return new PageIterator(FileType.JSF);
    }

    public static PageIterator createTagIterator() {
        return new PageIterator(FileType.TAG);
    }

    public static PageIterator createTagLibraryIterator() {
        return new PageIterator(FileType.TAGLIBRARY);
    }

    public static PageIterator createHtmlIterator() {
        return new PageIterator(FileType.HTML);
    }

    public static PageIterator createJSIterator() {
        return new PageIterator(FileType.JS);
    }

    public static PageIterator createXHtmlIterator() {
        return new PageIterator(FileType.XHTML);
    }

    public static PageIterator createXCssIterator() {
        return new PageIterator(FileType.CSS);
    }

    protected PageIterator(FileType fileType) {
        this.fileType = fileType;
    }

    protected WizardDescriptor.Panel[] createPanels(Project project) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (this.fileType.equals(FileType.JSP) || this.fileType.equals(FileType.JSF)) {
            this.sourceGroups = sources.getSourceGroups("doc_root");
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("generic");
            }
            this.folderPanel = new PageIteratorValidation.JsfJspValidatorPanel((WizardDescriptor.Panel)new TargetChooserPanel(project, this.sourceGroups, (Object)this.fileType));
            return new WizardDescriptor.Panel[]{this.folderPanel};
        }
        if (this.fileType.equals(FileType.HTML) || this.fileType.equals(FileType.XHTML) || this.fileType.equals(FileType.CSS) || this.fileType.equals(FileType.JS)) {
            SourceGroup[] docRoot = sources.getSourceGroups("doc_root");
            SourceGroup[] srcRoots = Util.getJavaSourceGroups(project);
            if (docRoot != null && srcRoots != null) {
                this.sourceGroups = new SourceGroup[docRoot.length + srcRoots.length];
                System.arraycopy(docRoot, 0, this.sourceGroups, 0, docRoot.length);
                System.arraycopy(srcRoots, 0, this.sourceGroups, docRoot.length, srcRoots.length);
            }
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("generic");
            }
            this.folderPanel = new TargetChooserPanel(project, this.sourceGroups, (Object)this.fileType);
            return new WizardDescriptor.Panel[]{this.folderPanel};
        }
        if (this.fileType.equals(FileType.TAG)) {
            this.sourceGroups = sources.getSourceGroups("web_inf");
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("doc_root");
            }
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("java");
            }
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("generic");
            }
            this.folderPanel = new TargetChooserPanel(project, this.sourceGroups, (Object)this.fileType);
            return new WizardDescriptor.Panel[]{this.folderPanel};
        }
        if (this.fileType.equals(FileType.TAGLIBRARY)) {
            this.sourceGroups = sources.getSourceGroups("doc_root");
            SourceGroup[] docRoot = sources.getSourceGroups("doc_root");
            SourceGroup[] webInfGroups = sources.getSourceGroups("web_inf");
            if (docRoot == null || docRoot.length == 0) {
                docRoot = sources.getSourceGroups("java");
            }
            if (docRoot != null && webInfGroups != null) {
                this.sourceGroups = new SourceGroup[docRoot.length + webInfGroups.length];
                System.arraycopy(webInfGroups, 0, this.sourceGroups, 0, webInfGroups.length);
                System.arraycopy(docRoot, 0, this.sourceGroups, webInfGroups.length, docRoot.length);
            }
            if (this.sourceGroups == null || this.sourceGroups.length == 0) {
                this.sourceGroups = sources.getSourceGroups("generic");
            }
            this.folderPanel = new TargetChooserPanel(project, this.sourceGroups, (Object)this.fileType);
            return new WizardDescriptor.Panel[]{this.folderPanel};
        }
        return new WizardDescriptor.Panel[]{Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])this.sourceGroups)};
    }

    private static boolean isJSF20(WebModule wm) {
        ClassPath classpath = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/compile");
        return classpath != null && classpath.findResource("javax/faces/application/ProjectStage.class") != null;
    }

    private static boolean isJSF22(WebModule wm) {
        ClassPath classpath = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/compile");
        return classpath != null && classpath.findResource("javax/faces/flow/Flow.class") != null;
    }

    private static boolean isJSF30(WebModule wm) {
        ClassPath classpath = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/compile");
        return classpath != null && classpath.findResource("jakarta/faces/flow/Flow.class") != null;
    }

    private static boolean isJSF40(WebModule wm) {
        ClassPath classpath = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/compile");
        return classpath != null && classpath.findResource("jakarta/faces/lifecycle/ClientWindowScoped.class") != null;
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        WebModule wm;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        FileObject templateParent = template.getParent();
        HashMap<String, Boolean> wizardProps = new HashMap<String, Boolean>();
        String defaultNamespace = null;
        if (FileType.JSP.equals(this.fileType) || FileType.JSF.equals(this.fileType)) {
            if (this.isSegment(wiz)) {
                template = this.isXml(wiz) ? templateParent.getFileObject("JSPFX", "jspf") : templateParent.getFileObject("JSPF", "jspf");
            } else {
                if (this.isXml(wiz)) {
                    template = templateParent.getFileObject("JSPX", "jspx");
                }
                if (this.isFacelets(wiz)) {
                    template = templateParent.getFileObject("JSP", "xhtml");
                    wm = WebModule.getWebModule((FileObject)df.getPrimaryFile());
                    if (wm != null) {
                        if (PageIterator.isJSF40(wm)) {
                            wizardProps.put("isJSF40", Boolean.TRUE);
                        } else if (PageIterator.isJSF30(wm)) {
                            wizardProps.put("isJSF30", Boolean.TRUE);
                        } else if (PageIterator.isJSF22(wm)) {
                            wizardProps.put("isJSF22", Boolean.TRUE);
                        } else if (PageIterator.isJSF20(wm)) {
                            wizardProps.put("isJSF20", Boolean.TRUE);
                        }
                    }
                }
            }
        } else if (FileType.TAG.equals(this.fileType)) {
            if (this.isSegment(wiz)) {
                template = this.isXml(wiz) ? templateParent.getFileObject("TagFileFX", "tagf") : templateParent.getFileObject("TagFileF", "tagf");
            } else if (this.isXml(wiz)) {
                template = templateParent.getFileObject("TagFileX", "tagx");
            }
        } else if (FileType.TAGLIBRARY.equals(this.fileType) && (wm = WebModule.getWebModule((FileObject)dir)) != null) {
            Profile j2eeVersion = wm.getJ2eeProfile();
            if (Profile.J2EE_13.equals((Object)j2eeVersion)) {
                template = templateParent.getFileObject("TagLibrary_1_2", "tld");
                defaultNamespace = "http://java.sun.com/xml/ns/j2ee";
            } else if (Profile.J2EE_14.equals((Object)j2eeVersion)) {
                template = templateParent.getFileObject("TagLibrary_2_0", "tld");
                defaultNamespace = "http://java.sun.com/xml/ns/j2ee";
            }
        }
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)wiz), wizardProps);
        if (dobj != null) {
            FileObject tldFo;
            if (FileType.TAGLIBRARY.equals(this.fileType)) {
                TLDDataObject tldDO = (TLDDataObject)dobj;
                Taglib taglib = tldDO.getTaglib();
                if (defaultNamespace != null) {
                    taglib.setDefaultNamespace(defaultNamespace);
                }
                taglib.setUri(wiz.getProperty("uri").toString());
                taglib.setShortName(wiz.getProperty("prefix").toString());
                tldDO.write(taglib);
            } else if (FileType.TAG.equals(this.fileType) && ((Boolean)wiz.getProperty("isTldSelected")).booleanValue() && (tldFo = (FileObject)wiz.getProperty("tldFileObject")) != null) {
                if (!tldFo.canWrite()) {
                    String mes = MessageFormat.format(NbBundle.getMessage(PageIterator.class, (String)"MSG_tldRO"), tldFo.getNameExt());
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                } else {
                    TLDDataObject tldDO = (TLDDataObject)DataObject.find((FileObject)tldFo);
                    Taglib taglib = null;
                    try {
                        taglib = tldDO.getTaglib();
                    }
                    catch (IOException ex) {
                        String mes = MessageFormat.format(NbBundle.getMessage(PageIterator.class, (String)"MSG_tldCorrupted"), tldFo.getNameExt());
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                    if (taglib != null) {
                        TagFileType tag = new TagFileType();
                        tag.setName(wiz.getProperty("tagName").toString());
                        String packageName = null;
                        for (int i = 0; i < this.sourceGroups.length && packageName == null; ++i) {
                            FileObject rootFolder = this.sourceGroups[i].getRootFolder();
                            packageName = rootFolder.getName() + "/" + FileUtil.getRelativePath((FileObject)rootFolder, (FileObject)dobj.getPrimaryFile());
                        }
                        tag.setPath("/" + packageName);
                        taglib.addTagFile(tag);
                        SaveCookie save = (SaveCookie)tldDO.getCookie(SaveCookie.class);
                        if (save != null) {
                            save.save();
                        }
                        try {
                            tldDO.write(taglib);
                        }
                        catch (IOException ex) {
                            LOG.log(Level.WARNING, null, ex);
                        }
                    }
                }
            }
        }
        return Collections.singleton(dobj);
    }

    private boolean isXml(TemplateWizard wiz) {
        return (Boolean)wiz.getProperty(FileType.IS_XML);
    }

    private boolean isSegment(TemplateWizard wiz) {
        return (Boolean)wiz.getProperty(FileType.IS_SEGMENT);
    }

    private boolean isFacelets(TemplateWizard wiz) {
        return (Boolean)wiz.getProperty(FileType.IS_FACELETS);
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels(project);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(PageIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

