/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.Function;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.netbeans.modules.web.jsf.api.editor.JSFResourceBundlesProvider;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FaceletsELPlugin
extends ELPlugin {
    private static final String PLUGIN_NAME = "JSF Facelets EL Plugin";
    private Collection<ImplicitObject> IMPL_OBJECTS;

    public String getName() {
        return PLUGIN_NAME;
    }

    public Collection<String> getMimeTypes() {
        return Collections.singletonList("text/xhtml");
    }

    public synchronized Collection<ImplicitObject> getImplicitObjects(FileObject file) {
        if (!this.getMimeTypes().contains(file.getMIMEType())) {
            return Collections.emptyList();
        }
        if (this.IMPL_OBJECTS == null) {
            this.IMPL_OBJECTS = new ArrayList<ImplicitObject>(9);
            this.IMPL_OBJECTS.addAll(FaceletsELPlugin.getScopeObjects());
            this.IMPL_OBJECTS.add(new FacesContextObject());
            this.IMPL_OBJECTS.add(new ApplicationObject());
            this.IMPL_OBJECTS.add(new ComponentObject());
            this.IMPL_OBJECTS.add(new FlashObject());
            this.IMPL_OBJECTS.add(new ResourceObject());
            this.IMPL_OBJECTS.add(new SessionObject());
            this.IMPL_OBJECTS.add(new ViewObject());
            this.IMPL_OBJECTS.add(new JsfImplicitObject("cookie", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("cc", "javax.faces.component.UIComponent", ImplicitObjectType.RAW));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("request", "javax.servlet.http.HttpServletRequest", ImplicitObjectType.OBJECT_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("header", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("headerValues", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("initParam", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("param", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("paramValues", "java.util.Map", ImplicitObjectType.MAP_TYPE));
        }
        return this.IMPL_OBJECTS;
    }

    public List<ResourceBundle> getResourceBundles(FileObject file, ResolverContext context) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return Collections.emptyList();
        }
        if (context.getContent(FaceletsELPlugin.class.getName()) == null) {
            context.setContent(FaceletsELPlugin.class.getName(), (Object)JSFResourceBundlesProvider.getResourceBundles((Project)project));
        }
        return (List)context.getContent(FaceletsELPlugin.class.getName());
    }

    private static Collection<ImplicitObject> getScopeObjects() {
        ArrayList<ImplicitObject> result = new ArrayList<ImplicitObject>(5);
        result.add(new JsfImplicitObject("sessionScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        result.add(new JsfImplicitObject("applicationScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        result.add(new JsfImplicitObject("requestScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        result.add(new JsfImplicitObject("viewScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        result.add(new JsfImplicitObject("flowScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        return result;
    }

    public List<Function> getFunctions(FileObject file) {
        ArrayList<Function> functions = new ArrayList<Function>();
        final HashMap namespaces = new HashMap();
        try {
            Source source = Source.create((FileObject)file);
            ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parseResult = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (parseResult instanceof HtmlParserResult) {
                        namespaces.putAll(((HtmlParserResult)parseResult).getNamespaces());
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Map<String, FaceletsLibraryDescriptor> librariesDescriptors = DefaultFaceletLibraries.getInstance().getLibrariesDescriptors();
        for (Map.Entry<String, FaceletsLibraryDescriptor> entry : librariesDescriptors.entrySet()) {
            String currentPrefix = (String)namespaces.get(entry.getKey());
            if (currentPrefix == null) continue;
            functions.addAll(FaceletsELPlugin.getFunctionsFromDescriptor(entry.getValue(), currentPrefix));
        }
        return functions;
    }

    private static List<Function> getFunctionsFromDescriptor(FaceletsLibraryDescriptor descriptor, String prefix) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Map.Entry<String, org.netbeans.modules.web.jsfapi.api.Function> entry : descriptor.getFunctions().entrySet()) {
            org.netbeans.modules.web.jsfapi.api.Function function = entry.getValue();
            functions.add(new Function(prefix + ":" + function.getName(), FaceletsELPlugin.getReturnTypeForSignature(function.getSignature()), FaceletsELPlugin.getParametersForSignature(function.getSignature()), function.getDescription()));
        }
        return functions;
    }

    private static String getReturnTypeForSignature(String signature) {
        String returnType = signature.substring(0, signature.indexOf(" "));
        return FaceletsELPlugin.getSimpleNameForType(returnType.trim());
    }

    private static List<String> getParametersForSignature(String signature) {
        ArrayList<String> params = new ArrayList<String>();
        String paramString = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
        for (String param : paramString.split(",")) {
            params.add(FaceletsELPlugin.getSimpleNameForType(param.trim()));
        }
        return params;
    }

    private static String getSimpleNameForType(String fqn) {
        return fqn.substring(fqn.lastIndexOf(".") + 1);
    }

    private static class JsfImplicitObject
    implements ImplicitObject {
        private String name;
        private String clazz;
        private ImplicitObjectType type;

        public JsfImplicitObject(String name, String clazz, ImplicitObjectType type) {
            this.name = name;
            this.clazz = clazz;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ImplicitObjectType getType() {
            return this.type;
        }

        public String getClazz() {
            return this.clazz;
        }
    }

    static class ViewObject
    extends JsfImplicitObject {
        public ViewObject() {
            super("view", "javax.faces.component.UIViewRoot", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class SessionObject
    extends JsfImplicitObject {
        public SessionObject() {
            super("session", "javax.servlet.http.HttpSession", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ResourceObject
    extends JsfImplicitObject {
        public ResourceObject() {
            super("resource", "javax.faces.application.ResourceHandler", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class FlashObject
    extends JsfImplicitObject {
        public FlashObject() {
            super("flash", "javax.faces.context.Flash", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ComponentObject
    extends JsfImplicitObject {
        public ComponentObject() {
            super("component", "javax.faces.component.UIComponent", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ApplicationObject
    extends JsfImplicitObject {
        public ApplicationObject() {
            super("application", "javax.servlet.ServletContext", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class FacesContextObject
    extends JsfImplicitObject {
        public FacesContextObject() {
            super("facesContext", "javax.faces.context.FacesContext", ImplicitObjectType.OBJECT_TYPE);
        }
    }
}

