/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.attach;

import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.debugging.attach.Bundle;
import org.netbeans.modules.java.lsp.server.debugging.attach.ConfigurationAttribute;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientCapabilities;

final class ConfigurationAttributes {
    private static final String CONNECTOR_PROCESS = "com.sun.jdi.ProcessAttach";
    private static final String CONNECTOR_SOCKET = "com.sun.jdi.SocketAttach";
    private static final String CONNECTOR_SHMEM = "com.sun.jdi.SharedMemoryAttach";
    private static final String CONNECTOR_SOCKET_LISTEN = "com.sun.jdi.SocketListen";
    static final String PROCESS_ARG_PID = "processId";
    static final String SOCKET_ARG_HOST = "hostName";
    static final String SOCKET_ARG_PORT = "port";
    static final String SHMEM_ARG_NAME = "sharedMemoryName";
    private final Connector ac;
    private final String id;
    private final String name;
    private final String description;
    private final Map<String, ConfigurationAttribute> attributes = new LinkedHashMap<String, ConfigurationAttribute>();

    ConfigurationAttributes(NbCodeClientCapabilities capa, Connector ac) {
        String connectorName;
        this.ac = ac;
        this.id = connectorName = ac.name();
        this.description = ac.description();
        Map<String, Connector.Argument> defaultArguments = ac.defaultArguments();
        switch (connectorName) {
            case "com.sun.jdi.ProcessAttach": {
                this.name = Bundle.LBL_AttachToProcess();
                this.attributes.put(PROCESS_ARG_PID, new ConfigurationAttribute("${command:" + Utils.encodeCommand("nbls.java.attachDebugger.pickProcess", capa) + "}", "", true));
                break;
            }
            case "com.sun.jdi.SocketAttach": {
                this.name = Bundle.LBL_AttachToPort();
                String hostName = ConfigurationAttributes.getArgumentOrDefault(defaultArguments.get("hostname"), "localhost");
                String port = ConfigurationAttributes.getArgumentOrDefault(defaultArguments.get(SOCKET_ARG_PORT), "8000");
                this.attributes.put(SOCKET_ARG_HOST, new ConfigurationAttribute(hostName, Bundle.DESC_HostName(), true));
                this.attributes.put(SOCKET_ARG_PORT, new ConfigurationAttribute(port, Bundle.DESC_Port(), true));
                break;
            }
            case "com.sun.jdi.SharedMemoryAttach": {
                this.name = Bundle.LBL_AttachToShmem();
                String shmName = ConfigurationAttributes.getArgumentOrDefault(defaultArguments.get("name"), "");
                this.attributes.put(SHMEM_ARG_NAME, new ConfigurationAttribute(shmName, Bundle.DESC_ShMem(), true));
                break;
            }
            case "com.sun.jdi.SocketListen": {
                this.name = Bundle.LBL_ListenOnPort();
                String hostName = ConfigurationAttributes.getArgumentOrDefault(defaultArguments.get("hostname"), "localhost");
                String port = ConfigurationAttributes.getArgumentOrDefault(defaultArguments.get(SOCKET_ARG_PORT), "8000");
                this.attributes.put(SOCKET_ARG_HOST, new ConfigurationAttribute(hostName, Bundle.DESC_HostName(), true));
                this.attributes.put(SOCKET_ARG_PORT, new ConfigurationAttribute(port, Bundle.DESC_Port(), true));
                break;
            }
            default: {
                this.name = Bundle.LBL_AttachBy(connectorName);
                for (Connector.Argument arg : defaultArguments.values()) {
                    if (!arg.mustSpecify()) continue;
                    this.attributes.put(arg.name(), new ConfigurationAttribute(arg.value(), arg.description(), true));
                }
            }
        }
        for (Connector.Argument arg : defaultArguments.values()) {
            if (arg.mustSpecify() || this.attributes.containsKey(arg.name())) continue;
            this.attributes.put(arg.name(), new ConfigurationAttribute(arg.value(), arg.description(), false));
        }
        if (ac instanceof ListeningConnector) {
            this.attributes.put("listen", new ConfigurationAttribute("true", Bundle.LBL_ListenForAttach(), true));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Connector getConnector() {
        return this.ac;
    }

    public Map<String, ConfigurationAttribute> getAttributes() {
        return this.attributes;
    }

    private static String getArgumentOrDefault(Connector.Argument arg, String def) {
        String value;
        if (arg != null && !(value = arg.value()).isEmpty()) {
            return value;
        }
        return def;
    }

    boolean areMandatoryAttributesIn(Set<String> names) {
        for (Map.Entry<String, ConfigurationAttribute> entry : this.attributes.entrySet()) {
            if (!entry.getValue().isMustSpecify() || names.contains(entry.getKey())) continue;
            return false;
        }
        return true;
    }
}

