/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropCallNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNodeGen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSInteropInstantiateNode.class)
public final class JSInteropInstantiateNodeGen
extends JSInteropInstantiateNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private DefaultData default_cache;

    private JSInteropInstantiateNodeGen() {
    }

    @Override
    public Object execute(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
        DefaultData s1_;
        int state = this.state_;
        if (state != 0 && (s1_ = this.default_cache) != null) {
            return this.doDefault(arg0Value, arg1Value, s1_.isConstructorNode_, s1_.callNode_, s1_.importValueNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            DefaultData s1_ = (DefaultData)super.insert((Node)new DefaultData());
            s1_.isConstructorNode_ = s1_.insertAccessor(IsConstructorNode.create());
            s1_.callNode_ = s1_.insertAccessor(JSFunctionCallNode.createNew());
            s1_.importValueNode_ = s1_.insertAccessor(ImportValueNode.create());
            this.default_cache = s1_;
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            Object object = this.doDefault(arg0Value, arg1Value, s1_.isConstructorNode_, s1_.callNode_, s1_.importValueNode_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[2];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doDefault";
        if (state != 0) {
            s[1] = (byte)1;
            ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
            DefaultData s1_ = this.default_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{s1_.isConstructorNode_, s1_.callNode_, s1_.importValueNode_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSInteropInstantiateNode create() {
        return new JSInteropInstantiateNodeGen();
    }

    public static JSInteropInstantiateNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=JSInteropInstantiateNode.class)
    private static final class Uncached
    extends JSInteropInstantiateNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
            return this.doDefault(arg0Value, arg1Value, IsConstructorNodeGen.getUncached(), JSInteropCallNode.getUncachedCall(), ImportValueNodeGen.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=JSInteropInstantiateNode.class)
    private static final class DefaultData
    extends Node {
        @Node.Child
        IsConstructorNode isConstructorNode_;
        @Node.Child
        JSFunctionCallNode callNode_;
        @Node.Child
        ImportValueNode importValueNode_;

        DefaultData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

