/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class KHRSemaphore {
    public static final int CL_PLATFORM_SEMAPHORE_TYPES_KHR = 8246;
    public static final int CL_DEVICE_SEMAPHORE_TYPES_KHR = 8268;
    public static final int CL_SEMAPHORE_TYPE_BINARY_KHR = 1;
    public static final int CL_SEMAPHORE_CONTEXT_KHR = 8249;
    public static final int CL_SEMAPHORE_REFERENCE_COUNT_KHR = 8250;
    public static final int CL_SEMAPHORE_PROPERTIES_KHR = 8251;
    public static final int CL_SEMAPHORE_PAYLOAD_KHR = 8252;
    public static final int CL_SEMAPHORE_TYPE_KHR = 8253;
    public static final int CL_DEVICE_HANDLE_LIST_KHR = 8273;
    public static final int CL_DEVICE_HANDLE_LIST_END_KHR = 0;
    public static final int CL_COMMAND_SEMAPHORE_WAIT_KHR = 8258;
    public static final int CL_COMMAND_SEMAPHORE_SIGNAL_KHR = 8259;
    public static final int CL_INVALID_SEMAPHORE_KHR = -1142;

    protected KHRSemaphore() {
        throw new UnsupportedOperationException();
    }

    public static long nclCreateSemaphoreWithPropertiesKHR(long context, long sema_props, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSemaphoreWithPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPPP((long)context, (long)sema_props, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_semaphore_khr")
    public static long clCreateSemaphoreWithPropertiesKHR(@NativeType(value="cl_context") long context, @NativeType(value="cl_semaphore_properties_khr const *") LongBuffer sema_props, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNT((LongBuffer)sema_props);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return KHRSemaphore.nclCreateSemaphoreWithPropertiesKHR(context, MemoryUtil.memAddress((LongBuffer)sema_props), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static int nclEnqueueWaitSemaphoresKHR(long command_queue, int num_sema_objects, long sema_objects, long sema_payload_list, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWaitSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPI((long)command_queue, (int)num_sema_objects, (long)sema_objects, (long)sema_payload_list, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWaitSemaphoresKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_semaphore_khr const *") PointerBuffer sema_objects, @Nullable @NativeType(value="cl_semaphore_payload_khr const *") LongBuffer sema_payload_list, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return KHRSemaphore.nclEnqueueWaitSemaphoresKHR(command_queue, sema_objects.remaining(), MemoryUtil.memAddress((CustomBuffer)sema_objects), MemoryUtil.memAddressSafe((LongBuffer)sema_payload_list), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueSignalSemaphoresKHR(long command_queue, int num_sema_objects, long sema_objects, long sema_payload_list, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSignalSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPI((long)command_queue, (int)num_sema_objects, (long)sema_objects, (long)sema_payload_list, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSignalSemaphoresKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_semaphore_khr const *") PointerBuffer sema_objects, @NativeType(value="cl_semaphore_payload_khr const *") LongBuffer sema_payload_list, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return KHRSemaphore.nclEnqueueSignalSemaphoresKHR(command_queue, sema_objects.remaining(), MemoryUtil.memAddress((CustomBuffer)sema_objects), MemoryUtil.memAddress((LongBuffer)sema_payload_list), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclGetSemaphoreInfoKHR(long sema_object, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetSemaphoreInfoKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)sema_object);
        }
        return JNI.callPPPPI((long)sema_object, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSemaphoreInfoKHR(@NativeType(value="cl_semaphore_khr") long sema_object, @NativeType(value="cl_semaphore_info_khr") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return KHRSemaphore.nclGetSemaphoreInfoKHR(sema_object, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetSemaphoreInfoKHR(@NativeType(value="cl_semaphore_khr") long sema_object, @NativeType(value="cl_semaphore_info_khr") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return KHRSemaphore.nclGetSemaphoreInfoKHR(sema_object, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetSemaphoreInfoKHR(@NativeType(value="cl_semaphore_khr") long sema_object, @NativeType(value="cl_semaphore_info_khr") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return KHRSemaphore.nclGetSemaphoreInfoKHR(sema_object, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clReleaseSemaphoreKHR(@NativeType(value="cl_semaphore_khr") long sema_object) {
        long __functionAddress = CL.getICD().clReleaseSemaphoreKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)sema_object);
        }
        return JNI.callPI((long)sema_object, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clRetainSemaphoreKHR(@NativeType(value="cl_semaphore_khr") long sema_object) {
        long __functionAddress = CL.getICD().clRetainSemaphoreKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)sema_object);
        }
        return JNI.callPI((long)sema_object, (long)__functionAddress);
    }

    @NativeType(value="cl_semaphore_khr")
    public static long clCreateSemaphoreWithPropertiesKHR(@NativeType(value="cl_context") long context, @NativeType(value="cl_semaphore_properties_khr const *") long[] sema_props, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSemaphoreWithPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNT((long[])sema_props);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPP((long)context, (long[])sema_props, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWaitSemaphoresKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_semaphore_khr const *") PointerBuffer sema_objects, @Nullable @NativeType(value="cl_semaphore_payload_khr const *") long[] sema_payload_list, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWaitSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPI((long)command_queue, (int)sema_objects.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)sema_objects), (long[])sema_payload_list, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSignalSemaphoresKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_semaphore_khr const *") PointerBuffer sema_objects, @NativeType(value="cl_semaphore_payload_khr const *") long[] sema_payload_list, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueSignalSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return JNI.callPPPPPI((long)command_queue, (int)sema_objects.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)sema_objects), (long[])sema_payload_list, (int)Checks.remainingSafe((CustomBuffer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event_wait_list), (long)MemoryUtil.memAddressSafe((Pointer)event), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSemaphoreInfoKHR(@NativeType(value="cl_semaphore_khr") long sema_object, @NativeType(value="cl_semaphore_info_khr") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetSemaphoreInfoKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)sema_object);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)sema_object, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }
}

