/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlDtd;
import nokogiri.internals.HtmlDomParserContext;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::HTML4::Document"}, parent="Nokogiri::XML::Document")
public class Html4Document
extends XmlDocument {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CONTENT_TYPE = "html";
    private static final String DEFAULT_PUBLIC_ID = "-//W3C//DTD HTML 4.01//EN";
    private static final String DEFAULT_SYTEM_ID = "http://www.w3.org/TR/html4/strict.dtd";
    private String parsed_encoding = null;

    public Html4Document(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public Html4Document(Ruby ruby, Document document) {
        this(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document"), document);
    }

    public Html4Document(Ruby ruby, RubyClass rubyClass, Document document) {
        super(ruby, rubyClass, document);
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true, required=0)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Html4Document html4Document;
        Ruby ruby = threadContext.runtime;
        try {
            Document document = Html4Document.createNewDocument(ruby);
            html4Document = (Html4Document)NokogiriService.HTML_DOCUMENT_ALLOCATOR.allocate(ruby, (RubyClass)iRubyObject);
            html4Document.setDocumentNode(threadContext.runtime, document);
        }
        catch (Exception exception) {
            throw Html4Document.asRuntimeError(ruby, "couldn't create document: ", exception);
        }
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)html4Document, (String)"initialize", (IRubyObject[])iRubyObjectArray);
        return html4Document;
    }

    @Override
    public IRubyObject getInternalSubset(ThreadContext threadContext) {
        Object object = super.getInternalSubset(threadContext);
        if (object.isNil()) {
            object = XmlDtd.newEmpty(threadContext.getRuntime(), this.getDocument(), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_CONTENT_TYPE), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_PUBLIC_ID), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_SYTEM_ID));
            this.setInternalSubset((IRubyObject)object);
        }
        return object;
    }

    @Override
    void init(Ruby ruby, Document document) {
        Html4Document.stabilizeTextContent(document);
        document.normalize();
        this.setInstanceVariable("@decorators", ruby.getNil());
        if (document.getDocumentElement() != null) {
            Html4Document.stabilizeAttrs(document.getDocumentElement());
        }
    }

    private static void stabilizeAttrs(Node node) {
        int n;
        Object object;
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                Node node2 = object.item(n);
                if (!(node2 instanceof Attr)) continue;
                Html4Document.stabilizeAttr((Attr)node2);
            }
        }
        object = node.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            Html4Document.stabilizeAttrs(object.item(n));
        }
    }

    public void setParsedEncoding(String string) {
        this.parsed_encoding = string;
    }

    public String getPraedEncoding() {
        return this.parsed_encoding;
    }

    @JRubyMethod(meta=true, required=4)
    public static IRubyObject read_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        HtmlDomParserContext htmlDomParserContext = new HtmlDomParserContext(threadContext.runtime, iRubyObjectArray[2], iRubyObjectArray[3]);
        htmlDomParserContext.setIOInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return htmlDomParserContext.parse(threadContext, (RubyClass)iRubyObject, iRubyObjectArray[1]);
    }

    @JRubyMethod(meta=true, required=4)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        HtmlDomParserContext htmlDomParserContext = new HtmlDomParserContext(threadContext.runtime, iRubyObjectArray[2], iRubyObjectArray[3]);
        htmlDomParserContext.setStringInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return htmlDomParserContext.parse(threadContext, (RubyClass)iRubyObject, iRubyObjectArray[1]);
    }
}

