/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import co.elastic.logstash.api.PluginHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.logstash.Event;
import org.logstash.RubyUtil;
import org.logstash.StringInterpolation;

class CommonActions {
    CommonActions() {
    }

    static Consumer<co.elastic.logstash.api.Event> getFilterAction(Map.Entry<String, Object> actionDefinition) {
        String actionName = actionDefinition.getKey();
        if (actionName.equals(PluginHelper.ADD_FIELD_CONFIG.name())) {
            return x -> CommonActions.addField(x, (Map<String, Object>)((Map)actionDefinition.getValue()));
        }
        if (actionName.equals(PluginHelper.ADD_TAG_CONFIG.name())) {
            return x -> CommonActions.addTag(x, (List<Object>)((List)actionDefinition.getValue()));
        }
        if (actionName.equals(PluginHelper.REMOVE_FIELD_CONFIG.name())) {
            return x -> CommonActions.removeField(x, (List)actionDefinition.getValue());
        }
        if (actionName.equals(PluginHelper.REMOVE_TAG_CONFIG.name())) {
            return x -> CommonActions.removeTag(x, (List)actionDefinition.getValue());
        }
        return null;
    }

    static Function<Map<String, Object>, Map<String, Object>> getInputAction(Map.Entry<String, Object> actionDefinition) {
        String actionName = actionDefinition.getKey();
        if (actionName.equals(PluginHelper.ADD_FIELD_CONFIG.name())) {
            return x -> CommonActions.addField(x, (Map<String, Object>)((Map)actionDefinition.getValue()));
        }
        if (actionName.equals(PluginHelper.TAGS_CONFIG.name())) {
            return x -> CommonActions.addTag(x, (List<Object>)((List)actionDefinition.getValue()));
        }
        if (actionName.equals(PluginHelper.TYPE_CONFIG.name())) {
            return x -> CommonActions.addType(x, (String)actionDefinition.getValue());
        }
        return null;
    }

    static Map<String, Object> addField(Map<String, Object> event, Map<String, Object> fieldsToAdd) {
        Event tempEvent = new Event(event);
        CommonActions.addField(tempEvent, fieldsToAdd);
        return tempEvent.getData();
    }

    static void addField(co.elastic.logstash.api.Event evt, Map<String, Object> fieldsToAdd) {
        try {
            for (Map.Entry<String, Object> entry : fieldsToAdd.entrySet()) {
                String keyToSet = StringInterpolation.evaluate(evt, entry.getKey());
                Object val = evt.getField(keyToSet);
                Object valueToSet = entry.getValue();
                Object object = valueToSet = valueToSet instanceof String ? StringInterpolation.evaluate(evt, (String)entry.getValue()) : entry.getValue();
                if (val == null) {
                    evt.setField(keyToSet, valueToSet);
                    continue;
                }
                if (val instanceof List) {
                    ((List)val).add(valueToSet);
                    evt.setField(keyToSet, val);
                    continue;
                }
                RubyArray list = RubyArray.newArray((Ruby)RubyUtil.RUBY, (int)2);
                list.add(val);
                list.add(valueToSet);
                evt.setField(keyToSet, list);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static Map<String, Object> addTag(Map<String, Object> e, List<Object> tags) {
        Event tempEvent = new Event(e);
        CommonActions.addTag(tempEvent, tags);
        return tempEvent.getData();
    }

    static void addTag(co.elastic.logstash.api.Event evt, List<Object> tags) {
        try {
            for (Object o : tags) {
                String tagToAdd = StringInterpolation.evaluate(evt, o.toString());
                evt.tag(tagToAdd);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static Map<String, Object> addType(Map<String, Object> event, String type) {
        event.putIfAbsent("type", type);
        return event;
    }

    static void removeField(co.elastic.logstash.api.Event evt, List<String> fieldsToRemove) {
        try {
            for (String s : fieldsToRemove) {
                String fieldToRemove = StringInterpolation.evaluate(evt, s);
                evt.remove(fieldToRemove);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static void removeTag(co.elastic.logstash.api.Event evt, List<String> tagsToRemove) {
        List tags;
        Object o = evt.getField("tags");
        if (o instanceof List && (tags = (List)o).size() > 0) {
            try {
                for (String s : tagsToRemove) {
                    String tagToRemove = StringInterpolation.evaluate(evt, s);
                    tags.remove(tagToRemove);
                }
                evt.setField("tags", tags);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

