/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationExtensionsClientOutputsConverter {
    private final JsonConverter jsonConverter;

    public AuthenticationExtensionsClientOutputsConverter(@NonNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.jsonConverter = objectConverter.getJsonConverter();
    }

    public <T extends ExtensionClientOutput> @Nullable AuthenticationExtensionsClientOutputs<T> convert(@NonNull String value) {
        try {
            AssertUtil.notNull((Object)value, (String)"value must not be null");
            return (AuthenticationExtensionsClientOutputs)this.jsonConverter.readValue(value, new TypeReference<AuthenticationExtensionsClientOutputs<T>>(){});
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    public <T extends ExtensionClientOutput> @NonNull String convertToString(@NonNull AuthenticationExtensionsClientOutputs<T> value) {
        try {
            AssertUtil.notNull(value, (String)"value must not be null");
            return this.jsonConverter.writeValueAsString(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }
}

