/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.jpa;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.query.BindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmExpressibleAccessor;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.service.ServiceRegistry;

public class ParameterCollector
extends BaseSemanticQueryWalker {
    private Set<SqmParameter<?>> parameterExpressions;
    private final Consumer<SqmParameter<?>> consumer;
    private SqmExpressibleAccessor<?> inferenceBasis;

    public static Set<SqmParameter<?>> collectParameters(SqmStatement<?> statement, Consumer<SqmParameter<?>> consumer, ServiceRegistry serviceRegistry) {
        ParameterCollector collector = new ParameterCollector(serviceRegistry, consumer);
        statement.accept(collector);
        return collector.parameterExpressions == null ? Collections.emptySet() : collector.parameterExpressions;
    }

    private ParameterCollector(ServiceRegistry serviceRegistry, Consumer<SqmParameter<?>> consumer) {
        super(serviceRegistry);
        this.consumer = consumer;
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter<?> expression) {
        return this.visitParameter(expression);
    }

    @Override
    public Object visitNamedParameterExpression(SqmNamedParameter<?> expression) {
        return this.visitParameter(expression);
    }

    @Override
    public SqmJpaCriteriaParameterWrapper<?> visitJpaCriteriaParameter(JpaCriteriaParameter<?> expression) {
        return this.visitParameter(new SqmJpaCriteriaParameterWrapper(this.getInferredParameterType(expression), expression, expression.nodeBuilder()));
    }

    @Override
    public Object visitFunction(SqmFunction<?> sqmFunction) {
        SqmExpressibleAccessor<?> current = this.inferenceBasis;
        this.inferenceBasis = null;
        super.visitFunction(sqmFunction);
        this.inferenceBasis = current;
        return sqmFunction;
    }

    private <T> BindableType<T> getInferredParameterType(JpaCriteriaParameter<?> expression) {
        SqmExpressible<?> expressible;
        BindableType<?> parameterType = null;
        if (this.inferenceBasis != null && (expressible = this.inferenceBasis.getExpressible()) != null) {
            parameterType = expressible;
        }
        if (parameterType == null) {
            parameterType = expression.getHibernateType();
        }
        return parameterType;
    }

    private <T extends SqmParameter<?>> T visitParameter(T param) {
        if (this.parameterExpressions == null) {
            this.parameterExpressions = new HashSet();
        }
        this.parameterExpressions.add(param);
        this.consumer.accept(param);
        return param;
    }

    private <T> SqmJpaCriteriaParameterWrapper<T> visitParameter(SqmJpaCriteriaParameterWrapper<T> param) {
        if (this.parameterExpressions == null) {
            this.parameterExpressions = new HashSet();
        }
        this.parameterExpressions.add(param.getJpaCriteriaParameter());
        this.consumer.accept(param);
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withTypeInference(SqmExpressibleAccessor<?> inferenceBasis, SqmVisitableNode sqmVisitableNode) {
        SqmExpressibleAccessor<?> original = this.inferenceBasis;
        this.inferenceBasis = inferenceBasis;
        try {
            sqmVisitableNode.accept(this);
        }
        finally {
            this.inferenceBasis = original;
        }
    }

    @Override
    public Object visitSimpleCaseExpression(SqmCaseSimple<?, ?> expression) {
        SqmExpressibleAccessor<?> inferenceSupplier = this.inferenceBasis;
        this.withTypeInference(() -> {
            for (SqmCaseSimple.WhenFragment whenFragment : expression.getWhenFragments()) {
                SqmExpressible resolved = whenFragment.getCheckValue().getExpressible();
                if (resolved == null) continue;
                return resolved;
            }
            return null;
        }, expression.getFixture());
        SqmExpressibleAccessor<?> resolved = this.determineCurrentExpressible(expression);
        for (SqmCaseSimple.WhenFragment<?, ?> whenFragment : expression.getWhenFragments()) {
            this.withTypeInference(expression.getFixture(), whenFragment.getCheckValue());
            this.withTypeInference(resolved == null && inferenceSupplier != null ? inferenceSupplier : resolved, whenFragment.getResult());
            resolved = this.highestPrecedence(resolved, whenFragment.getResult());
        }
        if (expression.getOtherwise() != null) {
            this.withTypeInference(resolved == null && inferenceSupplier != null ? inferenceSupplier : resolved, expression.getOtherwise());
        }
        return expression;
    }

    @Override
    public Object visitSearchedCaseExpression(SqmCaseSearched<?> expression) {
        SqmExpressibleAccessor<?> inferenceSupplier = this.inferenceBasis;
        SqmExpressibleAccessor<?> resolved = this.determineCurrentExpressible(expression);
        for (SqmCaseSearched.WhenFragment<?> whenFragment : expression.getWhenFragments()) {
            this.withTypeInference(null, whenFragment.getPredicate());
            this.withTypeInference(resolved == null && inferenceSupplier != null ? inferenceSupplier : resolved, whenFragment.getResult());
            resolved = this.highestPrecedence(resolved, whenFragment.getResult());
        }
        if (expression.getOtherwise() != null) {
            this.withTypeInference(resolved == null && inferenceSupplier != null ? inferenceSupplier : resolved, expression.getOtherwise());
        }
        return expression;
    }

    private SqmExpressibleAccessor<?> highestPrecedence(SqmExpressibleAccessor<?> type1, SqmExpressibleAccessor<?> type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.getExpressible() != null) {
            return type1;
        }
        if (type2.getExpressible() != null) {
            return type2;
        }
        return type1;
    }

    private SqmExpressibleAccessor<?> determineCurrentExpressible(SqmExpression<?> expression) {
        if (expression.getExpressible() != null) {
            return () -> expression.getExpressible();
        }
        return null;
    }

    @Override
    public Object visitIndexedPluralAccessPath(SqmIndexedCollectionAccessPath<?> path) {
        path.getLhs().accept(this);
        this.withTypeInference(path.getPluralAttribute().getIndexPathSource(), path.getSelectorExpression());
        return path;
    }

    @Override
    public Object visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
        SqmExpressibleAccessor<?> original = this.inferenceBasis;
        this.inferenceBasis = null;
        super.visitIsEmptyPredicate(predicate);
        this.inferenceBasis = original;
        return predicate;
    }

    @Override
    public Object visitIsNullPredicate(SqmNullnessPredicate predicate) {
        SqmExpressibleAccessor<?> original = this.inferenceBasis;
        this.inferenceBasis = null;
        super.visitIsNullPredicate(predicate);
        this.inferenceBasis = original;
        return predicate;
    }

    @Override
    public Object visitComparisonPredicate(SqmComparisonPredicate predicate) {
        this.withTypeInference(predicate.getRightHandExpression(), predicate.getLeftHandExpression());
        this.withTypeInference(predicate.getLeftHandExpression(), predicate.getRightHandExpression());
        return predicate;
    }

    @Override
    public Object visitBetweenPredicate(SqmBetweenPredicate predicate) {
        this.withTypeInference(predicate.getLowerBound(), predicate.getExpression());
        this.withTypeInference(predicate.getExpression(), predicate.getLowerBound());
        this.withTypeInference(predicate.getExpression(), predicate.getUpperBound());
        return predicate;
    }

    @Override
    public Object visitLikePredicate(SqmLikePredicate predicate) {
        this.withTypeInference(predicate.getPattern(), predicate.getMatchExpression());
        this.withTypeInference(predicate.getMatchExpression(), predicate.getPattern());
        if (predicate.getEscapeCharacter() != null) {
            this.withTypeInference(predicate.getMatchExpression(), predicate.getEscapeCharacter());
        }
        return predicate;
    }

    @Override
    public Object visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
        this.withTypeInference(predicate.getPluralPath(), predicate.getLeftHandExpression());
        predicate.getPluralPath().accept(this);
        return predicate;
    }

    @Override
    public Object visitInListPredicate(SqmInListPredicate<?> predicate) {
        SqmExpression<?> firstListElement = predicate.getListExpressions().isEmpty() ? null : predicate.getListExpressions().get(0);
        this.withTypeInference(firstListElement, predicate.getTestExpression());
        for (SqmExpression<?> expression : predicate.getListExpressions()) {
            this.withTypeInference(predicate.getTestExpression(), expression);
        }
        return predicate;
    }

    @Override
    public Object visitInSubQueryPredicate(SqmInSubQueryPredicate<?> predicate) {
        this.withTypeInference(predicate.getSubQueryExpression(), predicate.getTestExpression());
        this.withTypeInference(predicate.getTestExpression(), predicate.getSubQueryExpression());
        return predicate;
    }
}

