/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.TableKeyExpressionCollector;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedUpdateHandler;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.exec.spi.JdbcOperationQueryUpdate;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class UpdateExecutionDelegate
implements TableBasedUpdateHandler.ExecutionDelegate {
    private final MultiTableSqmMutationConverter sqmConverter;
    private final TemporaryTable idTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final TableGroup updatingTableGroup;
    private final Predicate suppliedPredicate;
    private final EntityMappingType entityDescriptor;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final Map<TableReference, List<Assignment>> assignmentsByTable;
    private final SessionFactoryImplementor sessionFactory;

    public UpdateExecutionDelegate(MultiTableSqmMutationConverter sqmConverter, TemporaryTable idTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainParameterXref domainParameterXref, TableGroup updatingTableGroup, Map<String, TableReference> tableReferenceByAlias, List<Assignment> assignments, Predicate suppliedPredicate, Map<SqmParameter<?>, List<List<JdbcParameter>>> parameterResolutions, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, DomainQueryExecutionContext executionContext) {
        this.sqmConverter = sqmConverter;
        this.idTable = idTable;
        this.afterUseAction = afterUseAction;
        this.sessionUidAccess = sessionUidAccess;
        this.updatingTableGroup = updatingTableGroup;
        this.suppliedPredicate = suppliedPredicate;
        this.sessionFactory = executionContext.getSession().getFactory();
        ModelPartContainer updatingModelPart = updatingTableGroup.getModelPart();
        assert (updatingModelPart instanceof EntityMappingType);
        this.entityDescriptor = (EntityMappingType)updatingModelPart;
        this.assignmentsByTable = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, SqmUtil.generateJdbcParamsXref(domainParameterXref, () -> parameterResolutions), this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> updatingTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, executionContext.getSession());
        for (int i = 0; i < assignments.size(); ++i) {
            Assignment assignment = assignments.get(i);
            List<ColumnReference> assignmentColumnRefs = assignment.getAssignable().getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, tableReferenceByAlias);
                if (assignmentTableReference != null && assignmentTableReference != tableReference) {
                    throw new SemanticException("Assignment referred to columns from multiple tables: " + assignment.getAssignable());
                }
                assignmentTableReference = tableReference;
            }
            List<Assignment> assignmentsForTable = this.assignmentsByTable.get(assignmentTableReference);
            if (assignmentsForTable == null) {
                assignmentsForTable = new ArrayList<Assignment>();
                this.assignmentsByTable.put(assignmentTableReference, assignmentsForTable);
            }
            assignmentsForTable.add(assignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(ExecutionContext executionContext) {
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.idTable, executionContext);
        try {
            int rows = ExecuteWithTemporaryTableHelper.saveMatchingIdsIntoIdTable(this.sqmConverter, this.suppliedPredicate, this.idTable, this.sessionUidAccess, this.jdbcParameterBindings, executionContext);
            QuerySpec idTableSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.idTable, this.sessionUidAccess, this.entityDescriptor, executionContext);
            this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> this.updateTable(tableExpression, tableKeyColumnVisitationSupplier, rows, idTableSubQuery, executionContext));
            int n = rows;
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.idTable, this.sessionUidAccess, this.afterUseAction, executionContext);
        }
    }

    protected TableReference resolveTableReference(ColumnReference columnReference, Map<String, TableReference> tableReferenceByAlias) {
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + columnReference);
    }

    protected NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional());
        }
        return (NamedTableReference)tableReference;
    }

    private void updateTable(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, int expectedUpdateCount, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        Expression keyExpression;
        JdbcMutationExecutor jdbcMutationExecutor;
        JdbcServices jdbcServices;
        SqlAstTranslatorFactory sqlAstTranslatorFactory;
        TableReference updatingTableReference = this.updatingTableGroup.getTableReference(this.updatingTableGroup.getNavigablePath(), tableExpression, true);
        List<Assignment> assignments = this.assignmentsByTable.get(updatingTableReference);
        if (assignments == null || assignments.isEmpty()) {
            return;
        }
        NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        int updateCount = this.executeUpdate(idTableSubQuery, executionContext, assignments, dmlTableReference, sqlAstTranslatorFactory = (jdbcServices = this.sessionFactory.getJdbcServices()).getJdbcEnvironment().getSqlAstTranslatorFactory(), jdbcMutationExecutor = jdbcServices.getJdbcMutationExecutor(), keyExpression = this.resolveMutatingTableKeyExpression(tableExpression, tableKeyColumnVisitationSupplier));
        if (updateCount == expectedUpdateCount) {
            return;
        }
        if (this.isTableOptional(tableExpression)) {
            int insertCount = this.executeInsert(tableExpression, dmlTableReference, keyExpression, tableKeyColumnVisitationSupplier, idTableSubQuery, assignments, sqlAstTranslatorFactory, jdbcMutationExecutor, executionContext);
            assert (insertCount + updateCount == expectedUpdateCount);
        }
    }

    protected boolean isTableOptional(String tableExpression) {
        AbstractEntityPersister entityPersister = (AbstractEntityPersister)this.entityDescriptor.getEntityPersister();
        for (int i = 0; i < entityPersister.getTableSpan(); ++i) {
            if (!tableExpression.equals(entityPersister.getTableName(i)) || !entityPersister.isNullableTable(i)) continue;
            return true;
        }
        return false;
    }

    private int executeInsert(String targetTableExpression, NamedTableReference targetTableReference, Expression targetTableKeyExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, List<Assignment> assignments, SqlAstTranslatorFactory sqlAstTranslatorFactory, JdbcMutationExecutor jdbcMutationExecutor, ExecutionContext executionContext) {
        QuerySpec insertSourceSelectQuerySpec = UpdateExecutionDelegate.makeInsertSourceSelectQuerySpec(idTableSubQuery);
        QuerySpec existsSubQuerySpec = this.createExistsSubQuerySpec(targetTableExpression, tableKeyColumnVisitationSupplier, idTableSubQuery);
        insertSourceSelectQuerySpec.applyPredicate(new ExistsPredicate(existsSubQuerySpec, true, this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Boolean.class)));
        ArrayList<? extends Expression> targetColumnReferences = new ArrayList<Expression>();
        if (targetTableKeyExpression instanceof SqlTuple) {
            targetColumnReferences.addAll(((SqlTuple)targetTableKeyExpression).getExpressions());
        } else {
            targetColumnReferences.add((ColumnReference)targetTableKeyExpression);
        }
        for (Assignment assignment : assignments) {
            targetColumnReferences.addAll(assignment.getAssignable().getColumnReferences());
            insertSourceSelectQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(assignment.getAssignedValue()));
        }
        InsertSelectStatement insertSqlAst = new InsertSelectStatement(targetTableReference);
        insertSqlAst.addTargetColumnReferences(targetColumnReferences.toArray(new ColumnReference[0]));
        insertSqlAst.setSourceSelectStatement(insertSourceSelectQuerySpec);
        JdbcOperationQueryInsert jdbcInsert = sqlAstTranslatorFactory.buildInsertTranslator(this.sessionFactory, insertSqlAst).translate(this.jdbcParameterBindings, executionContext.getQueryOptions());
        return jdbcMutationExecutor.execute(jdbcInsert, this.jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    protected QuerySpec createExistsSubQuerySpec(String targetTableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery) {
        NamedTableReference existsTableReference = new NamedTableReference(targetTableExpression, "dml_");
        QuerySpec existsSubQuerySpec = new QuerySpec(false);
        existsSubQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new QueryLiteral<Integer>(1, this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class))));
        existsSubQuerySpec.getFromClause().addRoot(new TableGroupImpl(null, null, existsTableReference, this.entityDescriptor));
        TableKeyExpressionCollector existsKeyColumnCollector = new TableKeyExpressionCollector(this.entityDescriptor);
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(targetTableExpression));
            existsKeyColumnCollector.apply(new ColumnReference(existsTableReference, selection));
        });
        existsSubQuerySpec.applyPredicate(new ComparisonPredicate(existsKeyColumnCollector.buildKeyExpression(), ComparisonOperator.EQUAL, this.asExpression(idTableSubQuery.getSelectClause())));
        return existsSubQuerySpec;
    }

    protected static QuerySpec makeInsertSourceSelectQuerySpec(QuerySpec idTableSubQuery) {
        QuerySpec idTableQuerySpec = new QuerySpec(true);
        for (TableGroup root : idTableSubQuery.getFromClause().getRoots()) {
            idTableQuerySpec.getFromClause().addRoot(root);
        }
        for (SqlSelection sqlSelection : idTableSubQuery.getSelectClause().getSqlSelections()) {
            idTableQuerySpec.getSelectClause().addSqlSelection(sqlSelection);
        }
        idTableQuerySpec.applyPredicate(idTableSubQuery.getWhereClauseRestrictions());
        return idTableQuerySpec;
    }

    private int executeUpdate(QuerySpec idTableSubQuery, ExecutionContext executionContext, List<Assignment> assignments, NamedTableReference dmlTableReference, SqlAstTranslatorFactory sqlAstTranslatorFactory, JdbcMutationExecutor jdbcMutationExecutor, Expression keyExpression) {
        UpdateStatement sqlAst = new UpdateStatement(dmlTableReference, assignments, (Predicate)new InSubQueryPredicate(keyExpression, idTableSubQuery, false));
        JdbcOperationQueryUpdate jdbcUpdate = sqlAstTranslatorFactory.buildUpdateTranslator(this.sessionFactory, sqlAst).translate(this.jdbcParameterBindings, executionContext.getQueryOptions());
        int updateCount = jdbcMutationExecutor.execute(jdbcUpdate, this.jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        return updateCount;
    }

    protected Expression resolveMutatingTableKeyExpression(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier) {
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.entityDescriptor);
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(tableExpression));
            keyColumnCollector.apply(new ColumnReference((String)null, selection));
        });
        return keyColumnCollector.buildKeyExpression();
    }

    protected Expression asExpression(SelectClause selectClause) {
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        if (sqlSelections.size() == 1) {
            return sqlSelections.get(0).getExpression();
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>(sqlSelections.size());
        for (SqlSelection sqlSelection : sqlSelections) {
            expressions.add(sqlSelection.getExpression());
        }
        return new SqlTuple(expressions, null);
    }

    protected TemporaryTable getIdTable() {
        return this.idTable;
    }

    protected Predicate getSuppliedPredicate() {
        return this.suppliedPredicate;
    }

    protected MultiTableSqmMutationConverter getSqmConverter() {
        return this.sqmConverter;
    }

    protected Function<SharedSessionContractImplementor, String> getSessionUidAccess() {
        return this.sessionUidAccess;
    }

    protected JdbcParameterBindings getJdbcParameterBindings() {
        return this.jdbcParameterBindings;
    }

    protected EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected AfterUseAction getAfterUseAction() {
        return this.afterUseAction;
    }

    protected TableGroup getUpdatingTableGroup() {
        return this.updatingTableGroup;
    }

    protected Map<TableReference, List<Assignment>> getAssignmentsByTable() {
        return this.assignmentsByTable;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

