/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.http.HttpCookie;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class HttpResponseImpl
implements HttpResponse,
KeycloakTransaction {
    private final org.jboss.resteasy.spi.HttpResponse delegate;
    private Set<HttpCookie> cookies;
    private boolean transactionActive;
    private boolean writeCookiesOnTransactionComplete;

    public HttpResponseImpl(KeycloakSession session, org.jboss.resteasy.spi.HttpResponse delegate) {
        this.delegate = delegate;
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this);
    }

    public int getStatus() {
        return this.delegate.getStatus();
    }

    public void setStatus(int statusCode) {
        this.delegate.setStatus(statusCode);
    }

    public void addHeader(String name, String value) {
        this.checkCommitted();
        this.delegate.getOutputHeaders().add((Object)name, (Object)value);
    }

    public void setHeader(String name, String value) {
        this.checkCommitted();
        this.delegate.getOutputHeaders().putSingle((Object)name, (Object)value);
    }

    public void setCookieIfAbsent(HttpCookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie is null");
        }
        if (this.cookies == null) {
            this.cookies = new HashSet<HttpCookie>();
        }
        if (this.cookies.add(cookie)) {
            if (this.writeCookiesOnTransactionComplete) {
                return;
            }
            this.addHeader("Set-Cookie", cookie.toHeaderValue());
        }
    }

    public void setWriteCookiesOnTransactionComplete() {
        this.writeCookiesOnTransactionComplete = true;
    }

    private void checkCommitted() {
        if (this.delegate.isCommitted()) {
            throw new IllegalStateException("response already committed, can't be changed");
        }
    }

    public void begin() {
        this.transactionActive = true;
    }

    public void commit() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Transaction not active. Response already committed or rolled back");
        }
        try {
            this.addCookiesAfterTransaction();
        }
        finally {
            this.close();
        }
    }

    public void rollback() {
        this.close();
    }

    public void setRollbackOnly() {
    }

    public boolean getRollbackOnly() {
        return false;
    }

    public boolean isActive() {
        return this.transactionActive;
    }

    private void close() {
        this.transactionActive = false;
        this.cookies = null;
    }

    private void addCookiesAfterTransaction() {
        if (this.cookies == null || !this.writeCookiesOnTransactionComplete) {
            return;
        }
        for (HttpCookie cookie : this.cookies) {
            this.addHeader("Set-Cookie", cookie.toHeaderValue());
        }
    }
}

