/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AbstractFormAuthenticator;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.ServicesLogger;

public abstract class AbstractUsernameFormAuthenticator
extends AbstractFormAuthenticator {
    private static final Logger logger = Logger.getLogger(AbstractUsernameFormAuthenticator.class);
    public static final String REGISTRATION_FORM_ACTION = "registration_form";
    public static final String ATTEMPTED_USERNAME = "ATTEMPTED_USERNAME";
    protected static final String USER_SET_BEFORE_USERNAME_PASSWORD_AUTH = "USER_SET_BEFORE_USERNAME_PASSWORD_AUTH";

    public void action(AuthenticationFlowContext context) {
    }

    protected Response challenge(AuthenticationFlowContext context, String error) {
        return this.challenge(context, error, null);
    }

    protected Response challenge(AuthenticationFlowContext context, String error, String field) {
        LoginFormsProvider form = context.form().setExecution(context.getExecution().getId());
        if (error != null) {
            if (field != null) {
                form.addError(new FormMessage(field, error));
            } else {
                form.setError(error, new Object[0]);
            }
        }
        return this.createLoginForm(form);
    }

    protected Response createLoginForm(LoginFormsProvider form) {
        return form.createLoginUsernamePassword();
    }

    protected String disabledByBruteForceError() {
        return "invalidUserMessage";
    }

    protected String disabledByBruteForceFieldError() {
        return "username";
    }

    protected Response setDuplicateUserChallenge(AuthenticationFlowContext context, String eventError, String loginFormError, AuthenticationFlowError authenticatorError) {
        context.getEvent().error(eventError);
        Response challengeResponse = context.form().setError(loginFormError, new Object[0]).createLoginUsernamePassword();
        context.failureChallenge(authenticatorError, challengeResponse);
        return challengeResponse;
    }

    protected void runDefaultDummyHash(AuthenticationFlowContext context) {
        PasswordHashProvider hash = (PasswordHashProvider)context.getSession().getProvider(PasswordHashProvider.class, "pbkdf2-sha256");
        hash.encode("SlightlyLongerDummyPassword", 27500);
    }

    protected void dummyHash(AuthenticationFlowContext context) {
        PasswordPolicy policy = context.getRealm().getPasswordPolicy();
        if (policy == null) {
            this.runDefaultDummyHash(context);
            return;
        }
        PasswordHashProvider hash = (PasswordHashProvider)context.getSession().getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        if (hash == null) {
            this.runDefaultDummyHash(context);
            return;
        }
        hash.encode("SlightlyLongerDummyPassword", policy.getHashIterations());
    }

    public void testInvalidUser(AuthenticationFlowContext context, UserModel user) {
        if (user == null) {
            this.dummyHash(context);
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
        }
    }

    public boolean enabledUser(AuthenticationFlowContext context, UserModel user) {
        if (this.isDisabledByBruteForce(context, user)) {
            return false;
        }
        if (!user.isEnabled()) {
            context.getEvent().user(user);
            context.getEvent().error("user_disabled");
            Response challengeResponse = this.challenge(context, "accountDisabledMessage");
            context.forceChallenge(challengeResponse);
            return false;
        }
        return true;
    }

    public boolean validateUserAndPassword(AuthenticationFlowContext context, MultivaluedMap<String, String> inputData) {
        UserModel user = this.getUser(context, inputData);
        boolean shouldClearUserFromCtxAfterBadPassword = !this.isUserAlreadySetBeforeUsernamePasswordAuth(context);
        return user != null && this.validatePassword(context, user, inputData, shouldClearUserFromCtxAfterBadPassword) && this.validateUser(context, user, inputData);
    }

    public boolean validateUser(AuthenticationFlowContext context, MultivaluedMap<String, String> inputData) {
        UserModel user = this.getUser(context, inputData);
        return user != null && this.validateUser(context, user, inputData);
    }

    private UserModel getUser(AuthenticationFlowContext context, MultivaluedMap<String, String> inputData) {
        if (this.isUserAlreadySetBeforeUsernamePasswordAuth(context)) {
            UserModel user = context.getUser();
            this.testInvalidUser(context, user);
            return user;
        }
        context.clearUser();
        return this.getUserFromForm(context, inputData);
    }

    private UserModel getUserFromForm(AuthenticationFlowContext context, MultivaluedMap<String, String> inputData) {
        String username = (String)inputData.getFirst((Object)"username");
        if (username == null || username.isEmpty()) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return null;
        }
        username = username.trim();
        context.getEvent().detail("username", username);
        context.getAuthenticationSession().setAuthNote(ATTEMPTED_USERNAME, username);
        UserModel user = null;
        try {
            user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)username);
        }
        catch (ModelDuplicateException mde) {
            ServicesLogger.LOGGER.modelDuplicateException(mde);
            if (mde.getDuplicateFieldName() != null && mde.getDuplicateFieldName().equals("email")) {
                this.setDuplicateUserChallenge(context, "email_in_use", "emailExistsMessage", AuthenticationFlowError.INVALID_USER);
            } else {
                this.setDuplicateUserChallenge(context, "username_in_use", "usernameExistsMessage", AuthenticationFlowError.INVALID_USER);
            }
            return user;
        }
        this.testInvalidUser(context, user);
        return user;
    }

    private boolean validateUser(AuthenticationFlowContext context, UserModel user, MultivaluedMap<String, String> inputData) {
        boolean remember;
        if (!this.enabledUser(context, user)) {
            return false;
        }
        String rememberMe = (String)inputData.getFirst((Object)"rememberMe");
        boolean bl = remember = context.getRealm().isRememberMe() && rememberMe != null && rememberMe.equalsIgnoreCase("on");
        if (remember) {
            context.getAuthenticationSession().setAuthNote("remember_me", "true");
            context.getEvent().detail("remember_me", "true");
        } else {
            context.getAuthenticationSession().removeAuthNote("remember_me");
        }
        context.setUser(user);
        return true;
    }

    public boolean validatePassword(AuthenticationFlowContext context, UserModel user, MultivaluedMap<String, String> inputData, boolean clearUser) {
        String password = (String)inputData.getFirst((Object)"password");
        if (password == null || password.isEmpty()) {
            return this.badPasswordHandler(context, user, clearUser, true);
        }
        if (this.isDisabledByBruteForce(context, user)) {
            return false;
        }
        if (password != null && !password.isEmpty() && user.credentialManager().isValid(new CredentialInput[]{UserCredentialModel.password((String)password)})) {
            return true;
        }
        return this.badPasswordHandler(context, user, clearUser, false);
    }

    private boolean badPasswordHandler(AuthenticationFlowContext context, UserModel user, boolean clearUser, boolean isEmptyPassword) {
        context.getEvent().user(user);
        context.getEvent().error("invalid_user_credentials");
        if (this.isUserAlreadySetBeforeUsernamePasswordAuth(context)) {
            LoginFormsProvider form = context.form();
            form.setAttribute("usernameHidden", (Object)true);
            form.setAttribute("registrationDisabled", (Object)true);
        }
        Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "password");
        if (isEmptyPassword) {
            context.forceChallenge(challengeResponse);
        } else {
            context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challengeResponse);
        }
        if (clearUser) {
            context.clearUser();
        }
        return false;
    }

    protected boolean isDisabledByBruteForce(AuthenticationFlowContext context, UserModel user) {
        String bruteForceError = AuthenticatorUtils.getDisabledByBruteForceEventError(context, user);
        if (bruteForceError != null) {
            context.getEvent().user(user);
            context.getEvent().error(bruteForceError);
            Response challengeResponse = this.challenge(context, this.disabledByBruteForceError(), this.disabledByBruteForceFieldError());
            context.forceChallenge(challengeResponse);
            return true;
        }
        return false;
    }

    protected String getDefaultChallengeMessage(AuthenticationFlowContext context) {
        if (this.isUserAlreadySetBeforeUsernamePasswordAuth(context)) {
            return "invalidPasswordMessage";
        }
        return "invalidUserMessage";
    }

    protected boolean isUserAlreadySetBeforeUsernamePasswordAuth(AuthenticationFlowContext context) {
        String userSet = context.getAuthenticationSession().getAuthNote(USER_SET_BEFORE_USERNAME_PASSWORD_AUTH);
        return Boolean.parseBoolean(userSet);
    }
}

