/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.http;

import jakarta.ws.rs.core.Cookie;
import org.keycloak.common.util.ServerCookie;

public final class HttpCookie
extends Cookie {
    private final String comment;
    private final int maxAge;
    private final boolean secure;
    private final boolean httpOnly;
    private final ServerCookie.SameSiteAttributeValue sameSite;

    public HttpCookie(int version, String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly, ServerCookie.SameSiteAttributeValue sameSite) {
        super(name, value, path, domain, version);
        this.comment = comment;
        this.maxAge = maxAge;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.sameSite = sameSite;
    }

    public String toHeaderValue() {
        StringBuilder cookieBuf = new StringBuilder();
        ServerCookie.appendCookieValue((StringBuilder)cookieBuf, (int)this.getVersion(), (String)this.getName(), (String)this.getValue(), (String)this.getPath(), (String)this.getDomain(), (String)this.comment, (int)this.maxAge, (boolean)this.secure, (boolean)this.httpOnly, (ServerCookie.SameSiteAttributeValue)this.sameSite);
        return cookieBuf.toString();
    }
}

